/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.DeclarativeSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActionsBuilder;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class DeclarativeSlotManagerBuilder {
    private SlotMatchingStrategy slotMatchingStrategy = AnyMatchingSlotMatchingStrategy.INSTANCE;
    private ScheduledExecutor scheduledExecutor = TestingUtils.defaultScheduledExecutor();
    private Time taskManagerRequestTimeout = TestingUtils.infiniteTime();
    private Time slotRequestTimeout = TestingUtils.infiniteTime();
    private Time taskManagerTimeout = TestingUtils.infiniteTime();
    private boolean waitResultConsumedBeforeRelease = true;
    private WorkerResourceSpec defaultWorkerResourceSpec = WorkerResourceSpec.ZERO;
    private int numSlotsPerWorker = 1;
    private SlotManagerMetricGroup slotManagerMetricGroup = UnregisteredMetricGroups.createUnregisteredSlotManagerMetricGroup();
    private int maxSlotNum = (Integer)ResourceManagerOptions.MAX_SLOT_NUM.defaultValue();
    private int redundantTaskManagerNum = (Integer)ResourceManagerOptions.REDUNDANT_TASK_MANAGER_NUM.defaultValue();
    private ResourceTracker resourceTracker = new DefaultResourceTracker();
    private SlotTracker slotTracker = new DefaultSlotTracker();

    private DeclarativeSlotManagerBuilder() {
    }

    public static DeclarativeSlotManagerBuilder newBuilder() {
        return new DeclarativeSlotManagerBuilder();
    }

    public DeclarativeSlotManagerBuilder setScheduledExecutor(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        return this;
    }

    public DeclarativeSlotManagerBuilder setTaskManagerRequestTimeout(Time taskManagerRequestTimeout) {
        this.taskManagerRequestTimeout = taskManagerRequestTimeout;
        return this;
    }

    public DeclarativeSlotManagerBuilder setSlotRequestTimeout(Time slotRequestTimeout) {
        this.slotRequestTimeout = slotRequestTimeout;
        return this;
    }

    public DeclarativeSlotManagerBuilder setTaskManagerTimeout(Time taskManagerTimeout) {
        this.taskManagerTimeout = taskManagerTimeout;
        return this;
    }

    public DeclarativeSlotManagerBuilder setWaitResultConsumedBeforeRelease(boolean waitResultConsumedBeforeRelease) {
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        return this;
    }

    public DeclarativeSlotManagerBuilder setSlotMatchingStrategy(SlotMatchingStrategy slotMatchingStrategy) {
        this.slotMatchingStrategy = slotMatchingStrategy;
        return this;
    }

    public DeclarativeSlotManagerBuilder setDefaultWorkerResourceSpec(WorkerResourceSpec defaultWorkerResourceSpec) {
        this.defaultWorkerResourceSpec = defaultWorkerResourceSpec;
        return this;
    }

    public DeclarativeSlotManagerBuilder setNumSlotsPerWorker(int numSlotsPerWorker) {
        this.numSlotsPerWorker = numSlotsPerWorker;
        return this;
    }

    public DeclarativeSlotManagerBuilder setSlotManagerMetricGroup(SlotManagerMetricGroup slotManagerMetricGroup) {
        this.slotManagerMetricGroup = slotManagerMetricGroup;
        return this;
    }

    public DeclarativeSlotManagerBuilder setMaxSlotNum(int maxSlotNum) {
        this.maxSlotNum = maxSlotNum;
        return this;
    }

    public DeclarativeSlotManagerBuilder setRedundantTaskManagerNum(int redundantTaskManagerNum) {
        this.redundantTaskManagerNum = redundantTaskManagerNum;
        return this;
    }

    public DeclarativeSlotManagerBuilder setResourceTracker(ResourceTracker resourceTracker) {
        this.resourceTracker = resourceTracker;
        return this;
    }

    public DeclarativeSlotManagerBuilder setSlotTracker(SlotTracker slotTracker) {
        this.slotTracker = slotTracker;
        return this;
    }

    public DeclarativeSlotManager build() {
        SlotManagerConfiguration slotManagerConfiguration = new SlotManagerConfiguration(this.taskManagerRequestTimeout, this.slotRequestTimeout, this.taskManagerTimeout, this.waitResultConsumedBeforeRelease, this.slotMatchingStrategy, this.defaultWorkerResourceSpec, this.numSlotsPerWorker, this.maxSlotNum, new CPUResource(Double.MAX_VALUE), MemorySize.MAX_VALUE, this.redundantTaskManagerNum);
        return new DeclarativeSlotManager(this.scheduledExecutor, slotManagerConfiguration, this.slotManagerMetricGroup, this.resourceTracker, this.slotTracker);
    }

    public DeclarativeSlotManager buildAndStartWithDirectExec() {
        return this.buildAndStartWithDirectExec(ResourceManagerId.generate(), new TestingResourceActionsBuilder().build());
    }

    public DeclarativeSlotManager buildAndStartWithDirectExec(ResourceManagerId resourceManagerId, ResourceActions resourceManagerActions) {
        return this.buildAndStart(resourceManagerId, Executors.directExecutor(), resourceManagerActions);
    }

    public DeclarativeSlotManager buildAndStart(ResourceManagerId resourceManagerId, Executor executor, ResourceActions resourceManagerActions) {
        DeclarativeSlotManager slotManager = this.build();
        slotManager.start(resourceManagerId, executor, resourceManagerActions);
        return slotManager;
    }
}

