/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.io.network.netty.InboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.OutboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.Prio0InboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.Prio1InboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.Prio0OutboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.Prio1OutboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLogger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;

public class RestExternalHandlersITCase
extends TestLogger {
    private static final Time timeout = Time.seconds((long)10L);
    private static final String REQUEST_URL = "/nonExisting1";
    private static final String REDIRECT1_URL = "/nonExisting2";
    private static final String REDIRECT2_URL = "/nonExisting3";
    private RestServerEndpoint serverEndpoint;
    private RestClient restClient;
    private InetSocketAddress serverAddress;
    @RegisterExtension
    static final Extension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(InboundChannelHandlerFactory.class, new String[]{Prio0InboundChannelHandlerFactory.class.getCanonicalName(), Prio1InboundChannelHandlerFactory.class.getCanonicalName()}).withServiceEntry(OutboundChannelHandlerFactory.class, new String[]{Prio0OutboundChannelHandlerFactory.class.getCanonicalName(), Prio1OutboundChannelHandlerFactory.class.getCanonicalName()}).build();
    private final Configuration config = RestExternalHandlersITCase.getBaseConfig();

    private static Configuration getBaseConfig() {
        String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = new Configuration();
        config.setString(RestOptions.BIND_PORT, "0");
        config.setString(RestOptions.BIND_ADDRESS, loopbackAddress);
        config.setString(RestOptions.ADDRESS, loopbackAddress);
        config.setString(Prio0OutboundChannelHandlerFactory.REDIRECT_TO_URL, REDIRECT1_URL);
        config.setString(Prio0InboundChannelHandlerFactory.REDIRECT_FROM_URL, REDIRECT1_URL);
        config.setString(Prio0InboundChannelHandlerFactory.REDIRECT_TO_URL, REDIRECT2_URL);
        return config;
    }

    @BeforeEach
    private void setup() throws Exception {
        this.serverEndpoint = TestRestServerEndpoint.builder(this.config).buildAndStart();
        this.restClient = new TestRestClient(this.config);
        this.serverAddress = this.serverEndpoint.getServerAddress();
    }

    @AfterEach
    private void teardown() throws Exception {
        if (this.restClient != null) {
            this.restClient.shutdown(timeout);
            this.restClient = null;
        }
        if (this.serverEndpoint != null) {
            this.serverEndpoint.closeAsync().get(timeout.getSize(), timeout.getUnit());
            this.serverEndpoint = null;
        }
    }

    @Test
    void testHandlersMustBeLoaded() throws Exception {
        Assertions.assertEquals((int)this.serverEndpoint.inboundChannelHandlerFactories.size(), (int)2);
        Assertions.assertTrue((boolean)(this.serverEndpoint.inboundChannelHandlerFactories.get(0) instanceof Prio1InboundChannelHandlerFactory));
        Assertions.assertTrue((boolean)(this.serverEndpoint.inboundChannelHandlerFactories.get(1) instanceof Prio0InboundChannelHandlerFactory));
        Assertions.assertEquals((int)this.restClient.outboundChannelHandlerFactories.size(), (int)2);
        Assertions.assertTrue((boolean)(this.restClient.outboundChannelHandlerFactories.get(0) instanceof Prio1OutboundChannelHandlerFactory));
        Assertions.assertTrue((boolean)(this.restClient.outboundChannelHandlerFactories.get(1) instanceof Prio0OutboundChannelHandlerFactory));
        try {
            CompletableFuture<TestResponse> response = this.sendRequestToTestHandler(new TestRequest());
            response.get();
            Assertions.fail((String)"Request must fail with 2 times redirected URL");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(REDIRECT2_URL));
        }
    }

    private CompletableFuture<TestResponse> sendRequestToTestHandler(TestRequest testRequest) {
        try {
            return this.restClient.sendRequest(this.serverAddress.getHostName(), this.serverAddress.getPort(), (MessageHeaders)new TestHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)testRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TestHeaders
    implements MessageHeaders<TestRequest, TestResponse, EmptyMessageParameters> {
        private TestHeaders() {
        }

        public HttpMethodWrapper getHttpMethod() {
            return HttpMethodWrapper.POST;
        }

        public String getTargetRestEndpointURL() {
            return RestExternalHandlersITCase.REQUEST_URL;
        }

        public Class<TestRequest> getRequestClass() {
            return TestRequest.class;
        }

        public Class<TestResponse> getResponseClass() {
            return TestResponse.class;
        }

        public HttpResponseStatus getResponseStatusCode() {
            return HttpResponseStatus.OK;
        }

        public String getDescription() {
            return "";
        }

        public EmptyMessageParameters getUnresolvedMessageParameters() {
            return EmptyMessageParameters.getInstance();
        }
    }

    private static class TestResponse
    implements ResponseBody {
        private TestResponse() {
        }
    }

    private static class TestRequest
    implements RequestBody {
        private TestRequest() {
        }
    }

    static class TestRestClient
    extends RestClient {
        TestRestClient(Configuration configuration) throws ConfigurationException {
            super(configuration, (Executor)TestingUtils.defaultExecutor());
        }
    }
}

