/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultResultPartitionTest
extends TestLogger {
    private static final TestResultPartitionStateSupplier resultPartitionState = new TestResultPartitionStateSupplier();
    private final IntermediateResultPartitionID resultPartitionId = new IntermediateResultPartitionID();
    private final IntermediateDataSetID intermediateResultId = new IntermediateDataSetID();
    private DefaultResultPartition resultPartition;
    private final Map<IntermediateResultPartitionID, ConsumerVertexGroup> consumerVertexGroups = new HashMap<IntermediateResultPartitionID, ConsumerVertexGroup>();

    @Before
    public void setUp() {
        this.resultPartition = new DefaultResultPartition(this.resultPartitionId, this.intermediateResultId, ResultPartitionType.BLOCKING, (Supplier)resultPartitionState, () -> this.consumerVertexGroups.get(this.resultPartitionId), () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Test
    public void testGetPartitionState() {
        for (ResultPartitionState state : ResultPartitionState.values()) {
            resultPartitionState.setResultPartitionState(state);
            Assert.assertEquals((Object)state, (Object)this.resultPartition.getState());
        }
    }

    @Test
    public void testGetConsumerVertexGroup() {
        Assert.assertFalse((boolean)this.resultPartition.getConsumerVertexGroup().isPresent());
        ExecutionVertexID executionVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        this.consumerVertexGroups.put(this.resultPartition.getId(), ConsumerVertexGroup.fromSingleVertex((ExecutionVertexID)executionVertexId));
        Assert.assertTrue((boolean)this.resultPartition.getConsumerVertexGroup().isPresent());
        MatcherAssert.assertThat(this.resultPartition.getConsumerVertexGroup().get(), (Matcher)Matchers.contains((Object[])new ExecutionVertexID[]{executionVertexId}));
    }

    private static class TestResultPartitionStateSupplier
    implements Supplier<ResultPartitionState> {
        private ResultPartitionState resultPartitionState;

        private TestResultPartitionStateSupplier() {
        }

        void setResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
        }

        @Override
        public ResultPartitionState get() {
            return this.resultPartitionState;
        }
    }
}

