/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.util.OptionalInt;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.throughput.BufferDebloater;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class BufferDebloaterTest
extends TestLogger {
    @Test
    public void testZeroBuffersInUse() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50, 2400).withNumberOfBuffersInUse(0).withThroughput(1200L).expectBufferSize(1200);
    }

    @Test
    public void testCorrectBufferSizeCalculation() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 1100).withNumberOfBuffersInUse(16).withThroughput(3333L).expectBufferSize(249);
    }

    @Test
    public void testCalculatedBufferSizeLessThanMin() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(250, 1100).withNumberOfBuffersInUse(16).withThroughput(3333L).expectBufferSize(250);
    }

    @Test
    public void testCalculatedBufferSizeForThroughputZero() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 1100).withNumberOfBuffersInUse(16).withThroughput(0L).expectBufferSize(50);
    }

    @Test
    public void testConfiguredConsumptionTimeIsTooLow() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(7).withBufferSize(50, 1100).withNumberOfBuffersInUse(16).withThroughput(3333L).expectBufferSize(50);
    }

    @Test
    public void testCalculatedBufferSizeGreaterThanMax() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 248).withNumberOfBuffersInUse(16).withThroughput(3333L).expectNoChangeInBufferSize();
    }

    @Test
    public void testCalculatedBufferSlightlyDifferentFromCurrentOne() {
        BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1200).withBufferSize(50, 250).withNumberOfBuffersInUse(16).withThroughput(3333L).expectNoChangeInBufferSize();
    }

    @Test
    public void testAnnouncedMaxBufferSizeDespiteLastDiffLessThanThreshold() {
        boolean numberOfBuffersInUse = true;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50, 1100).withNumberOfBuffersInUse(1).withThroughput(500L).expectBufferSize(500);
        bufferDebloater.recalculateBufferSize(1000L, 1);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)1000));
        bufferDebloater.recalculateBufferSize(2000L, 1);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)1100));
        bufferDebloater.recalculateBufferSize(2000L, 1);
    }

    @Test
    public void testAnnouncedMinBufferSizeEvenDespiteLastDiffLessThanThreshold() {
        boolean numberOfBuffersInUse = true;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(50, 1100).withNumberOfBuffersInUse(1).withThroughput(60L).expectBufferSize(60);
        bufferDebloater.recalculateBufferSize(60L, 1);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)60));
        bufferDebloater.recalculateBufferSize(40L, 1);
        MatcherAssert.assertThat((Object)bufferDebloater.getLastBufferSize(), (Matcher)CoreMatchers.is((Object)50));
        bufferDebloater.recalculateBufferSize(40L, 1);
    }

    @Test
    public void testSkipUpdate() {
        int maxBufferSize = 32768;
        int minBufferSize = 256;
        double threshold = 0.3;
        BufferDebloater bufferDebloater = BufferDebloaterTest.testBufferDebloater().withDebloatTarget(1000).withBufferSize(minBufferSize, maxBufferSize).withThresholdPercentages((int)(threshold * 100.0)).getBufferDebloater();
        int currentBufferSize = maxBufferSize / 2;
        OptionalInt optionalInt = bufferDebloater.recalculateBufferSize((long)currentBufferSize, 1);
        Assert.assertTrue((boolean)optionalInt.isPresent());
        Assert.assertEquals((long)currentBufferSize, (long)optionalInt.getAsInt());
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize - 1));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize + 1));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize - (int)((double)currentBufferSize * threshold) + 1));
        Assert.assertTrue((boolean)bufferDebloater.skipUpdate(currentBufferSize + (int)((double)currentBufferSize * threshold) - 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(currentBufferSize - (int)((double)currentBufferSize * threshold)));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(currentBufferSize + (int)((double)currentBufferSize * threshold)));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(minBufferSize + 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(minBufferSize));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(maxBufferSize - 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(maxBufferSize));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(maxBufferSize + 1));
        Assert.assertFalse((boolean)bufferDebloater.skipUpdate(minBufferSize - 1));
    }

    public static BufferDebloaterTestBuilder testBufferDebloater() {
        return new BufferDebloaterTestBuilder();
    }

    private static class BufferDebloaterTestBuilder {
        private int numberOfBuffersInUse;
        private long throughput;
        private int minBufferSize;
        private int maxBufferSize;
        private int debloatTarget;
        private int thresholdPercentages = (Integer)TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES.defaultValue();

        private BufferDebloaterTestBuilder() {
        }

        public BufferDebloaterTestBuilder withNumberOfBuffersInUse(Integer numberOfBuffersInUse) {
            this.numberOfBuffersInUse = numberOfBuffersInUse;
            return this;
        }

        public BufferDebloaterTestBuilder withThroughput(long throughput) {
            this.throughput = throughput;
            return this;
        }

        public BufferDebloaterTestBuilder withBufferSize(int minBufferSize, int maxBufferSize) {
            this.minBufferSize = minBufferSize;
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public BufferDebloaterTestBuilder withDebloatTarget(int debloatTarget) {
            this.debloatTarget = debloatTarget;
            return this;
        }

        public BufferDebloaterTestBuilder withThresholdPercentages(int thresholdPercentages) {
            this.thresholdPercentages = thresholdPercentages;
            return this;
        }

        public void expectNoChangeInBufferSize() {
            BufferDebloater bufferDebloater = this.getBufferDebloater();
            OptionalInt newBufferSize = bufferDebloater.recalculateBufferSize(this.throughput, this.numberOfBuffersInUse);
            Assert.assertFalse((boolean)newBufferSize.isPresent());
        }

        public BufferDebloater expectBufferSize(int expectedBufferSize) {
            BufferDebloater bufferDebloater = this.getBufferDebloater();
            OptionalInt newBufferSize = bufferDebloater.recalculateBufferSize(this.throughput, this.numberOfBuffersInUse);
            Assert.assertTrue((boolean)newBufferSize.isPresent());
            MatcherAssert.assertThat((Object)newBufferSize.getAsInt(), (Matcher)CoreMatchers.is((Object)expectedBufferSize));
            return bufferDebloater;
        }

        private BufferDebloater getBufferDebloater() {
            return new BufferDebloater(0, (long)this.debloatTarget, this.maxBufferSize, this.minBufferSize, this.thresholdPercentages, 1L);
        }
    }
}

