/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.checkpoint.Checkpoint;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointPlan;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorInfo;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PendingCheckpoint
implements Checkpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointCoordinator.class);
    private final Object lock = new Object();
    private final JobID jobId;
    private final long checkpointId;
    private final long checkpointTimestamp;
    private final Map<OperatorID, OperatorState> operatorStates;
    private final CheckpointPlan checkpointPlan;
    private final Map<ExecutionAttemptID, ExecutionVertex> notYetAcknowledgedTasks;
    private final Set<OperatorID> notYetAcknowledgedOperatorCoordinators;
    private final List<MasterState> masterStates;
    private final Set<String> notYetAcknowledgedMasterStates;
    private final Set<ExecutionAttemptID> acknowledgedTasks;
    private final CheckpointProperties props;
    private final CompletableFuture<CompletedCheckpoint> onCompletionPromise;
    @Nullable
    private final PendingCheckpointStats pendingCheckpointStats;
    private final CompletableFuture<Void> masterTriggerCompletionPromise;
    @Nullable
    private CheckpointStorageLocation targetLocation;
    private int numAcknowledgedTasks;
    private boolean disposed;
    private boolean discarded;
    private volatile ScheduledFuture<?> cancellerHandle;
    private CheckpointException failureCause;

    public PendingCheckpoint(JobID jobId, long checkpointId, long checkpointTimestamp, CheckpointPlan checkpointPlan, Collection<OperatorID> operatorCoordinatorsToConfirm, Collection<String> masterStateIdentifiers, CheckpointProperties props, CompletableFuture<CompletedCheckpoint> onCompletionPromise, @Nullable PendingCheckpointStats pendingCheckpointStats, CompletableFuture<Void> masterTriggerCompletionPromise) {
        Preconditions.checkArgument((checkpointPlan.getTasksToWaitFor().size() > 0 ? 1 : 0) != 0, (Object)"Checkpoint needs at least one vertex that commits the checkpoint");
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.checkpointId = checkpointId;
        this.checkpointTimestamp = checkpointTimestamp;
        this.checkpointPlan = (CheckpointPlan)Preconditions.checkNotNull((Object)checkpointPlan);
        this.notYetAcknowledgedTasks = new HashMap<ExecutionAttemptID, ExecutionVertex>(checkpointPlan.getTasksToWaitFor().size());
        for (Execution execution : checkpointPlan.getTasksToWaitFor()) {
            this.notYetAcknowledgedTasks.put(execution.getAttemptId(), execution.getVertex());
        }
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
        this.operatorStates = new HashMap<OperatorID, OperatorState>();
        this.masterStates = new ArrayList<MasterState>(masterStateIdentifiers.size());
        this.notYetAcknowledgedMasterStates = masterStateIdentifiers.isEmpty() ? Collections.emptySet() : new HashSet<String>(masterStateIdentifiers);
        this.notYetAcknowledgedOperatorCoordinators = operatorCoordinatorsToConfirm.isEmpty() ? Collections.emptySet() : new HashSet<OperatorID>(operatorCoordinatorsToConfirm);
        this.acknowledgedTasks = new HashSet<ExecutionAttemptID>(checkpointPlan.getTasksToWaitFor().size());
        this.onCompletionPromise = (CompletableFuture)Preconditions.checkNotNull(onCompletionPromise);
        this.pendingCheckpointStats = pendingCheckpointStats;
        this.masterTriggerCompletionPromise = (CompletableFuture)Preconditions.checkNotNull(masterTriggerCompletionPromise);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    @Deprecated
    public long getCheckpointId() {
        return this.getCheckpointID();
    }

    @Override
    public long getCheckpointID() {
        return this.checkpointId;
    }

    public void setCheckpointTargetLocation(CheckpointStorageLocation targetLocation) {
        this.targetLocation = targetLocation;
    }

    public CheckpointStorageLocation getCheckpointStorageLocation() {
        return this.targetLocation;
    }

    public long getCheckpointTimestamp() {
        return this.checkpointTimestamp;
    }

    public int getNumberOfNonAcknowledgedTasks() {
        return this.notYetAcknowledgedTasks.size();
    }

    public int getNumberOfNonAcknowledgedOperatorCoordinators() {
        return this.notYetAcknowledgedOperatorCoordinators.size();
    }

    public CheckpointPlan getCheckpointPlan() {
        return this.checkpointPlan;
    }

    public int getNumberOfAcknowledgedTasks() {
        return this.numAcknowledgedTasks;
    }

    public Map<OperatorID, OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public List<MasterState> getMasterStates() {
        return this.masterStates;
    }

    public boolean isFullyAcknowledged() {
        return this.areTasksFullyAcknowledged() && this.areCoordinatorsFullyAcknowledged() && this.areMasterStatesFullyAcknowledged();
    }

    boolean areMasterStatesFullyAcknowledged() {
        return this.notYetAcknowledgedMasterStates.isEmpty() && !this.disposed;
    }

    boolean areCoordinatorsFullyAcknowledged() {
        return this.notYetAcknowledgedOperatorCoordinators.isEmpty() && !this.disposed;
    }

    boolean areTasksFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.isEmpty() && !this.disposed;
    }

    public boolean isAcknowledgedBy(ExecutionAttemptID executionAttemptId) {
        return !this.notYetAcknowledgedTasks.containsKey(executionAttemptId);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean canBeSubsumed() {
        return !this.props.isSavepoint();
    }

    CheckpointProperties getProps() {
        return this.props;
    }

    public boolean setCancellerHandle(ScheduledFuture<?> cancellerHandle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancellerHandle == null) {
                if (!this.disposed) {
                    this.cancellerHandle = cancellerHandle;
                    return true;
                }
                return false;
            }
            throw new IllegalStateException("A canceller handle was already set");
        }
    }

    public CheckpointException getFailureCause() {
        return this.failureCause;
    }

    public CompletableFuture<CompletedCheckpoint> getCompletionFuture() {
        return this.onCompletionPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletedCheckpoint finalizeCheckpoint(CheckpointsCleaner checkpointsCleaner, Runnable postCleanup, Executor executor) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.isDisposed() ? 1 : 0) != 0, (Object)"checkpoint is discarded");
            Preconditions.checkState((boolean)this.isFullyAcknowledged(), (Object)"Pending checkpoint has not been fully acknowledged yet");
            try {
                CompletedCheckpointStorageLocation finalizedLocation;
                this.checkpointPlan.fulfillFinishedTaskStatus(this.operatorStates);
                CheckpointMetadata savepoint = new CheckpointMetadata(this.checkpointId, this.operatorStates.values(), this.masterStates);
                try (CheckpointMetadataOutputStream out = this.targetLocation.createMetadataOutputStream();){
                    Checkpoints.storeCheckpointMetadata(savepoint, (OutputStream)((Object)out));
                    finalizedLocation = out.closeAndFinalizeCheckpoint();
                }
                CompletedCheckpoint completed = new CompletedCheckpoint(this.jobId, this.checkpointId, this.checkpointTimestamp, System.currentTimeMillis(), this.operatorStates, this.masterStates, this.props, finalizedLocation, this.toCompletedCheckpointStats(finalizedLocation));
                this.onCompletionPromise.complete(completed);
                this.dispose(false, checkpointsCleaner, postCleanup, executor);
                return completed;
            }
            catch (Throwable t) {
                this.onCompletionPromise.completeExceptionally(t);
                ExceptionUtils.rethrowIOException((Throwable)t);
                return null;
            }
        }
    }

    @Nullable
    private CompletedCheckpointStats toCompletedCheckpointStats(CompletedCheckpointStorageLocation finalizedLocation) {
        return this.pendingCheckpointStats != null ? this.pendingCheckpointStats.toCompletedCheckpointStats(finalizedLocation.getExternalPointer()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAcknowledgeResult acknowledgeTask(ExecutionAttemptID executionAttemptId, TaskStateSnapshot operatorSubtaskStates, CheckpointMetrics metrics) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                return TaskAcknowledgeResult.DISCARDED;
            }
            ExecutionVertex vertex = this.notYetAcknowledgedTasks.remove(executionAttemptId);
            if (vertex == null) {
                if (this.acknowledgedTasks.contains(executionAttemptId)) {
                    return TaskAcknowledgeResult.DUPLICATE;
                }
                return TaskAcknowledgeResult.UNKNOWN;
            }
            this.acknowledgedTasks.add(executionAttemptId);
            long ackTimestamp = System.currentTimeMillis();
            if (operatorSubtaskStates != null && operatorSubtaskStates.isTaskDeployedAsFinished()) {
                this.checkpointPlan.reportTaskFinishedOnRestore(vertex);
            } else {
                List<OperatorIDPair> operatorIDs = vertex.getJobVertex().getOperatorIDs();
                for (OperatorIDPair operatorID : operatorIDs) {
                    this.updateOperatorState(vertex, operatorSubtaskStates, operatorID);
                }
                if (operatorSubtaskStates != null && operatorSubtaskStates.isTaskFinished()) {
                    this.checkpointPlan.reportTaskHasFinishedOperators(vertex);
                }
            }
            ++this.numAcknowledgedTasks;
            if (this.pendingCheckpointStats != null) {
                long alignmentDurationMillis = metrics.getAlignmentDurationNanos() / 1000000L;
                long checkpointStartDelayMillis = metrics.getCheckpointStartDelayNanos() / 1000000L;
                SubtaskStateStats subtaskStateStats = new SubtaskStateStats(vertex.getParallelSubtaskIndex(), ackTimestamp, metrics.getBytesPersistedOfThisCheckpoint(), metrics.getTotalBytesPersisted(), metrics.getSyncDurationMillis(), metrics.getAsyncDurationMillis(), metrics.getBytesProcessedDuringAlignment(), metrics.getBytesPersistedDuringAlignment(), alignmentDurationMillis, checkpointStartDelayMillis, metrics.getUnalignedCheckpoint(), true);
                LOG.trace("Checkpoint {} stats for {}: size={}Kb, duration={}ms, sync part={}ms, async part={}ms", new Object[]{this.checkpointId, vertex.getTaskNameWithSubtaskIndex(), subtaskStateStats.getStateSize() == 0L ? 0L : subtaskStateStats.getStateSize() / 1024L, subtaskStateStats.getEndToEndDuration(this.pendingCheckpointStats.getTriggerTimestamp()), subtaskStateStats.getSyncCheckpointDuration(), subtaskStateStats.getAsyncCheckpointDuration()});
                this.pendingCheckpointStats.reportSubtaskStats(vertex.getJobvertexId(), subtaskStateStats);
            }
            return TaskAcknowledgeResult.SUCCESS;
        }
    }

    private void updateOperatorState(ExecutionVertex vertex, TaskStateSnapshot operatorSubtaskStates, OperatorIDPair operatorID) {
        OperatorSubtaskState operatorSubtaskState;
        OperatorState operatorState = this.operatorStates.get((Object)operatorID.getGeneratedOperatorID());
        if (operatorState == null) {
            operatorState = new OperatorState(operatorID.getGeneratedOperatorID(), vertex.getTotalNumberOfParallelSubtasks(), vertex.getMaxParallelism());
            this.operatorStates.put(operatorID.getGeneratedOperatorID(), operatorState);
        }
        OperatorSubtaskState operatorSubtaskState2 = operatorSubtaskState = operatorSubtaskStates == null ? null : operatorSubtaskStates.getSubtaskStateByOperatorID(operatorID.getGeneratedOperatorID());
        if (operatorSubtaskState != null) {
            operatorState.putState(vertex.getParallelSubtaskIndex(), operatorSubtaskState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAcknowledgeResult acknowledgeCoordinatorState(OperatorInfo coordinatorInfo, @Nullable ByteStreamStateHandle stateHandle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed) {
                return TaskAcknowledgeResult.DISCARDED;
            }
            OperatorID operatorId = coordinatorInfo.operatorId();
            OperatorState operatorState = this.operatorStates.get((Object)operatorId);
            if (!this.notYetAcknowledgedOperatorCoordinators.remove((Object)operatorId)) {
                return operatorState != null && operatorState.getCoordinatorState() != null ? TaskAcknowledgeResult.DUPLICATE : TaskAcknowledgeResult.UNKNOWN;
            }
            if (operatorState == null) {
                operatorState = new OperatorState(operatorId, coordinatorInfo.currentParallelism(), coordinatorInfo.maxParallelism());
                this.operatorStates.put(operatorId, operatorState);
            }
            if (stateHandle != null) {
                operatorState.setCoordinatorState(stateHandle);
            }
            return TaskAcknowledgeResult.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMasterState(String identifier, @Nullable MasterState state) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.disposed && this.notYetAcknowledgedMasterStates.remove(identifier) && state != null) {
                this.masterStates.add(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(CheckpointFailureReason reason, @Nullable Throwable cause, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup, Executor executor, CheckpointStatsTracker statsTracker) {
        try {
            this.failureCause = new CheckpointException(reason, cause);
            this.onCompletionPromise.completeExceptionally(this.failureCause);
            this.masterTriggerCompletionPromise.completeExceptionally(this.failureCause);
            this.assertAbortSubsumedForced(reason);
        }
        finally {
            this.dispose(true, checkpointsCleaner, postCleanup, executor);
        }
    }

    private void assertAbortSubsumedForced(CheckpointFailureReason reason) {
        if (this.props.isSavepoint() && reason == CheckpointFailureReason.CHECKPOINT_SUBSUMED) {
            throw new IllegalStateException("Bug: savepoints must never be subsumed, the abort reason is : " + reason.message());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(boolean releaseState, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup, Executor executor) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.numAcknowledgedTasks = -1;
                checkpointsCleaner.cleanCheckpoint(this, releaseState, postCleanup, executor);
            }
            finally {
                this.disposed = true;
                this.notYetAcknowledgedTasks.clear();
                this.acknowledgedTasks.clear();
                this.cancelCanceller();
            }
        }
    }

    @Override
    public Checkpoint.DiscardObject markAsDiscarded() {
        return new PendingCheckpointDiscardObject();
    }

    private void cancelCanceller() {
        try {
            ScheduledFuture<?> canceller = this.cancellerHandle;
            if (canceller != null) {
                canceller.cancel(false);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while cancelling checkpoint timeout task", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("Pending Checkpoint %d @ %d - confirmed=%d, pending=%d", this.checkpointId, this.checkpointTimestamp, this.getNumberOfAcknowledgedTasks(), this.getNumberOfNonAcknowledgedTasks());
    }

    public class PendingCheckpointDiscardObject
    implements Checkpoint.DiscardObject {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard() {
            Object object = PendingCheckpoint.this.lock;
            synchronized (object) {
                if (PendingCheckpoint.this.discarded) {
                    Preconditions.checkState((boolean)PendingCheckpoint.this.disposed, (Object)"Checkpoint should be disposed before being discarded");
                    return;
                }
                PendingCheckpoint.this.discarded = true;
            }
            try {
                StateUtil.bestEffortDiscardAllStateObjects(PendingCheckpoint.this.operatorStates.values());
                if (PendingCheckpoint.this.targetLocation != null) {
                    PendingCheckpoint.this.targetLocation.disposeOnFailure();
                }
            }
            catch (Throwable t) {
                LOG.warn("Could not properly dispose the private states in the pending checkpoint {} of job {}.", new Object[]{PendingCheckpoint.this.checkpointId, PendingCheckpoint.this.jobId, t});
            }
            finally {
                PendingCheckpoint.this.operatorStates.clear();
            }
        }
    }

    public static enum TaskAcknowledgeResult {
        SUCCESS,
        DUPLICATE,
        UNKNOWN,
        DISCARDED;

    }
}

