/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;

public class TaskIOMetricGroup
extends ProxyMetricGroup<TaskMetricGroup> {
    private final Counter numBytesIn;
    private final Counter numBytesOut;
    private final SumCounter numRecordsIn;
    private final SumCounter numRecordsOut;
    private final Counter numBuffersOut;
    private final Counter numMailsProcessed;
    private final Meter numBytesInRate;
    private final Meter numBytesOutRate;
    private final Meter numRecordsInRate;
    private final Meter numRecordsOutRate;
    private final Meter numBuffersOutRate;
    private final TimerGauge idleTimePerSecond;
    private final Gauge<Double> busyTimePerSecond;
    private final Gauge<Long> backPressuredTimePerSecond;
    private final TimerGauge softBackPressuredTimePerSecond;
    private final TimerGauge hardBackPressuredTimePerSecond;
    private final Gauge<Long> maxSoftBackPressuredTime;
    private final Gauge<Long> maxHardBackPressuredTime;
    private final Meter mailboxThroughput;
    private final Histogram mailboxLatency;
    private final SizeGauge mailboxSize;
    private volatile boolean busyTimeEnabled;
    private final Map<IntermediateResultPartitionID, Counter> numBytesProducedOfPartitions = new HashMap<IntermediateResultPartitionID, Counter>();

    public TaskIOMetricGroup(TaskMetricGroup parent) {
        super(parent);
        this.numBytesIn = this.counter("numBytesIn");
        this.numBytesOut = this.counter("numBytesOut");
        this.numBytesInRate = this.meter("numBytesInPerSecond", new MeterView(this.numBytesIn));
        this.numBytesOutRate = this.meter("numBytesOutPerSecond", new MeterView(this.numBytesOut));
        this.numRecordsIn = this.counter("numRecordsIn", new SumCounter());
        this.numRecordsOut = this.counter("numRecordsOut", new SumCounter());
        this.numRecordsInRate = this.meter("numRecordsInPerSecond", new MeterView((Counter)this.numRecordsIn));
        this.numRecordsOutRate = this.meter("numRecordsOutPerSecond", new MeterView((Counter)this.numRecordsOut));
        this.numBuffersOut = this.counter("numBuffersOut");
        this.numBuffersOutRate = this.meter("numBuffersOutPerSecond", new MeterView(this.numBuffersOut));
        this.idleTimePerSecond = this.gauge("idleTimeMsPerSecond", new TimerGauge());
        this.softBackPressuredTimePerSecond = this.gauge("softBackPressuredTimeMsPerSecond", new TimerGauge());
        this.hardBackPressuredTimePerSecond = this.gauge("hardBackPressuredTimeMsPerSecond", new TimerGauge());
        this.backPressuredTimePerSecond = this.gauge("backPressuredTimeMsPerSecond", this::getBackPressuredTimeMsPerSecond);
        this.maxSoftBackPressuredTime = this.gauge("maxSoftBackPressureTimeMs", this.softBackPressuredTimePerSecond::getMaxSingleMeasurement);
        this.maxHardBackPressuredTime = this.gauge("maxHardBackPressureTimeMs", this.hardBackPressuredTimePerSecond::getMaxSingleMeasurement);
        this.busyTimePerSecond = this.gauge("busyTimeMsPerSecond", this::getBusyTimePerSecond);
        this.numMailsProcessed = new SimpleCounter();
        this.mailboxThroughput = this.meter("mailboxMailsPerSecond", new MeterView(this.numMailsProcessed));
        this.mailboxLatency = this.histogram("mailboxLatencyMs", new DescriptiveStatisticsHistogram(60));
        this.mailboxSize = this.gauge("mailboxQueueSize", new SizeGauge());
    }

    public IOMetrics createSnapshot() {
        return new IOMetrics(this.numRecordsInRate, this.numRecordsOutRate, this.numBytesInRate, this.numBytesOutRate, this.numBytesProducedOfPartitions);
    }

    public Counter getNumBytesInCounter() {
        return this.numBytesIn;
    }

    public Counter getNumBytesOutCounter() {
        return this.numBytesOut;
    }

    public Counter getNumRecordsInCounter() {
        return this.numRecordsIn;
    }

    public Counter getNumRecordsOutCounter() {
        return this.numRecordsOut;
    }

    public Counter getNumBuffersOutCounter() {
        return this.numBuffersOut;
    }

    public Counter getNumMailsProcessedCounter() {
        return this.numMailsProcessed;
    }

    public TimerGauge getIdleTimeMsPerSecond() {
        return this.idleTimePerSecond;
    }

    public TimerGauge getSoftBackPressuredTimePerSecond() {
        return this.softBackPressuredTimePerSecond;
    }

    public TimerGauge getHardBackPressuredTimePerSecond() {
        return this.hardBackPressuredTimePerSecond;
    }

    public long getBackPressuredTimeMsPerSecond() {
        return this.getSoftBackPressuredTimePerSecond().getValue() + this.getHardBackPressuredTimePerSecond().getValue();
    }

    public void setEnableBusyTime(boolean enabled) {
        this.busyTimeEnabled = enabled;
    }

    private double getBusyTimePerSecond() {
        double busyTime = this.idleTimePerSecond.getValue() + this.getBackPressuredTimeMsPerSecond();
        return this.busyTimeEnabled ? 1000.0 - Math.min(busyTime, 1000.0) : Double.NaN;
    }

    public Meter getMailboxThroughput() {
        return this.mailboxThroughput;
    }

    public Histogram getMailboxLatency() {
        return this.mailboxLatency;
    }

    public Gauge<Integer> getMailboxSize() {
        return this.mailboxSize;
    }

    public void reuseRecordsInputCounter(Counter numRecordsInCounter) {
        this.numRecordsIn.addCounter(numRecordsInCounter);
    }

    public void reuseRecordsOutputCounter(Counter numRecordsOutCounter) {
        this.numRecordsOut.addCounter(numRecordsOutCounter);
    }

    public void registerNumBytesProducedCounterForPartition(IntermediateResultPartitionID resultPartitionId, Counter numBytesProducedCounter) {
        this.numBytesProducedOfPartitions.put(resultPartitionId, numBytesProducedCounter);
    }

    public void registerMailboxSizeSupplier(SizeGauge.SizeSupplier<Integer> supplier) {
        this.mailboxSize.registerSupplier(supplier);
    }

    private static class SizeGauge
    implements Gauge<Integer> {
        private SizeSupplier<Integer> supplier;

        private SizeGauge() {
        }

        public void registerSupplier(SizeSupplier<Integer> supplier) {
            this.supplier = supplier;
        }

        public Integer getValue() {
            if (this.supplier != null) {
                return this.supplier.get();
            }
            return 0;
        }

        @FunctionalInterface
        public static interface SizeSupplier<R> {
            public R get();
        }
    }

    private static class SumCounter
    extends SimpleCounter {
        private final List<Counter> internalCounters = new ArrayList<Counter>();

        SumCounter() {
        }

        public void addCounter(Counter toAdd) {
            this.internalCounters.add(toAdd);
        }

        public long getCount() {
            long sum = super.getCount();
            for (Counter counter : this.internalCounters) {
                sum += counter.getCount();
            }
            return sum;
        }
    }
}

