/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.ResourceManagerPartitionTrackerFactory;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.util.Preconditions;

public class StandaloneResourceManager
extends ResourceManager<ResourceID> {
    private final Time startupPeriodTime;

    public StandaloneResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, SlotManager slotManager, ResourceManagerPartitionTrackerFactory clusterPartitionTrackerFactory, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Time startupPeriodTime, Time rpcTimeout, Executor ioExecutor) {
        super(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, slotManager, clusterPartitionTrackerFactory, jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, rpcTimeout, ioExecutor);
        this.startupPeriodTime = (Time)Preconditions.checkNotNull((Object)startupPeriodTime);
    }

    @Override
    protected void initialize() throws ResourceManagerException {
        this.startStartupPeriod();
    }

    @Override
    protected void terminate() {
    }

    @Override
    protected void internalDeregisterApplication(ApplicationStatus finalStatus, @Nullable String diagnostics) {
    }

    @Override
    public boolean startNewWorker(WorkerResourceSpec workerResourceSpec) {
        return false;
    }

    @Override
    public boolean stopWorker(ResourceID resourceID) {
        return false;
    }

    @Override
    protected ResourceID workerStarted(ResourceID resourceID) {
        return resourceID;
    }

    private void startStartupPeriod() {
        this.setFailUnfulfillableRequest(false);
        long startupPeriodMillis = this.startupPeriodTime.toMilliseconds();
        if (startupPeriodMillis > 0L) {
            this.scheduleRunAsync(() -> this.setFailUnfulfillableRequest(true), startupPeriodMillis, TimeUnit.MILLISECONDS);
        }
    }
}

