/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class DeploymentHandle {
    private final ExecutionVertexVersion requiredVertexVersion;
    private final SlotExecutionVertexAssignment slotExecutionVertexAssignment;

    public DeploymentHandle(ExecutionVertexVersion requiredVertexVersion, SlotExecutionVertexAssignment slotExecutionVertexAssignment) {
        this.requiredVertexVersion = (ExecutionVertexVersion)Preconditions.checkNotNull((Object)requiredVertexVersion);
        this.slotExecutionVertexAssignment = (SlotExecutionVertexAssignment)Preconditions.checkNotNull((Object)slotExecutionVertexAssignment);
    }

    public ExecutionVertexID getExecutionVertexId() {
        return this.requiredVertexVersion.getExecutionVertexId();
    }

    public ExecutionVertexVersion getRequiredVertexVersion() {
        return this.requiredVertexVersion;
    }

    public SlotExecutionVertexAssignment getSlotExecutionVertexAssignment() {
        return this.slotExecutionVertexAssignment;
    }

    public Optional<LogicalSlot> getLogicalSlot() {
        CompletableFuture<LogicalSlot> logicalSlotFuture = this.slotExecutionVertexAssignment.getLogicalSlotFuture();
        Preconditions.checkState((boolean)logicalSlotFuture.isDone(), (Object)"method can only be called after slot future is done");
        if (logicalSlotFuture.isCompletedExceptionally()) {
            return Optional.empty();
        }
        return Optional.ofNullable(logicalSlotFuture.getNow(null));
    }
}

