/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.security.token.DelegationTokenProvider;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDelegationTokenManager
implements DelegationTokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosDelegationTokenManager.class);
    private final Configuration configuration;
    @VisibleForTesting
    final Map<String, DelegationTokenProvider> delegationTokenProviders;

    public KerberosDelegationTokenManager(Configuration configuration) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration, (String)"Flink configuration must not be null");
        this.delegationTokenProviders = this.loadProviders();
    }

    private Map<String, DelegationTokenProvider> loadProviders() {
        LOG.info("Loading delegation token providers");
        ServiceLoader<DelegationTokenProvider> serviceLoader = ServiceLoader.load(DelegationTokenProvider.class);
        HashMap<String, DelegationTokenProvider> providers = new HashMap<String, DelegationTokenProvider>();
        for (DelegationTokenProvider provider : serviceLoader) {
            try {
                if (this.isProviderEnabled(provider.serviceName())) {
                    provider.init(this.configuration);
                    LOG.info("Delegation token provider {} loaded and initialized", (Object)provider.serviceName());
                    providers.put(provider.serviceName(), provider);
                    continue;
                }
                LOG.info("Delegation token provider {} is disabled so not loaded", (Object)provider.serviceName());
            }
            catch (Exception e) {
                LOG.error("Failed to initialize delegation token provider {}.", (Object)provider.serviceName(), (Object)e);
                throw e;
            }
        }
        LOG.info("Delegation token providers loaded successfully");
        return providers;
    }

    @VisibleForTesting
    boolean isProviderEnabled(String serviceName) {
        return this.configuration.getBoolean(String.format("security.kerberos.token.provider.%s.enabled", serviceName), true);
    }

    @VisibleForTesting
    boolean isProviderLoaded(String serviceName) {
        return this.delegationTokenProviders.containsKey(serviceName);
    }

    @Override
    public void obtainDelegationTokens(Credentials credentials) {
        LOG.info("Obtaining delegation tokens");
    }

    @Override
    public void start() {
        LOG.info("Starting renewal task");
    }

    @Override
    public void stop() {
        LOG.info("Stopping renewal task");
    }
}

