/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.TestingComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class SlotPoolInteractionsTest
extends TestLogger {
    private static final Time fastTimeout = Time.milliseconds((long)1L);
    @ClassRule
    public static final TestingComponentMainThreadExecutor.Resource EXECUTOR_RESOURCE = new TestingComponentMainThreadExecutor.Resource(10L);
    private final TestingComponentMainThreadExecutor testMainThreadExecutor = EXECUTOR_RESOURCE.getComponentMainThreadTestExecutor();

    @Test
    public void testSlotAllocationNoResourceManager() throws Exception {
        try (DeclarativeSlotPoolBridge pool = this.createAndSetUpSlotPoolWithoutResourceManager();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testSlotAllocationNoResourceManager$0((SlotPool)pool));
            try {
                future.get();
                Assert.fail((String)"We expected an ExecutionException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
        }
    }

    @Test
    public void testCancelSlotAllocationWithoutResourceManager() throws Exception {
        try (DeclarativeSlotPoolBridge pool = this.createAndSetUpSlotPoolWithoutResourceManager();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> pool.getNumPendingRequests() == 0));
        }
    }

    @Test
    public void testSlotAllocationTimeout() throws Exception {
        try (DeclarativeSlotPoolBridge pool = this.createAndSetUpSlotPool();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> pool.getNumPendingRequests() == 0));
        }
    }

    private DeclarativeSlotPoolBridge createAndSetUpSlotPool() throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.testMainThreadExecutor.getMainThreadExecutor());
    }

    private DeclarativeSlotPoolBridge createAndSetUpSlotPoolWithoutResourceManager() throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().setResourceManagerGateway(null).buildAndStart(this.testMainThreadExecutor.getMainThreadExecutor());
    }

    private static /* synthetic */ CompletableFuture lambda$testSlotAllocationNoResourceManager$0(SlotPool pool) throws Throwable {
        return pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout);
    }
}

