/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class NettyShuffleDescriptorBuilder {
    private ResourceID producerLocation = ResourceID.generate();
    private ResultPartitionID id = new ResultPartitionID();
    private InetAddress address = InetAddress.getLoopbackAddress();
    private int dataPort;
    private int connectionIndex;

    public NettyShuffleDescriptorBuilder setProducerLocation(ResourceID producerLocation) {
        this.producerLocation = producerLocation;
        return this;
    }

    public NettyShuffleDescriptorBuilder setId(ResultPartitionID id) {
        this.id = id;
        return this;
    }

    public NettyShuffleDescriptorBuilder setAddress(InetAddress address) {
        this.address = address;
        return this;
    }

    public NettyShuffleDescriptorBuilder setDataPort(int dataPort) {
        this.dataPort = dataPort;
        return this;
    }

    public NettyShuffleDescriptorBuilder setProducerInfoFromTaskManagerLocation(TaskManagerLocation producerTaskManagerLocation) {
        return this.setProducerLocation(producerTaskManagerLocation.getResourceID()).setAddress(producerTaskManagerLocation.address()).setDataPort(producerTaskManagerLocation.dataPort());
    }

    public NettyShuffleDescriptorBuilder setConnectionIndex(int connectionIndex) {
        this.connectionIndex = connectionIndex;
        return this;
    }

    public NettyShuffleDescriptor buildRemote() {
        ConnectionID connectionID = new ConnectionID(new InetSocketAddress(this.address, this.dataPort), this.connectionIndex);
        return new NettyShuffleDescriptor(this.producerLocation, (NettyShuffleDescriptor.PartitionConnectionInfo)new NettyShuffleDescriptor.NetworkPartitionConnectionInfo(connectionID), this.id);
    }

    public NettyShuffleDescriptor buildLocal() {
        return new NettyShuffleDescriptor(this.producerLocation, (NettyShuffleDescriptor.PartitionConnectionInfo)NettyShuffleDescriptor.LocalExecutionPartitionConnectionInfo.INSTANCE, this.id);
    }

    public static NettyShuffleDescriptorBuilder newBuilder() {
        return new NettyShuffleDescriptorBuilder();
    }

    public static NettyShuffleDescriptor createRemoteWithIdAndLocation(IntermediateResultPartitionID partitionId, ResourceID producerLocation) {
        return NettyShuffleDescriptorBuilder.newBuilder().setId(new ResultPartitionID(partitionId, ExecutionGraphTestUtils.createExecutionAttemptId())).setProducerLocation(producerLocation).buildRemote();
    }
}

