/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.testutils.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.taskexecutor.slot.DefaultTimerService;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTimerServiceTest
extends TestLogger {
    @Test
    public void testUnregisterAllTimeouts() throws Exception {
        ManuallyTriggeredScheduledExecutorService scheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        DefaultTimerService timerService = new DefaultTimerService((ScheduledExecutorService)scheduledExecutorService, 100L);
        timerService.start((ignoredA, ignoredB) -> {});
        timerService.registerTimeout((Object)new AllocationID(), 10L, TimeUnit.SECONDS);
        timerService.registerTimeout((Object)new AllocationID(), 10L, TimeUnit.SECONDS);
        timerService.unregisterAllTimeouts();
        Map timeouts = timerService.getTimeouts();
        Assert.assertTrue((boolean)timeouts.isEmpty());
        for (ScheduledFuture scheduledTask : scheduledExecutorService.getAllScheduledTasks()) {
            MatcherAssert.assertThat((Object)scheduledTask.isCancelled(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void testIsValidInitiallyReturnsFalse() {
        DefaultTimerService<AllocationID> timerService = DefaultTimerServiceTest.createAndStartTimerService();
        MatcherAssert.assertThat((Object)timerService.isValid((Object)new AllocationID(), UUID.randomUUID()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testIsValidReturnsTrueForActiveTimeout() throws Exception {
        DefaultTimerService<AllocationID> timerService = DefaultTimerServiceTest.createAndStartTimerService();
        AllocationID allocationId = new AllocationID();
        timerService.registerTimeout((Object)allocationId, 10L, TimeUnit.SECONDS);
        DefaultTimerService.Timeout timeout = (DefaultTimerService.Timeout)timerService.getTimeouts().get(allocationId);
        UUID ticket = timeout.getTicket();
        MatcherAssert.assertThat((Object)timerService.isValid((Object)allocationId, ticket), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testIsValidReturnsFalseIfEitherKeyOrTicketDoesNotMatch() {
        DefaultTimerService<AllocationID> timerService = DefaultTimerServiceTest.createAndStartTimerService();
        AllocationID allocationId = new AllocationID();
        timerService.registerTimeout((Object)allocationId, 10L, TimeUnit.SECONDS);
        DefaultTimerService.Timeout timeout = (DefaultTimerService.Timeout)timerService.getTimeouts().get(allocationId);
        UUID ticket = timeout.getTicket();
        MatcherAssert.assertThat((Object)timerService.isValid((Object)new AllocationID(), ticket), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)timerService.isValid((Object)allocationId, UUID.randomUUID()), (Matcher)Is.is((Object)false));
    }

    private static DefaultTimerService<AllocationID> createAndStartTimerService() {
        ManuallyTriggeredScheduledExecutorService scheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        DefaultTimerService timerService = new DefaultTimerService((ScheduledExecutorService)scheduledExecutorService, 100L);
        timerService.start((ignoredA, ignoredB) -> {});
        return timerService;
    }
}

