/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.HashSet;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.InputChannelRecoveredStateHandler;
import org.apache.flink.runtime.checkpoint.channel.RecoveredChannelStateHandler;
import org.apache.flink.runtime.checkpoint.channel.RecoveredChannelStateHandlerTest;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InputChannelRecoveredStateHandlerTest
extends RecoveredChannelStateHandlerTest {
    private static final int preAllocatedSegments = 3;
    private NetworkBufferPool networkBufferPool;
    private SingleInputGate inputGate;
    private InputChannelRecoveredStateHandler icsHander;
    private InputChannelInfo channelInfo;

    @Before
    public void setUp() {
        this.networkBufferPool = new NetworkBufferPool(3, 1024);
        this.inputGate = new SingleInputGateBuilder().setChannelFactory(InputChannelBuilder::buildLocalRecoveredChannel).setSegmentProvider((MemorySegmentProvider)this.networkBufferPool).build();
        this.icsHander = this.buildInputChannelStateHandler(this.inputGate);
        this.channelInfo = new InputChannelInfo(0, 0);
    }

    private InputChannelRecoveredStateHandler buildInputChannelStateHandler(SingleInputGate inputGate) {
        return new InputChannelRecoveredStateHandler(new InputGate[]{inputGate}, new InflightDataRescalingDescriptor(new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor[]{new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(new int[]{1}, RescaleMappings.identity((int)1, (int)1), new HashSet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.IDENTITY)}));
    }

    @Override
    @Test
    public void testRecycleBufferBeforeRecoverWasCalled() throws Exception {
        RecoveredChannelStateHandler.BufferWithContext bufferWithContext = this.icsHander.getBuffer(this.channelInfo);
        bufferWithContext.buffer.close();
        this.inputGate.close();
        Assert.assertEquals((long)3L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
    }

    @Override
    @Test
    public void testRecycleBufferAfterRecoverWasCalled() throws Exception {
        RecoveredChannelStateHandler.BufferWithContext bufferWithContext = this.icsHander.getBuffer(this.channelInfo);
        this.icsHander.recover(this.channelInfo, 0, bufferWithContext);
        this.inputGate.close();
        Assert.assertEquals((long)3L, (long)this.networkBufferPool.getNumberOfAvailableMemorySegments());
    }
}

