/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleTestUtils;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ShuffleDescriptorTest
extends TestLogger {
    @Test
    public void testMixedLocalRemoteUnknownDeployment() throws Exception {
        ResourceID consumerResourceID = ResourceID.generate();
        JobID jobID = new JobID();
        for (ExecutionState state : ExecutionState.values()) {
            ResultPartitionID localPartitionId = new ResultPartitionID();
            ResultPartitionDeploymentDescriptor localPartition = ShuffleDescriptorTest.createResultPartitionDeploymentDescriptor(jobID, localPartitionId, consumerResourceID);
            ResultPartitionID remotePartitionId = new ResultPartitionID();
            ResultPartitionDeploymentDescriptor remotePartition = ShuffleDescriptorTest.createResultPartitionDeploymentDescriptor(jobID, remotePartitionId, ResourceID.generate());
            ResultPartitionID unknownPartitionId = new ResultPartitionID();
            ShuffleDescriptor localShuffleDescriptor = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(localPartitionId, state, localPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
            ShuffleDescriptor remoteShuffleDescriptor = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(remotePartitionId, state, remotePartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
            ShuffleDescriptor unknownShuffleDescriptor = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, state, null, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
            if (state == ExecutionState.RUNNING || state == ExecutionState.INITIALIZING || state == ExecutionState.FINISHED || state == ExecutionState.SCHEDULED || state == ExecutionState.DEPLOYING) {
                ShuffleDescriptorTest.verifyShuffleDescriptor(localShuffleDescriptor, NettyShuffleDescriptor.class, false, localPartitionId);
                NettyShuffleDescriptor nettyShuffleDescriptor = (NettyShuffleDescriptor)localShuffleDescriptor;
                Assert.assertThat((Object)nettyShuffleDescriptor.isLocalTo(consumerResourceID), (Matcher)CoreMatchers.is((Object)true));
                ShuffleDescriptorTest.verifyShuffleDescriptor(remoteShuffleDescriptor, NettyShuffleDescriptor.class, false, remotePartitionId);
                nettyShuffleDescriptor = (NettyShuffleDescriptor)remoteShuffleDescriptor;
                Assert.assertThat((Object)nettyShuffleDescriptor.isLocalTo(consumerResourceID), (Matcher)CoreMatchers.is((Object)false));
                Assert.assertThat((Object)nettyShuffleDescriptor.getConnectionId(), (Matcher)CoreMatchers.is((Object)InputChannelBuilder.STUB_CONNECTION_ID));
            } else {
                ShuffleDescriptorTest.verifyShuffleDescriptor(localShuffleDescriptor, UnknownShuffleDescriptor.class, true, localPartitionId);
                ShuffleDescriptorTest.verifyShuffleDescriptor(remoteShuffleDescriptor, UnknownShuffleDescriptor.class, true, remotePartitionId);
            }
            ShuffleDescriptorTest.verifyShuffleDescriptor(unknownShuffleDescriptor, UnknownShuffleDescriptor.class, true, unknownPartitionId);
        }
    }

    private static void verifyShuffleDescriptor(ShuffleDescriptor descriptor, Class<? extends ShuffleDescriptor> cl, boolean unknown, ResultPartitionID partitionID) {
        Assert.assertThat((Object)descriptor, (Matcher)CoreMatchers.instanceOf(cl));
        Assert.assertThat((Object)descriptor.isUnknown(), (Matcher)CoreMatchers.is((Object)unknown));
        Assert.assertThat((Object)descriptor.getResultPartitionID(), (Matcher)CoreMatchers.is((Object)partitionID));
    }

    @Test
    public void testUnknownDescriptorWithOrWithoutLazyDeployment() {
        ResultPartitionID unknownPartitionId = new ResultPartitionID();
        ShuffleDescriptor unknownSdd = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, ExecutionState.CREATED, null, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
        Assert.assertThat((Object)unknownSdd, (Matcher)CoreMatchers.instanceOf(UnknownShuffleDescriptor.class));
        Assert.assertThat((Object)unknownSdd.isUnknown(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)unknownSdd.getResultPartitionID(), (Matcher)CoreMatchers.is((Object)unknownPartitionId));
        try {
            ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, ExecutionState.CREATED, null, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.MUST_BE_KNOWN);
            Assert.fail((String)"Did not throw expected ExecutionGraphException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static ShuffleDescriptor getConsumedPartitionShuffleDescriptor(ResultPartitionID id, ExecutionState state, @Nullable ResultPartitionDeploymentDescriptor producedPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint partitionLocationConstraint) {
        ShuffleDescriptor shuffleDescriptor = TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor((ResultPartitionID)id, (ResultPartitionType)ResultPartitionType.PIPELINED, (boolean)true, (ExecutionState)state, (TaskDeploymentDescriptorFactory.PartitionLocationConstraint)partitionLocationConstraint, (ResultPartitionDeploymentDescriptor)producedPartition);
        Assert.assertThat((Object)shuffleDescriptor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)shuffleDescriptor.getResultPartitionID(), (Matcher)CoreMatchers.is((Object)id));
        return shuffleDescriptor;
    }

    private static ResultPartitionDeploymentDescriptor createResultPartitionDeploymentDescriptor(JobID jobID, ResultPartitionID id, ResourceID location) throws ExecutionException, InterruptedException {
        ProducerDescriptor producerDescriptor = new ProducerDescriptor(location, id.getProducerId(), InputChannelBuilder.STUB_CONNECTION_ID.getAddress().getAddress(), InputChannelBuilder.STUB_CONNECTION_ID.getAddress().getPort());
        PartitionDescriptor partitionDescriptor = PartitionDescriptorBuilder.newBuilder().setPartitionId(id.getPartitionId()).build();
        ShuffleDescriptor shuffleDescriptor = (ShuffleDescriptor)ShuffleTestUtils.DEFAULT_SHUFFLE_MASTER.registerPartitionWithProducer(jobID, partitionDescriptor, producerDescriptor).get();
        return new ResultPartitionDeploymentDescriptor(partitionDescriptor, shuffleDescriptor, 1);
    }
}

