/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.UUID;
import org.apache.flink.runtime.dispatcher.runner.DispatcherLeaderProcessFactory;
import org.apache.flink.runtime.dispatcher.runner.TestingDispatcherLeaderProcess;
import org.apache.flink.util.Preconditions;

class TestingDispatcherLeaderProcessFactory
implements DispatcherLeaderProcessFactory {
    private final Queue<TestingDispatcherLeaderProcess> processes;

    private TestingDispatcherLeaderProcessFactory(Queue<TestingDispatcherLeaderProcess> processes) {
        this.processes = processes;
    }

    public TestingDispatcherLeaderProcess create(UUID leaderSessionID) {
        if (this.processes.isEmpty()) {
            return TestingDispatcherLeaderProcess.newBuilder(leaderSessionID).build();
        }
        TestingDispatcherLeaderProcess nextProcess = this.processes.poll();
        Preconditions.checkState((boolean)leaderSessionID.equals(nextProcess.getLeaderSessionId()));
        return nextProcess;
    }

    public static TestingDispatcherLeaderProcessFactory from(TestingDispatcherLeaderProcess ... processes) {
        return new TestingDispatcherLeaderProcessFactory(new ArrayDeque<TestingDispatcherLeaderProcess>(Arrays.asList(processes)));
    }

    public static TestingDispatcherLeaderProcessFactory defaultValue() {
        return new TestingDispatcherLeaderProcessFactory(new ArrayDeque<TestingDispatcherLeaderProcess>(0));
    }
}

