/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SubpartitionTestBase;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.apache.flink.runtime.io.network.util.TestSubpartitionProducer;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.CheckedSupplier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipelinedSubpartitionTest
extends SubpartitionTestBase {
    @ClassRule
    public static final TestExecutorResource<ExecutorService> EXECUTOR_RESOURCE = new TestExecutorResource(() -> Executors.newCachedThreadPool());

    PipelinedSubpartition createSubpartition() throws Exception {
        return PipelinedSubpartitionTest.createPipelinedSubpartition();
    }

    @Override
    ResultSubpartition createFailingWritesSubpartition() throws Exception {
        Assume.assumeTrue((boolean)false);
        return null;
    }

    @Test
    public void testIllegalReadViewRequest() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertNotNull((Object)subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener()));
        try {
            subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            Assert.fail((String)"Did not throw expected exception after duplicate notifyNonEmpty view request.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIsReleasedChecksParent() {
        PipelinedSubpartition subpartition = (PipelinedSubpartition)Mockito.mock(PipelinedSubpartition.class);
        PipelinedSubpartitionView reader = new PipelinedSubpartitionView(subpartition, (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class));
        Assert.assertFalse((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)1))).isReleased();
        Mockito.when((Object)subpartition.isReleased()).thenReturn((Object)true);
        Assert.assertTrue((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)2))).isReleased();
    }

    @Test
    public void testConcurrentFastProduceAndFastConsume() throws Exception {
        this.testProduceConsume(false, false);
    }

    @Test
    public void testConcurrentFastProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(false, true);
    }

    @Test
    public void testConcurrentSlowProduceAndFastConsume() throws Exception {
        this.testProduceConsume(true, false);
    }

    @Test
    public void testConcurrentSlowProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(true, true);
    }

    private void testProduceConsume(boolean isSlowProducer, boolean isSlowConsumer) throws Exception {
        int producerNumberOfBuffersToProduce = 128;
        int bufferSize = 32768;
        TestProducerSource producerSource = new TestProducerSource(){
            private int numberOfBuffers;

            @Override
            public TestProducerSource.BufferAndChannel getNextBuffer() throws Exception {
                if (this.numberOfBuffers == 128) {
                    return null;
                }
                MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)32768);
                int next = this.numberOfBuffers * 8192;
                for (int i = 0; i < 32768; i += 4) {
                    segment.putInt(i, next);
                    ++next;
                }
                ++this.numberOfBuffers;
                return new TestProducerSource.BufferAndChannel(segment.getArray(), 0);
            }
        };
        TestConsumerCallback consumerCallback = new TestConsumerCallback(){
            private int numberOfBuffers;

            @Override
            public void onBuffer(Buffer buffer) {
                MemorySegment segment = buffer.getMemorySegment();
                Assert.assertEquals((long)segment.size(), (long)buffer.getSize());
                int expected = this.numberOfBuffers * (segment.size() / 4);
                for (int i = 0; i < segment.size(); i += 4) {
                    Assert.assertEquals((long)expected, (long)segment.getInt(i));
                    ++expected;
                }
                ++this.numberOfBuffers;
                buffer.recycleBuffer();
            }

            @Override
            public void onEvent(AbstractEvent event) {
            }
        };
        PipelinedSubpartition subpartition = this.createSubpartition();
        TestSubpartitionProducer producer = new TestSubpartitionProducer((ResultSubpartition)subpartition, isSlowProducer, producerSource);
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer(isSlowConsumer, consumerCallback);
        PipelinedSubpartitionView view = subpartition.createReadView((BufferAvailabilityListener)consumer);
        consumer.setSubpartitionView((ResultSubpartitionView)view);
        CompletableFuture producerResult = CompletableFuture.supplyAsync(CheckedSupplier.unchecked(producer::call), EXECUTOR_RESOURCE.getExecutor());
        CompletableFuture consumerResult = CompletableFuture.supplyAsync(CheckedSupplier.unchecked(consumer::call), EXECUTOR_RESOURCE.getExecutor());
        FutureUtils.waitForAll(Arrays.asList(producerResult, consumerResult)).get(60000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testCleanupReleasedPartitionNoView() throws Exception {
        this.testCleanupReleasedPartition(false);
    }

    @Test
    public void testCleanupReleasedPartitionWithView() throws Exception {
        this.testCleanupReleasedPartition(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCleanupReleasedPartition(boolean createView) throws Exception {
        boolean buffer2Recycled;
        boolean buffer1Recycled;
        PipelinedSubpartition partition = this.createSubpartition();
        BufferConsumer buffer1 = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
        BufferConsumer buffer2 = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
        try {
            partition.add(buffer1);
            partition.add(buffer2);
            Assert.assertEquals((long)2L, (long)partition.getNumberOfQueuedBuffers());
            PipelinedSubpartitionView view = null;
            if (createView) {
                view = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            }
            partition.release();
            Assert.assertEquals((long)0L, (long)partition.getNumberOfQueuedBuffers());
            Assert.assertTrue((boolean)partition.isReleased());
            if (createView) {
                Assert.assertTrue((boolean)view.isReleased());
            }
            Assert.assertTrue((boolean)buffer1.isRecycled());
        }
        finally {
            buffer1Recycled = buffer1.isRecycled();
            if (!buffer1Recycled) {
                buffer1.close();
            }
            if (!(buffer2Recycled = buffer2.isRecycled())) {
                buffer2.close();
            }
        }
        if (!buffer1Recycled) {
            Assert.fail((String)"buffer 1 not recycled");
        }
        if (!buffer2Recycled) {
            Assert.fail((String)"buffer 2 not recycled");
        }
        Assert.assertEquals((long)2L, (long)partition.getTotalNumberOfBuffersUnsafe());
        Assert.assertEquals((long)0L, (long)partition.getTotalNumberOfBytesUnsafe());
    }

    @Test
    public void testReleaseParent() throws Exception {
        PipelinedSubpartition partition = this.createSubpartition();
        this.verifyViewReleasedAfterParentRelease((ResultSubpartition)partition);
    }

    @Test
    public void testNumberOfQueueBuffers() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096));
        Assert.assertEquals((long)1L, (long)subpartition.getNumberOfQueuedBuffers());
        subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096));
        Assert.assertEquals((long)2L, (long)subpartition.getNumberOfQueuedBuffers());
        subpartition.getNextBuffer();
        Assert.assertEquals((long)1L, (long)subpartition.getNumberOfQueuedBuffers());
    }

    @Test
    public void testNewBufferSize() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
        subpartition.bufferSize(42);
        Assert.assertEquals((long)42L, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeNewBufferSize() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
        subpartition.bufferSize(-1);
    }

    @Test
    public void testNegativeBufferSizeAsSignOfAddingFail() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
        subpartition.finish();
        Assert.assertEquals((long)-1L, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
    }

    @Test
    public void testProducerFailedException() {
        FailurePipelinedSubpartition subpartition = new FailurePipelinedSubpartition(0, 2, PartitionTestUtils.createPartition());
        PipelinedSubpartitionView view = subpartition.createReadView(new NoOpBufferAvailablityListener());
        Assert.assertNotNull((Object)view.getFailureCause());
        Assert.assertTrue((boolean)(view.getFailureCause() instanceof CancelTaskException));
    }

    @Test
    public void testConsumeTimeoutableCheckpointBarrierQuickly() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        subpartition.setChannelStateWriter(ChannelStateWriter.NO_OP);
        this.assertSubpartitionChannelStateFuturesAndQueuedBuffers(subpartition, null, true, 0L, false);
        this.testConsumeQuicklyWithNDataBuffers(0, subpartition, 5L);
        this.testConsumeQuicklyWithNDataBuffers(1, subpartition, 6L);
        this.testConsumeQuicklyWithNDataBuffers(2, subpartition, 7L);
    }

    private void testConsumeQuicklyWithNDataBuffers(int numberOfDataBuffers, PipelinedSubpartition subpartition, long checkpointId) throws Exception {
        for (int i = 0; i < numberOfDataBuffers; ++i) {
            subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096));
        }
        subpartition.add(this.getTimeoutableBarrierBuffer(checkpointId));
        Assert.assertEquals((long)checkpointId, (long)subpartition.getChannelStateCheckpointId());
        CompletableFuture channelStateFuture = subpartition.getChannelStateFuture();
        this.assertSubpartitionChannelStateFuturesAndQueuedBuffers(subpartition, channelStateFuture, false, numberOfDataBuffers + 1, false);
        for (int i = 0; i < numberOfDataBuffers; ++i) {
            this.pollBufferAndCheckType(subpartition, Buffer.DataType.DATA_BUFFER);
        }
        this.pollBufferAndCheckType(subpartition, Buffer.DataType.TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER);
        this.assertSubpartitionChannelStateFuturesAndQueuedBuffers(subpartition, channelStateFuture, true, 0L, true);
        Assert.assertTrue((boolean)((List)channelStateFuture.get()).isEmpty());
        subpartition.resumeConsumption();
    }

    @Test
    public void testTimeoutAlignedToUnalignedBarrier() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        subpartition.setChannelStateWriter(ChannelStateWriter.NO_OP);
        this.assertSubpartitionChannelStateFuturesAndQueuedBuffers(subpartition, null, true, 0L, false);
        this.testTimeoutWithNDataBuffers(0, subpartition, 7L);
        this.testTimeoutWithNDataBuffers(1, subpartition, 8L);
    }

    private void testTimeoutWithNDataBuffers(int numberOfDataBuffers, PipelinedSubpartition subpartition, long checkpointId) throws Exception {
        ArrayList<Buffer> expectedBuffers = new ArrayList<Buffer>();
        for (int i = 0; i < numberOfDataBuffers; ++i) {
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
            subpartition.add(bufferConsumer);
            expectedBuffers.add(bufferConsumer.copy().build());
        }
        subpartition.add(this.getTimeoutableBarrierBuffer(checkpointId));
        Assert.assertEquals((long)checkpointId, (long)subpartition.getChannelStateCheckpointId());
        CompletableFuture channelStateFuture = subpartition.getChannelStateFuture();
        this.assertSubpartitionChannelStateFuturesAndQueuedBuffers(subpartition, channelStateFuture, false, numberOfDataBuffers + 1, false);
        subpartition.alignedBarrierTimeout(checkpointId);
        this.assertSubpartitionChannelStateFuturesAndQueuedBuffers(subpartition, channelStateFuture, true, numberOfDataBuffers + 1, true);
        this.pollBufferAndCheckType(subpartition, Buffer.DataType.PRIORITIZED_EVENT_BUFFER);
        for (int i = 0; i < numberOfDataBuffers; ++i) {
            this.pollBufferAndCheckType(subpartition, Buffer.DataType.DATA_BUFFER);
        }
        Assert.assertEquals(expectedBuffers, channelStateFuture.get());
    }

    private void pollBufferAndCheckType(PipelinedSubpartition subpartition, Buffer.DataType dataType) {
        ResultSubpartition.BufferAndBacklog barrierBuffer = subpartition.pollBuffer();
        Assert.assertNotNull((Object)barrierBuffer);
        Assert.assertEquals((Object)dataType, (Object)barrierBuffer.buffer().getDataType());
    }

    @Test
    public void testConcurrentTimeoutableCheckpointBarrier() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        subpartition.setChannelStateWriter(ChannelStateWriter.NO_OP);
        subpartition.add(this.getTimeoutableBarrierBuffer(10L));
        Assert.assertEquals((long)10L, (long)subpartition.getChannelStateCheckpointId());
        CompletableFuture checkpointFuture10 = subpartition.getChannelStateFuture();
        Assert.assertNotNull((Object)checkpointFuture10);
        try {
            subpartition.add(this.getTimeoutableBarrierBuffer(11L));
            checkpointFuture10.get();
            Assert.fail((String)"Should fail with an IllegalStateException.");
        }
        catch (Throwable e) {
            ExceptionUtils.assertThrowable((Throwable)e, IllegalStateException.class);
        }
    }

    private BufferConsumer getTimeoutableBarrierBuffer(long checkpointId) throws IOException {
        CheckpointOptions checkpointOptions = CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault(), (long)1000L);
        return EventSerializer.toBufferConsumer((AbstractEvent)new CheckpointBarrier(checkpointId, System.currentTimeMillis(), checkpointOptions), (boolean)false);
    }

    private void assertSubpartitionChannelStateFuturesAndQueuedBuffers(PipelinedSubpartition subpartition, CompletableFuture<List<Buffer>> channelStateFuture, boolean channelStateFutureIsNull, long numberOfQueuedBuffers, boolean expectedFutureIsDone) {
        Assert.assertEquals((Object)channelStateFutureIsNull, (Object)(subpartition.getChannelStateFuture() == null ? 1 : 0));
        Assert.assertEquals((long)numberOfQueuedBuffers, (long)subpartition.getNumberOfQueuedBuffers());
        if (channelStateFuture != null) {
            Assert.assertEquals((Object)expectedFutureIsDone, (Object)channelStateFuture.isDone());
        }
    }

    private void verifyViewReleasedAfterParentRelease(ResultSubpartition partition) throws Exception {
        BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768);
        partition.add(bufferConsumer);
        partition.finish();
        BufferAvailabilityListener listener = (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class);
        ResultSubpartitionView view = partition.createReadView(listener);
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertFalse((boolean)view.isReleased());
        partition.release();
        Assert.assertTrue((boolean)view.isReleased());
    }

    public static PipelinedSubpartition createPipelinedSubpartition() {
        ResultPartition parent = PartitionTestUtils.createPartition();
        return new PipelinedSubpartition(0, 2, parent);
    }

    public static PipelinedSubpartition createPipelinedSubpartition(ResultPartition parent) {
        return new PipelinedSubpartition(0, 2, parent);
    }

    private static class FailurePipelinedSubpartition
    extends PipelinedSubpartition {
        FailurePipelinedSubpartition(int index, int receiverExclusiveBuffersPerChannel, ResultPartition parent) {
            super(index, receiverExclusiveBuffersPerChannel, parent);
        }

        Throwable getFailureCause() {
            return new RuntimeException("Expected test exception");
        }
    }
}

