/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class MetricsHandlerTestBase<T extends AbstractMetricsHandler>
extends TestLogger {
    private static final String TEST_METRIC_NAME = "test_counter";
    private static final int TEST_METRIC_VALUE = 1000;
    static final CompletableFuture<String> TEST_REST_ADDRESS = CompletableFuture.completedFuture("localhost:12345");
    static final Time TIMEOUT = Time.milliseconds((long)50L);
    static final Map<String, String> TEST_HEADERS = Collections.emptyMap();
    @Mock
    MetricFetcher mockMetricFetcher;
    GatewayRetriever<DispatcherGateway> leaderRetriever;
    @Mock
    private DispatcherGateway mockDispatcherGateway;
    private T metricsHandler;
    private Map<String, String> pathParameters;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.leaderRetriever = new GatewayRetriever<DispatcherGateway>(){

            public CompletableFuture<DispatcherGateway> getFuture() {
                return CompletableFuture.completedFuture(MetricsHandlerTestBase.this.mockDispatcherGateway);
            }
        };
        this.pathParameters = this.getPathParameters();
        this.metricsHandler = this.getMetricsHandler();
        MetricStore metricStore = new MetricStore();
        metricStore.add((MetricDump)new MetricDump.CounterDump(this.getQueryScopeInfo(), TEST_METRIC_NAME, 1000L));
        Mockito.when((Object)this.mockMetricFetcher.getMetricStore()).thenReturn((Object)metricStore);
    }

    @Test
    public void testGetMetric() throws Exception {
        CompletableFuture completableFuture = this.metricsHandler.handleRequest(HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)this.metricsHandler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, Collections.emptyMap(), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assert.assertTrue((boolean)completableFuture.isDone());
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        MatcherAssert.assertThat((Object)metricCollectionResponseBody.getMetrics(), (Matcher)Matchers.hasSize((int)1));
        Metric metric = (Metric)metricCollectionResponseBody.getMetrics().iterator().next();
        MatcherAssert.assertThat((Object)metric.getId(), (Matcher)Matchers.equalTo((Object)this.getExpectedIdForMetricName(TEST_METRIC_NAME)));
    }

    abstract T getMetricsHandler();

    abstract QueryScopeInfo getQueryScopeInfo();

    abstract Map<String, String> getPathParameters();

    String getExpectedIdForMetricName(String metricName) {
        return metricName;
    }
}

