/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfoWithHistory;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JobExceptionsInfoWithHistoryTest
extends RestResponseMarshallingTestBase<JobExceptionsInfoWithHistory> {
    @Override
    protected Class<JobExceptionsInfoWithHistory> getTestResponseClass() {
        return JobExceptionsInfoWithHistory.class;
    }

    @Override
    protected JobExceptionsInfoWithHistory getTestResponseInstance() throws Exception {
        ArrayList<JobExceptionsInfo.ExecutionExceptionInfo> executionTaskExceptionInfoList = new ArrayList<JobExceptionsInfo.ExecutionExceptionInfo>();
        executionTaskExceptionInfoList.add(new JobExceptionsInfo.ExecutionExceptionInfo("exception1", "task1", "location1", System.currentTimeMillis()));
        executionTaskExceptionInfoList.add(new JobExceptionsInfo.ExecutionExceptionInfo("exception2", "task2", "location2", System.currentTimeMillis()));
        return new JobExceptionsInfoWithHistory("root exception", Long.valueOf(System.currentTimeMillis()), executionTaskExceptionInfoList, false, new JobExceptionsInfoWithHistory.JobExceptionHistory(Collections.emptyList(), false));
    }

    @Test
    public void testNullFieldsNotSet() throws JsonProcessingException {
        ObjectMapper objMapper = RestMapperUtils.getStrictObjectMapper();
        String json = objMapper.writeValueAsString((Object)new JobExceptionsInfoWithHistory.ExceptionInfo("exception name", "stacktrace", 0L));
        Assert.assertThat((Object)json, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"taskName")));
        Assert.assertThat((Object)json, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"location")));
    }
}

