/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.AdaptiveSchedulerTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class StateWithExecutionGraphTest
extends TestLogger {
    @Test
    public void testSuspendCanBeCalledWhenExecutionGraphHasReachedGloballyTerminalState() throws Exception {
        try (MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();){
            StateTrackingMockExecutionGraph testingExecutionGraph = new StateTrackingMockExecutionGraph();
            testingExecutionGraph.transitionToRunning();
            TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, testingExecutionGraph);
            context.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.FAILED)));
            testingExecutionGraph.failJob((Throwable)new FlinkException("Transition job to FAILED state"), System.currentTimeMillis());
            testingExecutionGraph.completeTerminationFuture(JobStatus.FAILED);
            Assert.assertThat((Object)testingExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
            Assert.assertFalse((boolean)stateWithExecutionGraph.getGloballyTerminalStateFuture().isDone());
            stateWithExecutionGraph.suspend((Throwable)new FlinkException("Test exception"));
        }
    }

    @Test
    public void testOperatorCoordinatorShutdownOnLeave() throws Exception {
        try (MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();){
            TestingOperatorCoordinatorHandler testingOperatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
            TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, testingOperatorCoordinatorHandler);
            stateWithExecutionGraph.onLeave(AdaptiveSchedulerTest.DummyState.class);
            Assert.assertThat((Object)testingOperatorCoordinatorHandler.isDisposed(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void testSuspendToFinished() throws Exception {
        try (MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();){
            TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context);
            context.setExpectFinished(aeg -> Assert.assertThat((Object)aeg.getState(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED)));
            stateWithExecutionGraph.suspend(new RuntimeException());
        }
    }

    @Test
    public void testOnGloballyTerminalStateCalled() throws Exception {
        MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();
        StateTrackingMockExecutionGraph mockExecutionGraph = new StateTrackingMockExecutionGraph();
        TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, mockExecutionGraph);
        mockExecutionGraph.completeTerminationFuture(JobStatus.FINISHED);
        context.close();
        Assert.assertThat((Object)stateWithExecutionGraph.getGloballyTerminalStateFuture().get(), (Matcher)Matchers.is((Object)JobStatus.FINISHED));
    }

    @Test
    public void testOnGloballyTerminalStateNotCalledOnNonGloballyTerminalState() throws Exception {
        MockStateWithExecutionGraphContext context = new MockStateWithExecutionGraphContext();
        StateTrackingMockExecutionGraph mockExecutionGraph = new StateTrackingMockExecutionGraph();
        TestingStateWithExecutionGraph stateWithExecutionGraph = this.createStateWithExecutionGraph(context, mockExecutionGraph);
        mockExecutionGraph.completeTerminationFuture(JobStatus.SUSPENDED);
        context.close();
        Assert.assertThat((Object)stateWithExecutionGraph.getGloballyTerminalStateFuture().isDone(), (Matcher)Matchers.is((Object)false));
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context) {
        StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
        return this.createStateWithExecutionGraph(context, executionGraph);
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context, OperatorCoordinatorHandler operatorCoordinatorHandler) {
        StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
        return this.createStateWithExecutionGraph(context, executionGraph, operatorCoordinatorHandler);
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context, ExecutionGraph executionGraph) {
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        return this.createStateWithExecutionGraph(context, executionGraph, operatorCoordinatorHandler);
    }

    private TestingStateWithExecutionGraph createStateWithExecutionGraph(MockStateWithExecutionGraphContext context, ExecutionGraph executionGraph, OperatorCoordinatorHandler operatorCoordinatorHandler) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, this.log, (Executor)context.getMainThreadExecutor(), context.getMainThreadExecutor());
        executionGraph.transitionToRunning();
        return new TestingStateWithExecutionGraph(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, this.log, ClassLoader.getSystemClassLoader());
    }

    private static final class TestingStateWithExecutionGraph
    extends StateWithExecutionGraph {
        private final CompletableFuture<JobStatus> globallyTerminalStateFuture = new CompletableFuture();

        TestingStateWithExecutionGraph(StateWithExecutionGraph.Context context, ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, Logger logger, ClassLoader userCodeClassLoader) {
            super(context, executionGraph, executionGraphHandler, operatorCoordinatorHandler, logger, userCodeClassLoader, new ArrayList());
        }

        public CompletableFuture<JobStatus> getGloballyTerminalStateFuture() {
            return this.globallyTerminalStateFuture;
        }

        public void cancel() {
        }

        public JobStatus getJobStatus() {
            return this.getExecutionGraph().getState();
        }

        void onFailure(Throwable cause) {
        }

        void onGloballyTerminalState(JobStatus globallyTerminalState) {
            this.globallyTerminalStateFuture.complete(globallyTerminalState);
        }

        public void handleGlobalFailure(Throwable cause) {
        }

        boolean updateTaskExecutionState(TaskExecutionStateTransition taskExecutionStateTransition) {
            return false;
        }
    }
}

