/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.RemoteEnvironment;
import org.apache.flink.api.scala.FlinkILoop;
import org.apache.flink.configuration.Configuration;

public class ScalaShellRemoteEnvironment
extends RemoteEnvironment {
    private FlinkILoop flinkILoop;

    public ScalaShellRemoteEnvironment(String host, int port, FlinkILoop flinkILoop, Configuration clientConfig, String ... jarFiles) throws Exception {
        super(host, port, clientConfig, jarFiles, null);
        this.flinkILoop = flinkILoop;
    }

    protected PlanExecutor getExecutor() throws Exception {
        if (this.executor != null) {
            this.executor.stop();
        }
        URL jarUrl = this.flinkILoop.writeFilesToDisk().getAbsoluteFile().toURI().toURL();
        ArrayList<URL> allJarFiles = new ArrayList<URL>(this.jarFiles);
        allJarFiles.add(jarUrl);
        this.executor = PlanExecutor.createRemoteExecutor((String)this.host, (int)this.port, (Configuration)this.clientConfiguration, allJarFiles, (List)this.globalClasspaths);
        this.executor.setPrintStatusDuringExecution(this.getConfig().isSysoutLoggingEnabled());
        return this.executor;
    }

    public static void disableAllContextAndOtherEnvironments() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                throw new UnsupportedOperationException("Execution Environment is already defined for this shell.");
            }
        };
        ScalaShellRemoteEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void resetContextEnvironments() {
        ExecutionEnvironment.resetContextEnvironment();
    }
}

