/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.flexible;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;

public class QuorumMaj
implements QuorumVerifier {
    private Map<Long, QuorumPeer.QuorumServer> allMembers = new HashMap<Long, QuorumPeer.QuorumServer>();
    private HashMap<Long, QuorumPeer.QuorumServer> votingMembers = new HashMap();
    private HashMap<Long, QuorumPeer.QuorumServer> observingMembers = new HashMap();
    private long version = 0L;
    private int half;

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QuorumMaj)) {
            return false;
        }
        QuorumMaj qm = (QuorumMaj)o;
        if (qm.getVersion() == this.version) {
            return true;
        }
        if (this.allMembers.size() != qm.getAllMembers().size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer qs : this.allMembers.values()) {
            QuorumPeer.QuorumServer qso = qm.getAllMembers().get(qs.id);
            if (qso != null && qs.equals(qso)) continue;
            return false;
        }
        return true;
    }

    public QuorumMaj(Map<Long, QuorumPeer.QuorumServer> allMembers) {
        this.allMembers = allMembers;
        for (QuorumPeer.QuorumServer qs : allMembers.values()) {
            if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                this.votingMembers.put(qs.id, qs);
                continue;
            }
            this.observingMembers.put(qs.id, qs);
        }
        this.half = this.votingMembers.size() / 2;
    }

    public QuorumMaj(Properties props) throws QuorumPeerConfig.ConfigException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.startsWith("server.")) {
                int dot = key.indexOf(46);
                long sid = Long.parseLong(key.substring(dot + 1));
                QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer(sid, value);
                this.allMembers.put(sid, qs);
                if (qs.type == QuorumPeer.LearnerType.PARTICIPANT) {
                    this.votingMembers.put(sid, qs);
                    continue;
                }
                this.observingMembers.put(sid, qs);
                continue;
            }
            if (!key.equals("version")) continue;
            this.version = Long.parseLong(value, 16);
        }
        this.half = this.votingMembers.size() / 2;
    }

    @Override
    public long getWeight(long id) {
        return 1L;
    }

    @Override
    public String toString() {
        StringBuilder sw = new StringBuilder();
        for (QuorumPeer.QuorumServer member : this.getAllMembers().values()) {
            String key = "server." + member.id;
            String value = member.toString();
            sw.append(key);
            sw.append('=');
            sw.append(value);
            sw.append('\n');
        }
        String hexVersion = Long.toHexString(this.version);
        sw.append("version=");
        sw.append(hexVersion);
        return sw.toString();
    }

    @Override
    public boolean containsQuorum(Set<Long> ackSet) {
        return ackSet.size() > this.half;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getAllMembers() {
        return this.allMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getVotingMembers() {
        return this.votingMembers;
    }

    @Override
    public Map<Long, QuorumPeer.QuorumServer> getObservingMembers() {
        return this.observingMembers;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long ver) {
        this.version = ver;
    }
}

