/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.cli.CliOptionsParser;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.local.LocalContextUtils;
import org.apache.flink.table.client.gateway.local.LocalExecutor;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlClient {
    private static final Logger LOG = LoggerFactory.getLogger(SqlClient.class);
    private final boolean isEmbedded;
    private final CliOptions options;
    private final Supplier<Terminal> terminalFactory;
    public static final String MODE_EMBEDDED = "embedded";
    public static final String MODE_GATEWAY = "gateway";

    public SqlClient(boolean isEmbedded, CliOptions options, Supplier<Terminal> terminalFactory) {
        this.isEmbedded = isEmbedded;
        this.options = options;
        this.terminalFactory = terminalFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (this.isEmbedded) {
            DefaultContext defaultContext = LocalContextUtils.buildDefaultContext(this.options);
            LocalExecutor executor = new LocalExecutor(defaultContext);
            executor.start();
            String sessionId = executor.openSession(this.options.getSessionId());
            try {
                Runtime.getRuntime().addShutdownHook(new EmbeddedShutdownThread(sessionId, executor));
                this.openCli(sessionId, executor);
            }
            finally {
                executor.closeSession(sessionId);
            }
        } else {
            throw new SqlClientException("Gateway mode is not supported yet.");
        }
    }

    private void openCli(String sessionId, Executor executor) {
        boolean hasUpdateStatement;
        Path historyFilePath = this.options.getHistoryFilePath() != null ? Paths.get(this.options.getHistoryFilePath(), new String[0]) : Paths.get(System.getProperty("user.home"), SystemUtils.IS_OS_WINDOWS ? "flink-sql-history" : ".flink-sql-history");
        boolean hasSqlFile = this.options.getSqlFile() != null;
        boolean bl = hasUpdateStatement = this.options.getUpdateStatement() != null;
        if (hasSqlFile && hasUpdateStatement) {
            throw new IllegalArgumentException(String.format("Please use either option %s or %s. The option %s is deprecated and it's suggested to use %s instead.", CliOptionsParser.OPTION_FILE, CliOptionsParser.OPTION_UPDATE, CliOptionsParser.OPTION_UPDATE.getOpt(), CliOptionsParser.OPTION_FILE.getOpt()));
        }
        try (CliClient cli = new CliClient(this.terminalFactory, sessionId, executor, historyFilePath);){
            if (this.options.getInitFile() != null) {
                boolean success = cli.executeInitialization(this.readFromURL(this.options.getInitFile()));
                if (!success) {
                    System.out.println(String.format("Failed to initialize from sql script: %s. Please refer to the LOG for detailed error messages.", this.options.getInitFile()));
                    return;
                }
                System.out.println(String.format("Successfully initialized from sql script: %s", this.options.getInitFile()));
            }
            if (!hasSqlFile && !hasUpdateStatement) {
                cli.executeInInteractiveMode();
            } else {
                cli.executeInNonInteractiveMode(this.readExecutionContent());
            }
        }
    }

    public static void main(String[] args) {
        SqlClient.startClient(args, CliClient.DEFAULT_TERMINAL_FACTORY);
    }

    @VisibleForTesting
    protected static void startClient(String[] args, Supplier<Terminal> terminalFactory) {
        String[] modeArgs;
        String mode;
        if (args.length < 1 || args[0].startsWith("-")) {
            mode = MODE_EMBEDDED;
            modeArgs = args;
        } else {
            mode = args[0];
            modeArgs = Arrays.copyOfRange(args, 1, args.length);
        }
        switch (mode) {
            case "embedded": {
                CliOptions options = CliOptionsParser.parseEmbeddedModeClient(modeArgs);
                if (options.isPrintHelp()) {
                    CliOptionsParser.printHelpEmbeddedModeClient();
                    break;
                }
                try {
                    SqlClient client = new SqlClient(true, options, terminalFactory);
                    client.start();
                    break;
                }
                catch (SqlClientException e) {
                    System.out.println();
                    System.out.println();
                    LOG.error("SQL Client must stop.", (Throwable)e);
                    throw e;
                }
                catch (Throwable t) {
                    System.out.println();
                    System.out.println();
                    LOG.error("SQL Client must stop. Unexpected exception. This is a bug. Please consider filing an issue.", t);
                    throw new SqlClientException("Unexpected exception. This is a bug. Please consider filing an issue.", t);
                }
            }
            case "gateway": {
                throw new SqlClientException("Gateway mode is not supported yet.");
            }
            default: {
                CliOptionsParser.printHelpClient();
            }
        }
    }

    private String readExecutionContent() {
        if (this.options.getSqlFile() != null) {
            return this.readFromURL(this.options.getSqlFile());
        }
        return this.options.getUpdateStatement().trim();
    }

    private String readFromURL(URL file) {
        try {
            return IOUtils.toString((URL)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SqlExecutionException(String.format("Fail to read content from the %s.", file.getPath()), e);
        }
    }

    private static class EmbeddedShutdownThread
    extends Thread {
        private final String sessionId;
        private final Executor executor;

        public EmbeddedShutdownThread(String sessionId, Executor executor) {
            this.sessionId = sessionId;
            this.executor = executor;
        }

        @Override
        public void run() {
            System.out.println("\nShutting down the session...");
            this.executor.closeSession(this.sessionId);
            System.out.println("done.");
        }
    }
}

