/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.config.ResultMode;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.utils.print.RowDataToStringConverter;

public class ResultDescriptor {
    private final String resultId;
    private final ResolvedSchema resultSchema;
    private final boolean isMaterialized;
    private final ReadableConfig config;
    private final RowDataToStringConverter rowDataToStringConverter;

    public ResultDescriptor(String resultId, ResolvedSchema resultSchema, boolean isMaterialized, ReadableConfig config, RowDataToStringConverter rowDataToStringConverter) {
        this.resultId = resultId;
        this.resultSchema = resultSchema;
        this.isMaterialized = isMaterialized;
        this.config = config;
        this.rowDataToStringConverter = rowDataToStringConverter;
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResolvedSchema getResultSchema() {
        return this.resultSchema;
    }

    public boolean isMaterialized() {
        return this.isMaterialized;
    }

    public boolean isTableauMode() {
        return ((ResultMode)((Object)this.config.get(SqlClientOptions.EXECUTION_RESULT_MODE))).equals((Object)ResultMode.TABLEAU);
    }

    public boolean isStreamingMode() {
        return ((RuntimeExecutionMode)this.config.get(ExecutionOptions.RUNTIME_MODE)).equals((Object)RuntimeExecutionMode.STREAMING);
    }

    public int maxColumnWidth() {
        return (Integer)this.config.get(SqlClientOptions.DISPLAY_MAX_COLUMN_WIDTH);
    }

    public RowDataToStringConverter getRowDataStringConverter() {
        return this.rowDataToStringConverter;
    }
}

