/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectResultBase;
import org.apache.flink.table.data.RowData;

public class MaterializedCollectBatchResult
extends MaterializedCollectResultBase {
    @VisibleForTesting
    public MaterializedCollectBatchResult(TableResultInternal tableResult, int maxRowCount, int overcommitThreshold) {
        super(tableResult, maxRowCount, overcommitThreshold);
        this.retrievalThread.start();
    }

    public MaterializedCollectBatchResult(TableResultInternal tableResult, int maxRowCount) {
        this(tableResult, maxRowCount, MaterializedCollectBatchResult.computeMaterializedTableOvercommit(maxRowCount));
    }

    @Override
    protected void processRecord(RowData row) {
        if (this.materializedTable.size() - this.validRowPosition >= this.maxRowCount) {
            this.cleanUp();
        }
        this.materializedTable.add(row);
    }

    private void cleanUp() {
        this.materializedTable.set(this.validRowPosition, null);
        ++this.validRowPosition;
        if (this.validRowPosition >= this.overcommitThreshold) {
            this.materializedTable.subList(0, this.validRowPosition).clear();
            this.validRowPosition = 0;
        }
    }
}

