/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.module.Module;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SessionEnvironment {
    @Nullable
    private final String sessionName;
    private final EndpointVersion version;
    private final Map<String, Catalog> registeredCatalogs;
    private final Map<String, Module> registeredModules;
    @Nullable
    private final String defaultCatalog;
    private final Map<String, String> sessionConfig;

    @VisibleForTesting
    SessionEnvironment(@Nullable String sessionName, EndpointVersion version, Map<String, Catalog> registeredCatalogs, Map<String, Module> registeredModules, @Nullable String defaultCatalog, Map<String, String> sessionConfig) {
        this.sessionName = sessionName;
        this.version = version;
        this.registeredCatalogs = registeredCatalogs;
        this.registeredModules = registeredModules;
        this.defaultCatalog = defaultCatalog;
        this.sessionConfig = sessionConfig;
    }

    public Optional<String> getSessionName() {
        return Optional.ofNullable(this.sessionName);
    }

    public EndpointVersion getSessionEndpointVersion() {
        return this.version;
    }

    public Map<String, String> getSessionConfig() {
        return Collections.unmodifiableMap(this.sessionConfig);
    }

    public Map<String, Catalog> getRegisteredCatalogs() {
        return Collections.unmodifiableMap(this.registeredCatalogs);
    }

    public Map<String, Module> getRegisteredModules() {
        return Collections.unmodifiableMap(this.registeredModules);
    }

    public Optional<String> getDefaultCatalog() {
        return Optional.ofNullable(this.defaultCatalog);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionEnvironment)) {
            return false;
        }
        SessionEnvironment that = (SessionEnvironment)o;
        return Objects.equals(this.sessionName, that.sessionName) && Objects.equals(this.version, that.version) && Objects.equals(this.registeredCatalogs, that.registeredCatalogs) && Objects.equals(this.registeredModules, that.registeredModules) && Objects.equals(this.defaultCatalog, that.defaultCatalog) && Objects.equals(this.sessionConfig, that.sessionConfig);
    }

    public int hashCode() {
        return Objects.hash(this.sessionName, this.version, this.registeredCatalogs, this.registeredModules, this.defaultCatalog, this.sessionConfig);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @PublicEvolving
    public static class Builder {
        @Nullable
        private String sessionName;
        private EndpointVersion version;
        private final Map<String, String> sessionConfig = new HashMap<String, String>();
        private final Map<String, Catalog> registeredCatalogs = new HashMap<String, Catalog>();
        private final Map<String, Module> registeredModules = new HashMap<String, Module>();
        @Nullable
        private String defaultCatalog;

        public Builder setSessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public Builder setSessionEndpointVersion(EndpointVersion version) {
            this.version = version;
            return this;
        }

        public Builder addSessionConfig(Map<String, String> sessionConfig) {
            this.sessionConfig.putAll(sessionConfig);
            return this;
        }

        public Builder setDefaultCatalog(@Nullable String defaultCatalog) {
            this.defaultCatalog = defaultCatalog;
            return this;
        }

        public Builder registerCatalog(String catalogName, Catalog catalog) {
            if (this.registeredCatalogs.containsKey(catalogName)) {
                throw new ValidationException(String.format("A catalog with name '%s' already exists.", catalogName));
            }
            this.registeredCatalogs.put(catalogName, catalog);
            return this;
        }

        public Builder registerModuleAtHead(String moduleName, Module module) {
            if (this.registeredModules.containsKey(moduleName)) {
                throw new ValidationException(String.format("A module with name '%s' already exists", moduleName));
            }
            this.registeredModules.put(moduleName, module);
            return this;
        }

        public SessionEnvironment build() {
            return new SessionEnvironment(this.sessionName, (EndpointVersion)Preconditions.checkNotNull((Object)this.version), this.registeredCatalogs, this.registeredModules, this.defaultCatalog, this.sessionConfig);
        }
    }
}

