/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.changelog.SequenceNumber;
import org.apache.flink.runtime.taskmanager.AsyncExceptionHandler;
import org.apache.flink.state.changelog.ChangelogKeyedStateBackend;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeriodicMaterializationManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicMaterializationManager.class);
    private final MailboxExecutor mailboxExecutor;
    private final ExecutorService asyncOperationsThreadPool;
    private final ScheduledExecutorService periodicExecutor;
    private final AsyncExceptionHandler asyncExceptionHandler;
    private final String subtaskName;
    private final long periodicMaterializeDelay;
    private final int allowedNumberOfFailures;
    private final AtomicInteger numberOfConsecutiveFailures;
    private final ChangelogKeyedStateBackend<?> keyedStateBackend;
    private boolean started = false;
    private final long initialDelay;

    PeriodicMaterializationManager(MailboxExecutor mailboxExecutor, ExecutorService asyncOperationsThreadPool, String subtaskName, AsyncExceptionHandler asyncExceptionHandler, ChangelogKeyedStateBackend<?> keyedStateBackend, long periodicMaterializeDelay, int allowedNumberOfFailures, String operatorSubtaskId) {
        this.mailboxExecutor = (MailboxExecutor)Preconditions.checkNotNull((Object)mailboxExecutor);
        this.asyncOperationsThreadPool = (ExecutorService)Preconditions.checkNotNull((Object)asyncOperationsThreadPool);
        this.subtaskName = (String)Preconditions.checkNotNull((Object)subtaskName);
        this.asyncExceptionHandler = (AsyncExceptionHandler)Preconditions.checkNotNull((Object)asyncExceptionHandler);
        this.keyedStateBackend = (ChangelogKeyedStateBackend)Preconditions.checkNotNull(keyedStateBackend);
        this.periodicMaterializeDelay = periodicMaterializeDelay;
        this.allowedNumberOfFailures = allowedNumberOfFailures;
        this.numberOfConsecutiveFailures = new AtomicInteger(0);
        this.periodicExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorThreadFactory("periodic-materialization-scheduler-" + subtaskName));
        this.initialDelay = (long)MathUtils.murmurHash((int)operatorSubtaskId.hashCode()) % periodicMaterializeDelay;
    }

    public void start() {
        if (!this.started && this.periodicMaterializeDelay >= 0L) {
            this.started = true;
            LOG.info("Task {} starts periodic materialization", (Object)this.subtaskName);
            this.scheduleNextMaterialization(this.initialDelay);
        }
    }

    @Override
    public synchronized void close() {
        LOG.info("Shutting down PeriodicMaterializationManager.");
        if (!this.periodicExecutor.isShutdown()) {
            this.periodicExecutor.shutdownNow();
        }
    }

    @VisibleForTesting
    public void triggerMaterialization() {
        this.mailboxExecutor.execute(() -> {
            Optional<MaterializationRunnable> materializationRunnableOptional = this.keyedStateBackend.initMaterialization();
            if (materializationRunnableOptional.isPresent()) {
                MaterializationRunnable runnable = materializationRunnableOptional.get();
                this.asyncOperationsThreadPool.execute(() -> this.asyncMaterializationPhase(runnable.getMaterializationRunnable(), runnable.getMaterializationID(), runnable.getMaterializedTo()));
            } else {
                this.scheduleNextMaterialization();
                LOG.info("Task {} has no state updates since last materialization, skip this one and schedule the next one in {} seconds", (Object)this.subtaskName, (Object)(this.periodicMaterializeDelay / 1000L));
            }
        }, "materialization");
    }

    private void asyncMaterializationPhase(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializedRunnableFuture, long materializationID, SequenceNumber upTo) {
        this.uploadSnapshot(materializedRunnableFuture).whenComplete((snapshotResult, throwable) -> {
            if (throwable == null) {
                this.numberOfConsecutiveFailures.set(0);
                this.mailboxExecutor.execute(() -> this.keyedStateBackend.updateChangelogSnapshotState((SnapshotResult<KeyedStateHandle>)snapshotResult, materializationID, upTo), "Task {} update materializedSnapshot up to changelog sequence number: {}", new Object[]{this.subtaskName, upTo});
                this.scheduleNextMaterialization();
            } else if (throwable instanceof CancellationException) {
                LOG.info("materialization cancelled", throwable);
                this.scheduleNextMaterialization();
            } else {
                int retryTime = this.numberOfConsecutiveFailures.incrementAndGet();
                if (retryTime <= this.allowedNumberOfFailures) {
                    LOG.info("Task {} asynchronous part of materialization is not completed for the {} time.", new Object[]{this.subtaskName, retryTime, throwable});
                    this.scheduleNextMaterialization();
                } else {
                    this.asyncExceptionHandler.handleAsyncException("Task " + this.subtaskName + " fails to complete the asynchronous part of materialization", throwable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<SnapshotResult<KeyedStateHandle>> uploadSnapshot(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializedRunnableFuture) {
        FileSystemSafetyNet.initializeSafetyNetForThread();
        CompletableFuture<SnapshotResult<KeyedStateHandle>> result = new CompletableFuture<SnapshotResult<KeyedStateHandle>>();
        try {
            FutureUtils.runIfNotDoneAndGet(materializedRunnableFuture);
            LOG.debug("Task {} finishes asynchronous part of materialization.", (Object)this.subtaskName);
            result.complete((SnapshotResult<KeyedStateHandle>)materializedRunnableFuture.get());
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            this.discardFailedUploads(materializedRunnableFuture);
        }
        finally {
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        }
        return result;
    }

    private void discardFailedUploads(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializedRunnableFuture) {
        LOG.info("Task {} cleanup asynchronous runnable for materialization.", (Object)this.subtaskName);
        if (materializedRunnableFuture != null && !materializedRunnableFuture.cancel(true)) {
            try {
                StateObject stateObject = (StateObject)materializedRunnableFuture.get();
                if (stateObject != null) {
                    stateObject.discardState();
                }
            }
            catch (Exception ex) {
                LOG.debug("Task " + this.subtaskName + " cancelled execution of snapshot future runnable. Cancellation produced the following exception, which is expected and can be ignored.", (Throwable)ex);
            }
        }
    }

    private void scheduleNextMaterialization() {
        this.scheduleNextMaterialization(this.periodicMaterializeDelay);
    }

    private synchronized void scheduleNextMaterialization(long delay) {
        if (this.started && !this.periodicExecutor.isShutdown()) {
            LOG.info("Task {} schedules the next materialization in {} seconds", (Object)this.subtaskName, (Object)(delay / 1000L));
            this.periodicExecutor.schedule(this::triggerMaterialization, delay, TimeUnit.MILLISECONDS);
        }
    }

    static class MaterializationRunnable {
        private final RunnableFuture<SnapshotResult<KeyedStateHandle>> materializationRunnable;
        private final long materializationID;
        private final SequenceNumber materializedTo;

        public MaterializationRunnable(RunnableFuture<SnapshotResult<KeyedStateHandle>> materializationRunnable, long materializationID, SequenceNumber materializedTo) {
            this.materializationRunnable = materializationRunnable;
            this.materializedTo = materializedTo;
            this.materializationID = materializationID;
        }

        RunnableFuture<SnapshotResult<KeyedStateHandle>> getMaterializationRunnable() {
            return this.materializationRunnable;
        }

        SequenceNumber getMaterializedTo() {
            return this.materializedTo;
        }

        public long getMaterializationID() {
            return this.materializationID;
        }
    }
}

