/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.state.changelog.ChangelogState;
import org.apache.flink.state.changelog.KvStateChangeLogger;
import org.apache.flink.state.changelog.StateChangeLogger;
import org.apache.flink.util.Preconditions;

abstract class AbstractChangelogState<K, N, V, S extends InternalKvState<K, N, V>>
implements InternalKvState<K, N, V>,
ChangelogState {
    protected S delegatedState;
    protected final KvStateChangeLogger<V, N> changeLogger;
    private N currentNamespace;

    AbstractChangelogState(S state, KvStateChangeLogger<V, N> changeLogger) {
        Preconditions.checkArgument((!(state instanceof AbstractChangelogState) ? 1 : 0) != 0);
        this.delegatedState = (InternalKvState)Preconditions.checkNotNull(state);
        this.changeLogger = (KvStateChangeLogger)Preconditions.checkNotNull(changeLogger);
    }

    public S getDelegatedState() {
        return this.delegatedState;
    }

    public StateChangeLogger<V, N> getStateChangeLogger() {
        return this.changeLogger;
    }

    @Override
    public <IS> void setDelegatedState(IS state) {
        this.delegatedState = (InternalKvState)Preconditions.checkNotNull(state);
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.delegatedState.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.delegatedState.getNamespaceSerializer();
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.delegatedState.getValueSerializer();
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = namespace;
        this.delegatedState.setCurrentNamespace(namespace);
    }

    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        return this.delegatedState.getSerializedValue(serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer, safeValueSerializer);
    }

    public InternalKvState.StateIncrementalVisitor<K, N, V> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return this.delegatedState.getStateIncrementalVisitor(recommendedMaxNumberOfReturnedRecords);
    }

    @Override
    public void resetWritingMetaFlag() {
        this.changeLogger.resetWritingMetaFlag();
    }

    protected N getCurrentNamespace() throws NullPointerException {
        return (N)Preconditions.checkNotNull(this.currentNamespace);
    }
}

