/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractInput;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class TestAnyModeMultipleInputStreamOperator
extends AbstractStreamOperatorV2<String>
implements MultipleInputStreamOperator<String>,
InputSelectable {
    public TestAnyModeMultipleInputStreamOperator(StreamOperatorParameters<String> parameters) {
        super(parameters, 2);
    }

    public InputSelection nextSelection() {
        return InputSelection.ALL;
    }

    public List<Input> getInputs() {
        return Arrays.asList(new Input[]{new ToStringInput(this, 1), new ToStringInput(this, 2)});
    }

    public static class ToStringInput<T>
    extends AbstractInput<T, String> {
        public ToStringInput(AbstractStreamOperatorV2<String> owner, int inputId) {
            super(owner, inputId);
        }

        public void processElement(StreamRecord<T> element) {
            this.output.collect((Object)element.replace((Object)String.format("[%d]: %s", this.inputId, element.getValue())));
        }
    }

    public static class Factory
    extends AbstractStreamOperatorFactory<String> {
        public <T extends StreamOperator<String>> T createStreamOperator(StreamOperatorParameters<String> parameters) {
            return (T)((Object)new TestAnyModeMultipleInputStreamOperator(parameters));
        }

        public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
            return TestAnyModeMultipleInputStreamOperator.class;
        }
    }
}

