/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.scala;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamGroupedReduce;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.WindowedStream;
import org.apache.flink.streaming.api.scala.function.StatefulFunction;
import org.apache.flink.streaming.api.scala.function.StatefulFunction$class;
import org.apache.flink.streaming.api.scala.package$;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Public
@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001=\u00111bS3zK\u0012\u001cFO]3b[*\u00111\u0001B\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000b\u0019\t1!\u00199j\u0015\t9\u0001\"A\u0005tiJ,\u0017-\\5oO*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007A9\"f\u0005\u0002\u0001#A\u0019!cE\u000b\u000e\u0003\tI!\u0001\u0006\u0002\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!\u0001+\u0012\u0005iy\u0002CA\u000e\u001e\u001b\u0005a\"\"A\u0002\n\u0005ya\"a\u0002(pi\"Lgn\u001a\t\u00037\u0001J!!\t\u000f\u0003\u0007\u0005s\u0017\u0010\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003)Q\u0017M^1TiJ,\u0017-\u001c\t\u0005K!*\u0012&D\u0001'\u0015\t9C!\u0001\u0006eCR\f7\u000f\u001e:fC6L!!\u0001\u0014\u0011\u0005YQC!B\u0016\u0001\u0005\u0004I\"!A&\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0003\u0013\u0001UI\u0003\"B\u0012-\u0001\u0004!\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014AC4fi.+\u0017\u0010V=qKV\tA\u0007E\u00026w%j\u0011A\u000e\u0006\u0003oa\n\u0001\u0002^=qK&tgm\u001c\u0006\u0003si\naaY8n[>t'BA\u0003\t\u0013\tadGA\bUsB,\u0017J\u001c4pe6\fG/[8oQ\t\td\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\r\u0003%\u0001C%oi\u0016\u0014h.\u00197\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0015QLW.Z,j]\u0012|w\u000f\u0006\u0002H%B)!\u0003S\u000b*\u0015&\u0011\u0011J\u0001\u0002\u000f/&tGm\\<fIN#(/Z1n!\tY\u0005+D\u0001M\u0015\tie*A\u0004xS:$wn^:\u000b\u0005=#\u0011!C<j]\u0012|w/\u001b8h\u0013\t\tFJ\u0001\u0006US6,w+\u001b8e_^DQa\u0015#A\u0002Q\u000bAa]5{KB\u0011Q\u000bW\u0007\u0002-*\u0011qKT\u0001\u0005i&lW-\u0003\u0002Z-\n!A+[7f\u0011\u0015Y\u0006\u0001\"\u0001]\u0003-\u0019w.\u001e8u/&tGm\\<\u0015\u0007u\u000bW\rE\u0003\u0013\u0011VIc\f\u0005\u0002L?&\u0011\u0001\r\u0014\u0002\r\u000f2|'-\u00197XS:$wn\u001e\u0005\u0006'j\u0003\rA\u0019\t\u00037\rL!\u0001\u001a\u000f\u0003\t1{gn\u001a\u0005\u0006Mj\u0003\rAY\u0001\u0006g2LG-\u001a\u0005\u00067\u0002!\t\u0001\u001b\u000b\u0003;&DQaU4A\u0002\tDQ!\u0012\u0001\u0005\u0002-$2a\u00127n\u0011\u0015\u0019&\u000e1\u0001U\u0011\u00151'\u000e1\u0001U\u0011\u0015y\u0007\u0001\"\u0001q\u0003\u00199\u0018N\u001c3poV\u0011\u0011\u000f\u001e\u000b\u0003ej\u0004RA\u0005%\u0016SM\u0004\"A\u0006;\u0005\u000bUt'\u0019\u0001<\u0003\u0003]\u000b\"AG<\u0011\u0005-C\u0018BA=M\u0005\u00199\u0016N\u001c3po\")1P\u001ca\u0001y\u0006A\u0011m]:jO:,'\u000fM\u0002~\u0003\u0013\u0001bA`A\u0002\u0003\u000f\u0019X\"A@\u000b\u0007\u0005\u0005a*A\u0005bgNLwM\\3sg&\u0019\u0011QA@\u0003\u001d]Kg\u000eZ8x\u0003N\u001c\u0018n\u001a8feB\u0019a#!\u0003\u0005\u0017\u0005-!0!A\u0001\u0002\u000b\u0005\u0011Q\u0002\u0002\u0004?\u0012\n\u0014CA\u000b Q\rq\u0017\u0011\u0003\t\u0004\u007f\u0005M\u0011bAA\u000b\u0001\nq\u0001+\u001e2mS\u000e,eo\u001c7wS:<\u0007bBA\r\u0001\u0011\u0005\u00111D\u0001\u0007e\u0016$WoY3\u0015\u0007E\ti\u0002\u0003\u0005\u0002 \u0005]\u0001\u0019AA\u0011\u0003\u001d\u0011X\rZ;dKJ\u0004R!a\t\u0002*Ui!!!\n\u000b\u0007\u0005\u001d\u0002(A\u0005gk:\u001cG/[8og&!\u00111FA\u0013\u00059\u0011V\rZ;dK\u001a+hn\u0019;j_:Dq!!\u0007\u0001\t\u0003\ty\u0003F\u0002\u0012\u0003cA\u0001\"a\r\u0002.\u0001\u0007\u0011QG\u0001\u0004MVt\u0007CB\u000e\u00028U)R#C\u0002\u0002:q\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005!am\u001c7e+\u0011\t\t%!\u0013\u0015\r\u0005\r\u00131KA,)\u0011\t)%!\u0014\u0011\tI\u0019\u0012q\t\t\u0004-\u0005%CaBA&\u0003w\u0011\r!\u0007\u0002\u0002%\"Q\u0011qJA\u001e\u0003\u0003\u0005\u001d!!\u0015\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u00036w\u0005\u001d\u0003\u0002CA+\u0003w\u0001\r!a\u0012\u0002\u0019%t\u0017\u000e^5bYZ\u000bG.^3\t\u0011\u0005e\u00131\ba\u0001\u00037\naAZ8mI\u0016\u0014\bcBA\u0012\u0003;*\u0012qI\u0005\u0005\u0003?\n)C\u0001\u0007G_2$g)\u001e8di&|g\u000eC\u0004\u0002>\u0001!\t!a\u0019\u0016\t\u0005\u0015\u0014q\u000e\u000b\u0005\u0003O\nY\b\u0006\u0003\u0002j\u0005]D\u0003BA6\u0003c\u0002BAE\n\u0002nA\u0019a#a\u001c\u0005\u000f\u0005-\u0013\u0011\rb\u00013!Q\u00111OA1\u0003\u0003\u0005\u001d!!\u001e\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u00036w\u00055\u0004\u0002CA\u001a\u0003C\u0002\r!!\u001f\u0011\u0011m\t9$!\u001c\u0016\u0003[B\u0001\"!\u0016\u0002b\u0001\u0007\u0011Q\u000e\u0005\b\u0003\u007f\u0002A\u0011AAA\u0003\ri\u0017\r\u001f\u000b\u0004#\u0005\r\u0005\u0002CAC\u0003{\u0002\r!a\"\u0002\u0011A|7/\u001b;j_:\u00042aGAE\u0013\r\tY\t\b\u0002\u0004\u0013:$\bbBA@\u0001\u0011\u0005\u0011q\u0012\u000b\u0004#\u0005E\u0005\u0002CAJ\u0003\u001b\u0003\r!!&\u0002\u000b\u0019LW\r\u001c3\u0011\t\u0005]\u0015Q\u0014\b\u00047\u0005e\u0015bAAN9\u00051\u0001K]3eK\u001aLA!a(\u0002\"\n11\u000b\u001e:j]\u001eT1!a'\u001d\u0011\u001d\t)\u000b\u0001C\u0001\u0003O\u000b1!\\5o)\r\t\u0012\u0011\u0016\u0005\t\u0003\u000b\u000b\u0019\u000b1\u0001\u0002\b\"9\u0011Q\u0015\u0001\u0005\u0002\u00055FcA\t\u00020\"A\u00111SAV\u0001\u0004\t)\nC\u0004\u00024\u0002!\t!!.\u0002\u0007M,X\u000eF\u0002\u0012\u0003oC\u0001\"!\"\u00022\u0002\u0007\u0011q\u0011\u0005\b\u0003g\u0003A\u0011AA^)\r\t\u0012Q\u0018\u0005\t\u0003'\u000bI\f1\u0001\u0002\u0016\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0017!B7j]\nKHcA\t\u0002F\"A\u0011QQA`\u0001\u0004\t9\tC\u0004\u0002B\u0002!\t!!3\u0015\u0007E\tY\r\u0003\u0005\u0002\u0014\u0006\u001d\u0007\u0019AAK\u0011\u001d\ty\r\u0001C\u0001\u0003#\fQ!\\1y\u0005f$2!EAj\u0011!\t))!4A\u0002\u0005\u001d\u0005bBAh\u0001\u0011\u0005\u0011q\u001b\u000b\u0004#\u0005e\u0007\u0002CAJ\u0003+\u0004\r!!&\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\u0006I\u0011mZ4sK\u001e\fG/\u001a\u000b\u0006#\u0005\u0005(1\u0004\u0005\t\u0003G\fY\u000e1\u0001\u0002f\u0006y\u0011mZ4sK\u001e\fG/[8o)f\u0004X\r\u0005\u0003\u0002h\nUa\u0002BAu\u0005\u001fqA!a;\u0003\n9!\u0011Q\u001eB\u0004\u001d\u0011\tyO!\u0002\u000f\t\u0005E(1\u0001\b\u0005\u0003g\u0014\tA\u0004\u0003\u0002v\u0006}h\u0002BA|\u0003{l!!!?\u000b\u0007\u0005mh\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011bAA\u0014\t%!!1\u0002B\u0007\u0003-\twm\u001a:fO\u0006$\u0018n\u001c8\u000b\u0007\u0005\u001dB!\u0003\u0003\u0003\u0012\tM\u0011aE!hOJ,w-\u0019;j_:4UO\\2uS>t'\u0002\u0002B\u0006\u0005\u001bIAAa\u0006\u0003\u001a\ty\u0011iZ4sK\u001e\fG/[8o)f\u0004XM\u0003\u0003\u0003\u0012\tM\u0001\u0002CAJ\u00037\u0004\r!!&\t\u000f\u0005u\u0007\u0001\"\u0003\u0003 Q)\u0011C!\t\u0003$!A\u00111\u001dB\u000f\u0001\u0004\t)\u000f\u0003\u0005\u0002\u0006\nu\u0001\u0019AAD\u0011\u001d\u00119\u0003\u0001C\u0001\u0005S\tqBZ5mi\u0016\u0014x+\u001b;i'R\fG/Z\u000b\u0005\u0005W\u00119\u0004\u0006\u0003\u0003.\tmBcA\t\u00030!Q!\u0011\u0007B\u0013\u0003\u0003\u0005\u001dAa\r\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u00036w\tU\u0002c\u0001\f\u00038\u00119!\u0011\bB\u0013\u0005\u0004I\"!A*\t\u0011\u0005M\"Q\u0005a\u0001\u0005{\u0001\u0002bGA\u001c+\t}\"Q\t\t\u00067\t\u0005#QG\u0005\u0004\u0005\u0007b\"AB(qi&|g\u000eE\u0004\u001c\u0005\u000f\u0012YEa\u0010\n\u0007\t%CD\u0001\u0004UkBdWM\r\t\u00047\t5\u0013b\u0001B(9\t9!i\\8mK\u0006t\u0007b\u0002B*\u0001\u0011\u0005!QK\u0001\r[\u0006\u0004x+\u001b;i'R\fG/Z\u000b\u0007\u0005/\u0012yFa\u001c\u0015\t\te#\u0011\u000f\u000b\u0007\u00057\u0012\tGa\u001a\u0011\tI\u0019\"Q\f\t\u0004-\t}CaBA&\u0005#\u0012\r!\u0007\u0005\u000b\u0005G\u0012\t&!AA\u0004\t\u0015\u0014AC3wS\u0012,gnY3%iA!Qg\u000fB/\u0011)\u0011IG!\u0015\u0002\u0002\u0003\u000f!1N\u0001\u000bKZLG-\u001a8dK\u0012*\u0004\u0003B\u001b<\u0005[\u00022A\u0006B8\t\u001d\u0011ID!\u0015C\u0002eA\u0001\"a\r\u0003R\u0001\u0007!1\u000f\t\t7\u0005]RC!\u001e\u0003xA)1D!\u0011\u0003nA91Da\u0012\u0003^\tU\u0004b\u0002B>\u0001\u0011\u0005!QP\u0001\u0011M2\fG/T1q/&$\bn\u0015;bi\u0016,bAa \u0003\b\n]E\u0003\u0002BA\u00053#bAa!\u0003\n\n=\u0005\u0003\u0002\n\u0014\u0005\u000b\u00032A\u0006BD\t\u001d\tYE!\u001fC\u0002eA!Ba#\u0003z\u0005\u0005\t9\u0001BG\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0005km\u0012)\t\u0003\u0006\u0003\u0012\ne\u0014\u0011!a\u0002\u0005'\u000b!\"\u001a<jI\u0016t7-\u001a\u00138!\u0011)4H!&\u0011\u0007Y\u00119\nB\u0004\u0003:\te$\u0019A\r\t\u0011\u0005M\"\u0011\u0010a\u0001\u00057\u0003\u0002bGA\u001c+\tu%q\u0014\t\u00067\t\u0005#Q\u0013\t\b7\t\u001d#\u0011\u0015BO!\u0019\u0011\u0019K!,\u0003\u0006:!!Q\u0015BU\u001d\u0011\t9Pa*\n\u0003\rI1Aa+\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LAAa,\u00032\nyAK]1wKJ\u001c\u0018M\u00197f\u001f:\u001cWMC\u0002\u0003,rA3\u0001\u0001B[!\ry$qW\u0005\u0004\u0005s\u0003%A\u0002)vE2L7\r")
public class KeyedStream<T, K>
extends DataStream<T> {
    private final org.apache.flink.streaming.api.datastream.KeyedStream<T, K> javaStream;

    @Internal
    public TypeInformation<K> getKeyType() {
        return this.javaStream.getKeyType();
    }

    public WindowedStream<T, K, TimeWindow> timeWindow(Time size) {
        return new WindowedStream(this.javaStream.timeWindow(size));
    }

    public WindowedStream<T, K, GlobalWindow> countWindow(long size, long slide) {
        return new WindowedStream(this.javaStream.countWindow(size, slide));
    }

    public WindowedStream<T, K, GlobalWindow> countWindow(long size) {
        return new WindowedStream(this.javaStream.countWindow(size));
    }

    public WindowedStream<T, K, TimeWindow> timeWindow(Time size, Time slide) {
        return new WindowedStream(this.javaStream.timeWindow(size, slide));
    }

    @PublicEvolving
    public <W extends Window> WindowedStream<T, K, W> window(WindowAssigner<? super T, W> assigner) {
        return new WindowedStream(new org.apache.flink.streaming.api.datastream.WindowedStream(this.javaStream, assigner));
    }

    public DataStream<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return package$.MODULE$.asScalaStream(this.javaStream.reduce(reducer));
    }

    public DataStream<T> reduce(Function2<T, T, T> fun) {
        if (fun == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        Function2<T, T, T> cleanFun = this.clean(fun);
        ReduceFunction reducer = new ReduceFunction<T>(this, cleanFun){
            private final Function2 cleanFun$1;

            public T reduce(T v1, T v2) {
                return (T)this.cleanFun$1.apply(v1, v2);
            }
            {
                this.cleanFun$1 = cleanFun$1;
            }
        };
        return this.reduce(reducer);
    }

    public <R> DataStream<R> fold(R initialValue, FoldFunction<T, R> folder, TypeInformation<R> evidence$1) {
        if (folder == null) {
            throw new NullPointerException("Fold function must not be null.");
        }
        TypeInformation outType = (TypeInformation)Predef$.MODULE$.implicitly(evidence$1);
        return package$.MODULE$.asScalaStream(this.javaStream.fold(initialValue, folder).returns(outType));
    }

    public <R> DataStream<R> fold(R initialValue, Function2<R, T, R> fun, TypeInformation<R> evidence$2) {
        if (fun == null) {
            throw new NullPointerException("Fold function must not be null.");
        }
        Function2<R, T, R> cleanFun = this.clean(fun);
        FoldFunction folder = new FoldFunction<T, R>(this, cleanFun){
            private final Function2 cleanFun$2;

            public R fold(R acc, T v) {
                return (R)this.cleanFun$2.apply(acc, v);
            }
            {
                this.cleanFun$2 = cleanFun$2;
            }
        };
        return this.fold(initialValue, folder, evidence$2);
    }

    public DataStream<T> max(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, position);
    }

    public DataStream<T> max(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAX, field);
    }

    public DataStream<T> min(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, position);
    }

    public DataStream<T> min(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MIN, field);
    }

    public DataStream<T> sum(int position) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, position);
    }

    public DataStream<T> sum(String field) {
        return this.aggregate(AggregationFunction.AggregationType.SUM, field);
    }

    public DataStream<T> minBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, position);
    }

    public DataStream<T> minBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MINBY, field);
    }

    public DataStream<T> maxBy(int position) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, position);
    }

    public DataStream<T> maxBy(String field) {
        return this.aggregate(AggregationFunction.AggregationType.MAXBY, field);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, String field) {
        int position = package$.MODULE$.fieldNames2Indices(this.javaStream.getType(), (String[])((Object[])new String[]{field}))[0];
        return this.aggregate(aggregationType, position);
    }

    private DataStream<T> aggregate(AggregationFunction.AggregationType aggregationType, int position) {
        AggregationFunction.AggregationType aggregationType2 = aggregationType;
        Object object = AggregationFunction.AggregationType.SUM.equals(aggregationType2) ? new SumAggregator(position, this.javaStream.getType(), this.javaStream.getExecutionConfig()) : new ComparableAggregator(position, this.javaStream.getType(), aggregationType, true, this.javaStream.getExecutionConfig());
        SumAggregator reducer = object;
        StreamGroupedReduce invokable = new StreamGroupedReduce((ReduceFunction)reducer, this.getType().createSerializer(this.getExecutionConfig()));
        return new DataStream(this.javaStream.transform("aggregation", this.javaStream.getType(), (OneInputStreamOperator)invokable));
    }

    public <S> DataStream<T> filterWithState(Function2<T, Option<S>, Tuple2<Object, Option<S>>> fun, TypeInformation<S> evidence$3) {
        if (fun == null) {
            throw new NullPointerException("Filter function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<Object, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$3);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.getExecutionConfig());
        StatefulFunction filterFun = new StatefulFunction<T, Object, S>(this, cleanFun, serializer){
            private final TypeSerializer<S> stateSerializer;
            private final Function2 cleanFun$3;
            private ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;

            public ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state() {
                return this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;
            }

            public void org$apache$flink$streaming$api$scala$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state = x$1;
            }

            public Object applyWithState(Object in, Function2 fun) {
                return StatefulFunction$class.applyWithState(this, in, fun);
            }

            public void open(Configuration c) {
                StatefulFunction$class.open(this, c);
            }

            public TypeSerializer<S> stateSerializer() {
                return this.stateSerializer;
            }

            public boolean filter(T in) {
                return BoxesRunTime.unboxToBoolean((Object)this.applyWithState(in, this.cleanFun$3));
            }
            {
                void var3_3;
                this.cleanFun$3 = cleanFun$3;
                StatefulFunction$class.$init$(this);
                this.stateSerializer = var3_3;
            }
        };
        return this.filter(filterFun);
    }

    public <R, S> DataStream<R> mapWithState(Function2<T, Option<S>, Tuple2<R, Option<S>>> fun, TypeInformation<R> evidence$4, TypeInformation<S> evidence$5) {
        if (fun == null) {
            throw new NullPointerException("Map function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<R, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$5);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.getExecutionConfig());
        StatefulFunction mapper = new StatefulFunction<T, R, S>(this, cleanFun, serializer){
            private final TypeSerializer<S> stateSerializer;
            private final Function2 cleanFun$4;
            private ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;

            public ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state() {
                return this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;
            }

            public void org$apache$flink$streaming$api$scala$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state = x$1;
            }

            public R applyWithState(T in, Function2<T, Option<S>, Tuple2<R, Option<S>>> fun) {
                return (R)StatefulFunction$class.applyWithState(this, in, fun);
            }

            public void open(Configuration c) {
                StatefulFunction$class.open(this, c);
            }

            public TypeSerializer<S> stateSerializer() {
                return this.stateSerializer;
            }

            public R map(T in) {
                return this.applyWithState(in, (Function2<T, Option<S>, Tuple2<R, Option<S>>>)this.cleanFun$4);
            }
            {
                void var3_3;
                this.cleanFun$4 = cleanFun$4;
                StatefulFunction$class.$init$(this);
                this.stateSerializer = var3_3;
            }
        };
        return this.map(mapper, evidence$4);
    }

    public <R, S> DataStream<R> flatMapWithState(Function2<T, Option<S>, Tuple2<TraversableOnce<R>, Option<S>>> fun, TypeInformation<R> evidence$6, TypeInformation<S> evidence$7) {
        if (fun == null) {
            throw new NullPointerException("Flatmap function must not be null.");
        }
        Function2<T, Option<S>, Tuple2<TraversableOnce<R>, Option<S>>> cleanFun = this.clean(fun);
        TypeInformation stateTypeInfo = (TypeInformation)Predef$.MODULE$.implicitly(evidence$7);
        TypeSerializer serializer = stateTypeInfo.createSerializer(this.getExecutionConfig());
        StatefulFunction flatMapper = new StatefulFunction<T, TraversableOnce<R>, S>(this, cleanFun, serializer){
            private final TypeSerializer<S> stateSerializer;
            private final Function2 cleanFun$5;
            private ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;

            public ValueState org$apache$flink$streaming$api$scala$function$StatefulFunction$$state() {
                return this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state;
            }

            public void org$apache$flink$streaming$api$scala$function$StatefulFunction$$state_$eq(ValueState x$1) {
                this.org$apache$flink$streaming$api$scala$function$StatefulFunction$$state = x$1;
            }

            public Object applyWithState(Object in, Function2 fun) {
                return StatefulFunction$class.applyWithState(this, in, fun);
            }

            public void open(Configuration c) {
                StatefulFunction$class.open(this, c);
            }

            public TypeSerializer<S> stateSerializer() {
                return this.stateSerializer;
            }

            public void flatMap(T in, Collector<R> out) {
                ((TraversableOnce)this.applyWithState(in, this.cleanFun$5)).foreach((Function1)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final Collector out$1;

                    public final void apply(R x$1) {
                        this.out$1.collect(x$1);
                    }
                    {
                        this.out$1 = out$1;
                    }
                });
            }
            {
                void var3_3;
                this.cleanFun$5 = cleanFun$5;
                StatefulFunction$class.$init$(this);
                this.stateSerializer = var3_3;
            }
        };
        return this.flatMap(flatMapper, evidence$6);
    }

    public KeyedStream(org.apache.flink.streaming.api.datastream.KeyedStream<T, K> javaStream) {
        this.javaStream = javaStream;
        super(javaStream);
    }
}

