/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogTest;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;

public abstract class CatalogTestBase
extends CatalogTest {
    public CatalogDatabase createDb() {
        return new CatalogDatabaseImpl((Map)new HashMap<String, String>(){
            {
                this.put("k1", "v1");
                this.putAll(CatalogTestBase.this.getGenericFlag(CatalogTestBase.this.isGeneric()));
            }
        }, "test comment");
    }

    public CatalogDatabase createAnotherDb() {
        return new CatalogDatabaseImpl((Map)new HashMap<String, String>(){
            {
                this.put("k2", "v2");
                this.putAll(CatalogTestBase.this.getGenericFlag(CatalogTestBase.this.isGeneric()));
            }
        }, "test comment");
    }

    public CatalogTable createTable() {
        return new CatalogTableImpl(this.createTableSchema(), this.getBatchTableProperties(), "test comment");
    }

    public CatalogTable createAnotherTable() {
        return new CatalogTableImpl(this.createAnotherTableSchema(), this.getBatchTableProperties(), "test comment");
    }

    public CatalogTable createStreamingTable() {
        Map<String, String> prop = this.getBatchTableProperties();
        prop.put("is_generic", String.valueOf(false));
        return new CatalogTableImpl(this.createTableSchema(), this.getStreamingTableProperties(), "test comment");
    }

    public CatalogTable createPartitionedTable() {
        return new CatalogTableImpl(this.createTableSchema(), this.createPartitionKeys(), this.getBatchTableProperties(), "test comment");
    }

    public CatalogTable createAnotherPartitionedTable() {
        return new CatalogTableImpl(this.createAnotherTableSchema(), this.createPartitionKeys(), this.getBatchTableProperties(), "test comment");
    }

    public CatalogPartition createPartition() {
        return new CatalogPartitionImpl(this.getBatchTableProperties(), "test comment");
    }

    public CatalogView createView() {
        return new CatalogViewImpl(String.format("select * from %s", "t1"), String.format("select * from %s.%s", "test-catalog", this.path1.getFullName()), this.createTableSchema(), this.getBatchTableProperties(), "This is a view");
    }

    public CatalogView createAnotherView() {
        return new CatalogViewImpl(String.format("select * from %s", "t2"), String.format("select * from %s.%s", "test-catalog", this.path2.getFullName()), this.createAnotherTableSchema(), this.getBatchTableProperties(), "This is another view");
    }

    protected Map<String, String> getBatchTableProperties() {
        return new HashMap<String, String>(){
            {
                this.put("is_streaming", "false");
                this.putAll(CatalogTestBase.this.getGenericFlag(CatalogTestBase.this.isGeneric()));
            }
        };
    }

    protected Map<String, String> getStreamingTableProperties() {
        return new HashMap<String, String>(){
            {
                this.put("is_streaming", "true");
                this.putAll(CatalogTestBase.this.getGenericFlag(CatalogTestBase.this.isGeneric()));
            }
        };
    }

    private Map<String, String> getGenericFlag(final boolean isGeneric) {
        return new HashMap<String, String>(){
            {
                this.put("is_generic", String.valueOf(isGeneric));
            }
        };
    }

    protected abstract boolean isGeneric();
}

