/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class FunctionCatalogTest {
    private static final ScalarFunction FUNCTION_1 = new TestFunction1();
    private static final ScalarFunction FUNCTION_2 = new TestFunction2();
    private static final ScalarFunction FUNCTION_3 = new TestFunction3();
    private static final ScalarFunction FUNCTION_4 = new TestFunction4();
    private static final ScalarFunction FUNCTION_INVALID = new InvalidTestFunction();
    private static final TableFunction<?> TABLE_FUNCTION = new TestTableFunction();
    private static final AggregateFunction<?, ?> AGGREGATE_FUNCTION = new TestAggregateFunction();
    private static final String NAME = "test_function";
    private static final ObjectIdentifier IDENTIFIER = ObjectIdentifier.of((String)"default_catalog", (String)"default_database", (String)"test_function");
    private static final UnresolvedIdentifier FULL_UNRESOLVED_IDENTIFIER = UnresolvedIdentifier.of((String[])new String[]{"default_catalog", "default_database", "test_function"});
    private static final UnresolvedIdentifier PARTIAL_UNRESOLVED_IDENTIFIER = UnresolvedIdentifier.of((String[])new String[]{"test_function"});
    private ModuleManager moduleManager;
    private FunctionCatalog functionCatalog;
    private Catalog catalog;

    @Before
    public void init() {
        this.catalog = new GenericInMemoryCatalog("default_catalog", "default_database");
        this.moduleManager = new ModuleManager();
        this.functionCatalog = new FunctionCatalog(TableConfig.getDefault(), CatalogManagerMocks.preparedCatalogManager().defaultCatalog("default_catalog", this.catalog).build(), this.moduleManager);
    }

    @Test
    public void testGetBuiltInFunctions() {
        HashSet actual = new HashSet();
        Collections.addAll(actual, this.functionCatalog.getFunctions());
        Set expected = new ModuleManager().listFunctions();
        Assert.assertTrue((boolean)actual.containsAll(expected));
    }

    @Test
    public void testPreciseFunctionReference() throws Exception {
        Assert.assertFalse((boolean)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER).isPresent());
        this.catalog.createFunction(IDENTIFIER.toObjectPath(), (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_2, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
    }

    @Test
    public void testAmbiguousFunctionReference() throws Exception {
        Assert.assertFalse((boolean)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER).isPresent());
        this.catalog.createFunction(IDENTIFIER.toObjectPath(), (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_2, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        this.moduleManager.loadModule("test_module", (Module)new TestModule());
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_3));
        this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_4, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_4));
    }

    @Test
    public void testTemporarySystemFunction() {
        this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_1, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_2, true);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        try {
            this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_2, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"A function named 'test_function' does already exist.")));
        }
        Assert.assertThat((Object)this.functionCatalog.dropTemporarySystemFunction(NAME, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsNoFunction());
        Assert.assertThat((Object)this.functionCatalog.dropTemporarySystemFunction(NAME, true), (Matcher)CoreMatchers.equalTo((Object)false));
        try {
            this.functionCatalog.dropTemporarySystemFunction(NAME, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"A function named 'test_function' doesn't exist.")));
        }
        try {
            this.functionCatalog.registerTemporarySystemFunction(NAME, (FunctionDefinition)FUNCTION_INVALID, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Could not register temporary system function 'test_function' due to implementation errors.")));
        }
    }

    @Test
    public void testUninstantiatedTemporarySystemFunction() {
        this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_1.getClass().getName(), FunctionLanguage.JAVA, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_2.getClass().getName(), FunctionLanguage.JAVA, true);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)FUNCTION_1));
        try {
            this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_2.getClass().getName(), FunctionLanguage.JAVA, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"A function named 'test_function' does already exist.")));
        }
        try {
            this.functionCatalog.registerTemporarySystemFunction(NAME, FUNCTION_INVALID.getClass().getName(), FunctionLanguage.JAVA, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Could not register temporary system function 'test_function' due to implementation errors.")));
        }
        this.functionCatalog.dropTemporarySystemFunction(NAME, true);
        this.functionCatalog.registerTemporarySystemFunction(NAME, TABLE_FUNCTION.getClass().getName(), FunctionLanguage.JAVA, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), TABLE_FUNCTION));
        this.functionCatalog.dropTemporarySystemFunction(NAME, true);
        this.functionCatalog.registerTemporarySystemFunction(NAME, AGGREGATE_FUNCTION.getClass().getName(), FunctionLanguage.JAVA, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((String)NAME), (FunctionDefinition)new AggregateFunctionDefinition(NAME, AGGREGATE_FUNCTION, Types.STRING, Types.STRING)));
    }

    @Test
    public void testCatalogFunction() {
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_1.getClass(), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), true);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        try {
            this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A function '" + IDENTIFIER.asSummaryString() + "' does already exist."))));
        }
        Assert.assertThat((Object)this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsNoFunction());
        Assert.assertThat((Object)this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true), (Matcher)CoreMatchers.equalTo((Object)false));
        try {
            this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A function '" + IDENTIFIER.asSummaryString() + "' doesn't exist."))));
        }
        try {
            this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_INVALID.getClass(), false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("Could not register catalog function '" + IDENTIFIER.asSummaryString() + "' due to implementation errors."))));
        }
    }

    @Test
    public void testTemporaryCatalogFunction() {
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_1, false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        try {
            this.functionCatalog.dropCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A temporary function '" + IDENTIFIER.asSummaryString() + "' does already exist. Please drop the temporary function first."))));
        }
        try {
            this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A temporary function '" + IDENTIFIER.asSummaryString() + "' does already exist. Please drop the temporary function first."))));
        }
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_1, true);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        try {
            this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_2, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A function '" + IDENTIFIER.asSummaryString() + "' does already exist."))));
        }
        Assert.assertThat((Object)this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        Assert.assertThat((Object)this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true), (Matcher)CoreMatchers.equalTo((Object)false));
        try {
            this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A function '" + IDENTIFIER.asSummaryString() + "' doesn't exist."))));
        }
        try {
            this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (FunctionDefinition)FUNCTION_INVALID, false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("Could not register temporary catalog function '" + IDENTIFIER.asSummaryString() + "' due to implementation errors."))));
        }
    }

    @Test
    public void testUninstantiatedTemporaryCatalogFunction() {
        this.functionCatalog.registerCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, FUNCTION_2.getClass(), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_2));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_1.getClass().getName()), true);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(FULL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)FUNCTION_1));
        try {
            this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_2.getClass().getName()), false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("A function '" + IDENTIFIER.asSummaryString() + "' does already exist."))));
        }
        try {
            this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(FUNCTION_INVALID.getClass().getName()), false);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)("Could not register temporary catalog function '" + IDENTIFIER.asSummaryString() + "' due to implementation errors."))));
        }
        this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true);
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(TABLE_FUNCTION.getClass().getName()), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), TABLE_FUNCTION));
        this.functionCatalog.dropTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, true);
        this.functionCatalog.registerTemporaryCatalogFunction(PARTIAL_UNRESOLVED_IDENTIFIER, (CatalogFunction)new CatalogFunctionImpl(AGGREGATE_FUNCTION.getClass().getName()), false);
        Assert.assertThat((Object)this.functionCatalog.lookupFunction(PARTIAL_UNRESOLVED_IDENTIFIER), FunctionCatalogTest.returnsFunction(FunctionIdentifier.of((ObjectIdentifier)IDENTIFIER), (FunctionDefinition)new AggregateFunctionDefinition(NAME, AGGREGATE_FUNCTION, Types.STRING, Types.STRING)));
    }

    private static Matcher<Optional<FunctionLookup.Result>> returnsFunction(FunctionIdentifier identifier, FunctionDefinition definition) {
        return CoreMatchers.equalTo(Optional.of(new FunctionLookup.Result(identifier, definition)));
    }

    private static Matcher<Optional<FunctionLookup.Result>> returnsNoFunction() {
        return CoreMatchers.equalTo(Optional.empty());
    }

    public static class TestAggregateFunction
    extends AggregateFunction<String, String> {
        public String getValue(String accumulator) {
            return null;
        }

        public String createAccumulator() {
            return null;
        }

        public void accumulate(String in) {
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestTableFunction
    extends TableFunction<String> {
        public void eval(String in) {
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class InvalidTestFunction
    extends ScalarFunction {
    }

    public static class TestFunction4
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestFunction3
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestFunction2
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    public static class TestFunction1
    extends ScalarFunction {
        public String eval() {
            return null;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == ((Object)((Object)this)).getClass();
        }
    }

    private static class TestModule
    implements Module {
        private TestModule() {
        }

        public Set<String> listFunctions() {
            return new HashSet<String>(){
                {
                    this.add(FunctionCatalogTest.NAME);
                }
            };
        }

        public Optional<FunctionDefinition> getFunctionDefinition(String name) {
            return Optional.of(FUNCTION_3);
        }
    }
}

