/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTestBase;
import org.apache.flink.table.catalog.CatalogTestUtil;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.flink.table.functions.TestGenericUDF;
import org.apache.flink.table.functions.TestSimpleUDF;
import org.apache.flink.table.utils.TableEnvironmentMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GenericInMemoryCatalogTest
extends CatalogTestBase {
    @BeforeClass
    public static void init() {
        catalog = new GenericInMemoryCatalog("test-catalog");
        catalog.open();
    }

    @Test
    public void testDropTable_partitionedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        CatalogPartition catalogPartition = this.createPartition();
        CatalogPartitionSpec catalogPartitionSpec = this.createPartitionSpec();
        catalog.createPartition(this.path1, catalogPartitionSpec, catalogPartition, false);
        Assert.assertTrue((boolean)catalog.tableExists(this.path1));
        catalog.dropTable(this.path1, false);
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
        Assert.assertFalse((boolean)catalog.partitionExists(this.path1, catalogPartitionSpec));
    }

    @Test
    public void testRenameTable_partitionedTable() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogPartition catalogPartition = this.createPartition();
        CatalogPartitionSpec catalogPartitionSpec = this.createPartitionSpec();
        catalog.createPartition(this.path1, catalogPartitionSpec, catalogPartition, false);
        CatalogTestUtil.checkEquals((CatalogTable)table, (CatalogTable)((CatalogTable)catalog.getTable(this.path1)));
        Assert.assertTrue((boolean)catalog.partitionExists(this.path1, catalogPartitionSpec));
        catalog.renameTable(this.path1, "t2", false);
        CatalogTestUtil.checkEquals((CatalogTable)table, (CatalogTable)((CatalogTable)catalog.getTable(this.path3)));
        Assert.assertTrue((boolean)catalog.partitionExists(this.path3, catalogPartitionSpec));
        Assert.assertFalse((boolean)catalog.tableExists(this.path1));
        Assert.assertFalse((boolean)catalog.partitionExists(this.path1, catalogPartitionSpec));
    }

    @Test
    public void testStatistics() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable table = this.createTable();
        catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogTestUtil.checkEquals((CatalogTableStatistics)catalog.getTableStatistics(this.path1), (CatalogTableStatistics)CatalogTableStatistics.UNKNOWN);
        CatalogTestUtil.checkEquals((CatalogColumnStatistics)catalog.getTableColumnStatistics(this.path1), (CatalogColumnStatistics)CatalogColumnStatistics.UNKNOWN);
        CatalogTableStatistics tableStatistics = new CatalogTableStatistics(5L, 2, 100L, 575L);
        catalog.alterTableStatistics(this.path1, tableStatistics, false);
        CatalogTestUtil.checkEquals((CatalogTableStatistics)tableStatistics, (CatalogTableStatistics)catalog.getTableStatistics(this.path1));
        CatalogColumnStatistics columnStatistics = this.createColumnStats();
        catalog.alterTableColumnStatistics(this.path1, columnStatistics, false);
        CatalogTestUtil.checkEquals((CatalogColumnStatistics)columnStatistics, (CatalogColumnStatistics)catalog.getTableColumnStatistics(this.path1));
        catalog.createDatabase("db2", this.createDb(), false);
        CatalogTable table2 = this.createPartitionedTable();
        catalog.createTable(this.path2, (CatalogBaseTable)table2, false);
        CatalogPartitionSpec partitionSpec = this.createPartitionSpec();
        catalog.createPartition(this.path2, partitionSpec, this.createPartition(), false);
        CatalogTestUtil.checkEquals((CatalogTableStatistics)catalog.getPartitionStatistics(this.path2, partitionSpec), (CatalogTableStatistics)CatalogTableStatistics.UNKNOWN);
        CatalogTestUtil.checkEquals((CatalogColumnStatistics)catalog.getPartitionColumnStatistics(this.path2, partitionSpec), (CatalogColumnStatistics)CatalogColumnStatistics.UNKNOWN);
        catalog.alterPartitionStatistics(this.path2, partitionSpec, tableStatistics, false);
        CatalogTestUtil.checkEquals((CatalogTableStatistics)tableStatistics, (CatalogTableStatistics)catalog.getPartitionStatistics(this.path2, partitionSpec));
        catalog.alterPartitionColumnStatistics(this.path2, partitionSpec, columnStatistics, false);
        CatalogTestUtil.checkEquals((CatalogColumnStatistics)columnStatistics, (CatalogColumnStatistics)catalog.getPartitionColumnStatistics(this.path2, partitionSpec));
        catalog.dropTable(this.path1, false);
        catalog.dropDatabase("db1", false, false);
        catalog.dropTable(this.path2, false);
        catalog.dropDatabase("db2", false, false);
    }

    @Override
    protected boolean isGeneric() {
        return true;
    }

    private CatalogColumnStatistics createColumnStats() {
        CatalogColumnStatisticsDataBoolean booleanColStats = new CatalogColumnStatisticsDataBoolean(Long.valueOf(55L), Long.valueOf(45L), Long.valueOf(5L));
        CatalogColumnStatisticsDataLong longColStats = new CatalogColumnStatisticsDataLong(Long.valueOf(-123L), Long.valueOf(763322L), Long.valueOf(23L), Long.valueOf(79L));
        CatalogColumnStatisticsDataString stringColStats = new CatalogColumnStatisticsDataString(Long.valueOf(152L), Double.valueOf(43.5), Long.valueOf(20L), Long.valueOf(0L));
        CatalogColumnStatisticsDataDate dateColStats = new CatalogColumnStatisticsDataDate(new Date(71L), new Date(17923L), Long.valueOf(1321L), Long.valueOf(0L));
        CatalogColumnStatisticsDataDouble doubleColStats = new CatalogColumnStatisticsDataDouble(Double.valueOf(-123.35), Double.valueOf(7633.22), Long.valueOf(23L), Long.valueOf(79L));
        CatalogColumnStatisticsDataBinary binaryColStats = new CatalogColumnStatisticsDataBinary(Long.valueOf(755L), Double.valueOf(43.5), Long.valueOf(20L));
        HashMap<String, Object> colStatsMap = new HashMap<String, Object>(6);
        colStatsMap.put("b1", booleanColStats);
        colStatsMap.put("l2", longColStats);
        colStatsMap.put("s3", stringColStats);
        colStatsMap.put("d4", dateColStats);
        colStatsMap.put("dd5", doubleColStats);
        colStatsMap.put("bb6", binaryColStats);
        return new CatalogColumnStatistics(colStatsMap);
    }

    protected CatalogFunction createFunction() {
        return new CatalogFunctionImpl(TestGenericUDF.class.getCanonicalName());
    }

    protected CatalogFunction createAnotherFunction() {
        return new CatalogFunctionImpl(TestSimpleUDF.class.getCanonicalName(), FunctionLanguage.SCALA);
    }

    protected CatalogFunction createPythonFunction() {
        return new CatalogFunctionImpl("test.func1", FunctionLanguage.PYTHON);
    }

    @Test
    public void testRegisterCatalog() {
        TableEnvironmentMock tableEnv = TableEnvironmentMock.getStreamingInstance();
        try {
            tableEnv.registerCatalog("test-catalog", (Catalog)new MyCatalog("test-catalog"));
        }
        catch (CatalogException catalogException) {
            // empty catch block
        }
        Assert.assertThat((Object)tableEnv.getCatalog("test-catalog").isPresent(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    class MyCatalog
    extends GenericInMemoryCatalog {
        public MyCatalog(String name) {
            super(name);
        }

        public void open() {
            throw new CatalogException("open catalog failed.");
        }
    }
}

