/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ObjectToExpressionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testListConversion() {
        Expression expr = ApiExpressionUtils.objectToExpression(Arrays.asList(1, 2));
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.array((Object)1, (Object[])new Object[]{2}));
    }

    @Test
    public void testNestedListConversion() {
        Expression expr = ApiExpressionUtils.objectToExpression(Arrays.asList(Collections.singletonList(1), Collections.singletonList(2)));
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.array((Object)Expressions.array((Object)1, (Object[])new Object[0]), (Object[])new Object[]{Expressions.array((Object)2, (Object[])new Object[0])}));
    }

    @Test
    public void testMapConversion() {
        HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
        map.put("key1", Collections.singletonList(2));
        map.put("key2", Arrays.asList(1, 2));
        Expression expr = ApiExpressionUtils.objectToExpression(map);
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.map((Object)"key1", (Object)Expressions.array((Object)2, (Object[])new Object[0]), (Object[])new Object[]{"key2", Expressions.array((Object)1, (Object[])new Object[]{2})}));
    }

    @Test
    public void testRowConversion() {
        Expression expr = ApiExpressionUtils.objectToExpression((Object)Row.of((Object[])new Object[]{1, "ABC", new int[]{1, 2, 3}, new byte[]{1, 2, 3}, null}));
        ObjectToExpressionTest.assertThatEquals(expr, (Expression)Expressions.row((Object)1, (Object[])new Object[]{"ABC", Expressions.array((Object)1, (Object[])new Object[]{2, 3}), Expressions.lit((Object)new byte[]{1, 2, 3}, (DataType)((DataType)DataTypes.BINARY((int)3).notNull())), Expressions.nullOf((DataType)DataTypes.NULL())}));
    }

    @Test
    public void testRowWithDeleteKindConversion() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Unsupported kind 'DELETE' of a row [1]. Only rows with 'INSERT' kind are supported when converting to an expression.");
        ApiExpressionUtils.objectToExpression((Object)Row.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{1}));
    }

    @Test
    public void testRowWithUpdateBeforeKindConversion() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Unsupported kind 'UPDATE_BEFORE' of a row [1]. Only rows with 'INSERT' kind are supported when converting to an expression.");
        ApiExpressionUtils.objectToExpression((Object)Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1}));
    }

    @Test
    public void testRowWithUpdateAfterKindConversion() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Unsupported kind 'UPDATE_AFTER' of a row [1]. Only rows with 'INSERT' kind are supported when converting to an expression.");
        ApiExpressionUtils.objectToExpression((Object)Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{1}));
    }

    private static void assertThatEquals(Expression actual, Expression expected) {
        Assert.assertThat((Object)ApiExpressionUtils.unwrapFromApi((Expression)actual), (Matcher)CoreMatchers.equalTo((Object)ApiExpressionUtils.unwrapFromApi((Expression)expected)));
    }
}

