/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.CatalogQueryOperation;
import org.apache.flink.table.operations.DistinctQueryOperation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SetQueryOperation;
import org.apache.flink.table.operations.WindowAggregateQueryOperation;
import org.junit.Assert;
import org.junit.Test;

public class QueryOperationTest {
    @Test
    public void testSummaryString() {
        TableSchema schema = TableSchema.builder().field("a", DataTypes.INT()).build();
        ProjectQueryOperation tableOperation = new ProjectQueryOperation(Collections.singletonList(new FieldReferenceExpression("a", DataTypes.INT(), 0, 0)), (QueryOperation)new CatalogQueryOperation(ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tab1"), schema), schema);
        SetQueryOperation unionQueryOperation = new SetQueryOperation((QueryOperation)tableOperation, (QueryOperation)tableOperation, SetQueryOperation.SetQueryOperationType.UNION, true);
        Assert.assertEquals((Object)"Union: (all: [true])\n    Project: (projections: [a])\n        CatalogTable: (identifier: [`cat1`.`db1`.`tab1`], fields: [a])\n    Project: (projections: [a])\n        CatalogTable: (identifier: [`cat1`.`db1`.`tab1`], fields: [a])", (Object)unionQueryOperation.asSummaryString());
    }

    @Test
    public void testWindowAggregationSummaryString() {
        TableSchema schema = TableSchema.builder().field("a", DataTypes.INT()).build();
        FieldReferenceExpression field = new FieldReferenceExpression("a", DataTypes.INT(), 0, 0);
        WindowAggregateQueryOperation tableOperation = new WindowAggregateQueryOperation(Collections.singletonList(field), Collections.singletonList(new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.SUM, Collections.singletonList(field), DataTypes.INT())), Collections.emptyList(), WindowAggregateQueryOperation.ResolvedGroupWindow.sessionWindow((String)"w", (FieldReferenceExpression)field, (ValueLiteralExpression)ApiExpressionUtils.intervalOfMillis((long)10L)), (QueryOperation)new CatalogQueryOperation(ObjectIdentifier.of((String)"cat1", (String)"db1", (String)"tab1"), schema), schema);
        DistinctQueryOperation distinctQueryOperation = new DistinctQueryOperation((QueryOperation)tableOperation);
        Assert.assertEquals((Object)"Distinct:\n    WindowAggregate: (group: [a], agg: [sum(a)], windowProperties: [], window: [SessionWindow(field: [a], gap: [10])])\n        CatalogTable: (identifier: [`cat1`.`db1`.`tab1`], fields: [a])", (Object)distinctQueryOperation.asSummaryString());
    }

    @Test
    public void testIndentation() {
        String input = "firstLevel\n    secondLevel0\n        thirdLevel0\n    secondLevel1\n        thirdLevel1";
        String indentedInput = OperationUtils.indent((String)input);
        Assert.assertEquals((Object)"\n    firstLevel\n        secondLevel0\n            thirdLevel0\n        secondLevel1\n            thirdLevel1", (Object)indentedInput);
    }
}

