/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExecutorMock;
import org.apache.flink.table.utils.PlannerMock;

public class TableEnvironmentMock
extends TableEnvironmentImpl {
    public final CatalogManager catalogManager;
    public final ExecutorMock executor;
    public final FunctionCatalog functionCatalog;
    public final PlannerMock planner;

    protected TableEnvironmentMock(CatalogManager catalogManager, ModuleManager moduleManager, TableConfig tableConfig, ExecutorMock executor, FunctionCatalog functionCatalog, PlannerMock planner, boolean isStreamingMode) {
        super(catalogManager, moduleManager, tableConfig, (Executor)executor, functionCatalog, (Planner)planner, isStreamingMode, TableEnvironmentMock.class.getClassLoader());
        this.catalogManager = catalogManager;
        this.executor = executor;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
    }

    public static TableEnvironmentMock getStreamingInstance() {
        return TableEnvironmentMock.getInstance(true);
    }

    public static TableEnvironmentMock getBatchInstance() {
        return TableEnvironmentMock.getInstance(false);
    }

    private static TableEnvironmentMock getInstance(boolean isStreamingMode) {
        TableConfig config = TableEnvironmentMock.createTableConfig();
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        ModuleManager moduleManager = new ModuleManager();
        return new TableEnvironmentMock(catalogManager, moduleManager, config, TableEnvironmentMock.createExecutor(), TableEnvironmentMock.createFunctionCatalog(config, catalogManager, moduleManager), TableEnvironmentMock.createPlanner(), isStreamingMode);
    }

    private static TableConfig createTableConfig() {
        return TableConfig.getDefault();
    }

    private static ExecutorMock createExecutor() {
        return new ExecutorMock();
    }

    private static FunctionCatalog createFunctionCatalog(TableConfig config, CatalogManager catalogManager, ModuleManager moduleManager) {
        return new FunctionCatalog(config, catalogManager, moduleManager);
    }

    private static PlannerMock createPlanner() {
        return new PlannerMock();
    }
}

