/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.factories.TestManagedTableFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.utils.TableEnvironmentMock;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class TableEnvironmentTest {
    TableEnvironmentTest() {
    }

    @Test
    void testCreateTemporaryTableFromDescriptor() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build();
        tEnv.createTemporaryTable("T", TableDescriptor.forConnector((String)"fake").schema(schema).option("a", "Test").build());
        Assertions.assertThat((boolean)((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(new ObjectPath(database, "T"))).isFalse();
        Optional lookupResult = tEnv.getCatalogManager().getTable(ObjectIdentifier.of((String)catalog, (String)database, (String)"T"));
        Assertions.assertThat((boolean)lookupResult.isPresent()).isTrue();
        CatalogBaseTable catalogTable = ((ContextResolvedTable)lookupResult.get()).getTable();
        Assertions.assertThat((boolean)(catalogTable instanceof CatalogTable)).isTrue();
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("connector"))).isEqualTo("fake");
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("a"))).isEqualTo("Test");
    }

    @Test
    void testCreateTableFromDescriptor() throws Exception {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build();
        tEnv.createTable("T", TableDescriptor.forConnector((String)"fake").schema(schema).option("a", "Test").build());
        ObjectPath objectPath = new ObjectPath(database, "T");
        Assertions.assertThat((boolean)((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(objectPath)).isTrue();
        CatalogBaseTable catalogTable = ((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).getTable(objectPath);
        Assertions.assertThat((Object)catalogTable).isInstanceOf(CatalogTable.class);
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((Map)catalogTable.getOptions()).contains(new Map.Entry[]{Assertions.entry((Object)"connector", (Object)"fake"), Assertions.entry((Object)"a", (Object)"Test")});
    }

    @Test
    void testTableFromDescriptor() {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build();
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"fake").schema(schema).build();
        Table table = tEnv.from(descriptor);
        Assertions.assertThat((Object)Schema.newBuilder().fromResolvedSchema(table.getResolvedSchema()).build()).isEqualTo((Object)schema);
        ((ObjectAssert)Assertions.assertThat((Object)table.getQueryOperation()).asInstanceOf(InstanceOfAssertFactories.type(SourceQueryOperation.class))).extracting(SourceQueryOperation::getContextResolvedTable).satisfies(new ThrowingConsumer[]{crs -> {
            Assertions.assertThat((boolean)crs.isAnonymous()).isTrue();
            Assertions.assertThat((List)crs.getIdentifier().toList()).hasSize(1);
            Assertions.assertThat((Map)crs.getTable().getOptions()).containsEntry((Object)"connector", (Object)"fake");
        }});
        Assertions.assertThat((Collection)tEnv.getCatalogManager().listTables()).isEmpty();
    }

    @Test
    void testManagedTable() {
        this.innerTestManagedTableFromDescriptor(false, false);
    }

    @Test
    void testManagedTableWithIgnoreExists() {
        this.innerTestManagedTableFromDescriptor(true, false);
    }

    @Test
    void testTemporaryManagedTableWithIgnoreExists() {
        this.innerTestManagedTableFromDescriptor(true, true);
    }

    @Test
    void testTemporaryManagedTable() {
        this.innerTestManagedTableFromDescriptor(true, true);
    }

    private void innerTestManagedTableFromDescriptor(boolean ignoreIfExists, boolean isTemporary) {
        TableEnvironmentMock tEnv = TableEnvironmentMock.getStreamingInstance();
        String catalog = tEnv.getCurrentCatalog();
        String database = tEnv.getCurrentDatabase();
        Schema schema = Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build();
        String tableName = UUID.randomUUID().toString();
        ObjectIdentifier identifier = ObjectIdentifier.of((String)catalog, (String)database, (String)tableName);
        TestManagedTableFactory.MANAGED_TABLES.put(identifier, new AtomicReference());
        CreateTableOperation createOperation = new CreateTableOperation(identifier, TableDescriptor.forManaged().schema(schema).option("a", "Test").build().toCatalogTable(), ignoreIfExists, isTemporary);
        tEnv.executeInternal((Operation)createOperation);
        if (ignoreIfExists) {
            tEnv.executeInternal((Operation)createOperation);
        } else {
            Assertions.assertThatThrownBy(() -> tEnv.executeInternal((Operation)createOperation), (String)(isTemporary ? "already exists" : "Could not execute CreateTable"), (Object[])new Object[0]);
        }
        boolean isInCatalog = ((Catalog)tEnv.getCatalog(catalog).orElseThrow(AssertionError::new)).tableExists(new ObjectPath(database, tableName));
        if (isTemporary) {
            Assertions.assertThat((boolean)isInCatalog).isFalse();
        } else {
            Assertions.assertThat((boolean)isInCatalog).isTrue();
        }
        Optional lookupResult = tEnv.getCatalogManager().getTable(identifier);
        Assertions.assertThat((boolean)lookupResult.isPresent()).isTrue();
        CatalogBaseTable catalogTable = ((ContextResolvedTable)lookupResult.get()).getTable();
        Assertions.assertThat((boolean)(catalogTable instanceof CatalogTable)).isTrue();
        Assertions.assertThat((Object)catalogTable.getUnresolvedSchema()).isEqualTo((Object)schema);
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("a"))).isEqualTo("Test");
        Assertions.assertThat((String)((String)catalogTable.getOptions().get("ENRICHED_KEY"))).isEqualTo("ENRICHED_VALUE");
        AtomicReference reference = (AtomicReference)TestManagedTableFactory.MANAGED_TABLES.get(identifier);
        Assertions.assertThat((Map)((Map)reference.get())).isNotNull();
        Assertions.assertThat((String)((String)((Map)reference.get()).get("a"))).isEqualTo("Test");
        Assertions.assertThat((String)((String)((Map)reference.get()).get("ENRICHED_KEY"))).isEqualTo("ENRICHED_VALUE");
        DropTableOperation dropOperation = new DropTableOperation(identifier, ignoreIfExists, isTemporary);
        tEnv.executeInternal((Operation)dropOperation);
        Assertions.assertThat((Map)((Map)((AtomicReference)TestManagedTableFactory.MANAGED_TABLES.get(identifier)).get())).isNull();
        if (ignoreIfExists) {
            tEnv.executeInternal((Operation)dropOperation);
        } else {
            Assertions.assertThatThrownBy(() -> tEnv.executeInternal((Operation)dropOperation), (String)"does not exist", (Object[])new Object[0]);
        }
        TestManagedTableFactory.MANAGED_TABLES.remove(identifier);
    }
}

