/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.resource;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.UserClassLoaderJarTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ResourceManagerTest {
    @TempDir
    private static File tempFolder;
    private static File udfJar;
    private ResourceManager resourceManager;

    @BeforeAll
    public static void prepare() throws Exception {
        udfJar = UserClassLoaderJarTestUtils.createJarFile((File)tempFolder, (String)"test-classloader-udf.jar", (String)"LowerUDF", (String)String.format("public class %s extends org.apache.flink.table.functions.ScalarFunction {\n  public String eval(String str) {\n    return str.toLowerCase();\n  }\n}\n", "LowerUDF"));
    }

    @BeforeEach
    public void before() {
        this.resourceManager = ResourceManager.createResourceManager((URL[])new URL[0], (ClassLoader)this.getClass().getClassLoader(), (ReadableConfig)new Configuration());
    }

    @AfterEach
    public void after() throws Exception {
        this.resourceManager.close();
    }

    @Test
    public void testRegisterResource() throws Exception {
        URLClassLoader userClassLoader = this.resourceManager.getUserClassLoader();
        CommonTestUtils.assertThrows((String)"LowerUDF", ClassNotFoundException.class, () -> Class.forName("LowerUDF", false, userClassLoader));
        ResourceUri resourceUri = new ResourceUri(ResourceType.JAR, udfJar.getPath());
        this.resourceManager.registerJarResources(Arrays.asList(resourceUri, resourceUri));
        Map<ResourceUri, URL> expected = Collections.singletonMap(resourceUri, this.resourceManager.getURLFromPath(new Path(udfJar.getPath())));
        Assertions.assertEquals(expected, (Object)this.resourceManager.getResources());
        Class<?> clazz1 = Class.forName("LowerUDF", false, userClassLoader);
        Class<?> clazz2 = Class.forName("LowerUDF", false, userClassLoader);
        Assertions.assertEquals(clazz1, clazz2);
    }

    @Test
    public void testRegisterResourceWithRelativePath() throws Exception {
        URLClassLoader userClassLoader = this.resourceManager.getUserClassLoader();
        CommonTestUtils.assertThrows((String)"LowerUDF", ClassNotFoundException.class, () -> Class.forName("LowerUDF", false, userClassLoader));
        ResourceUri resourceUri = new ResourceUri(ResourceType.JAR, new File(".").getCanonicalFile().toPath().relativize(udfJar.toPath()).toString());
        this.resourceManager.registerJarResources(Collections.singletonList(resourceUri));
        Map<ResourceUri, URL> expected = Collections.singletonMap(new ResourceUri(ResourceType.JAR, udfJar.getPath()), this.resourceManager.getURLFromPath(new Path(udfJar.getPath())));
        Assertions.assertEquals(expected, (Object)this.resourceManager.getResources());
        Class<?> clazz1 = Class.forName("LowerUDF", false, userClassLoader);
        Class<?> clazz2 = Class.forName("LowerUDF", false, userClassLoader);
        Assertions.assertEquals(clazz1, clazz2);
    }

    @Test
    public void testRegisterInvalidResource() throws Exception {
        String fileUri = tempFolder.getAbsolutePath() + "/" + "test-file";
        CommonTestUtils.assertThrows((String)String.format("Only support to register jar resource, resource info:\n %s.", fileUri), ValidationException.class, () -> {
            this.resourceManager.registerJarResources(Collections.singletonList(new ResourceUri(ResourceType.FILE, fileUri)));
            return null;
        });
        String jarDir = tempFolder.getPath();
        CommonTestUtils.assertThrows((String)String.format("The registering or unregistering jar resource [%s] must ends with '.jar' suffix.", jarDir), ValidationException.class, () -> {
            this.resourceManager.registerJarResources(Collections.singletonList(new ResourceUri(ResourceType.JAR, jarDir)));
            return null;
        });
        String jarPath = Files.createDirectory(Paths.get(tempFolder.getPath(), "test-jar.jar"), new FileAttribute[0]).toString();
        CommonTestUtils.assertThrows((String)String.format("The registering or unregistering jar resource [%s] is a directory that is not allowed.", jarPath), ValidationException.class, () -> {
            this.resourceManager.registerJarResources(Collections.singletonList(new ResourceUri(ResourceType.JAR, jarPath)));
            return null;
        });
    }

    @Test
    public void testDownloadResource() throws Exception {
        Path srcPath = new Path(udfJar.getPath());
        URL localUrl = this.resourceManager.downloadResource(srcPath);
        byte[] expected = FileUtils.readAllBytes((java.nio.file.Path)udfJar.toPath());
        byte[] actual = FileUtils.readAllBytes((java.nio.file.Path)Paths.get(localUrl.toURI()));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testCloseResourceManagerCleanDownloadedResources() throws Exception {
        this.resourceManager.close();
        FileSystem fileSystem = FileSystem.getLocalFileSystem();
        Assertions.assertFalse((boolean)fileSystem.exists(this.resourceManager.getLocalResourceDir()));
    }
}

