/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.net.URL;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.apache.flink.table.utils.ExecutorMock;
import org.apache.flink.table.utils.PlannerMock;

public class TableEnvironmentMock
extends TableEnvironmentImpl {
    public final CatalogManager catalogManager;
    public final ExecutorMock executor;
    public final FunctionCatalog functionCatalog;
    public final PlannerMock planner;

    protected TableEnvironmentMock(CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager userResourceManager, TableConfig tableConfig, ExecutorMock executor, FunctionCatalog functionCatalog, PlannerMock planner, boolean isStreamingMode) {
        super(catalogManager, moduleManager, userResourceManager, tableConfig, (Executor)executor, functionCatalog, (Planner)planner, isStreamingMode);
        this.catalogManager = catalogManager;
        this.executor = executor;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
    }

    public static TableEnvironmentMock getStreamingInstance() {
        return TableEnvironmentMock.getInstance(true);
    }

    public static TableEnvironmentMock getBatchInstance() {
        return TableEnvironmentMock.getInstance(false);
    }

    private static TableEnvironmentMock getInstance(boolean isStreamingMode) {
        TableConfig tableConfig = TableConfig.getDefault();
        CatalogManager catalogManager = CatalogManagerMocks.createEmptyCatalogManager();
        ModuleManager moduleManager = new ModuleManager();
        ResourceManager resourceManager = ResourceManager.createResourceManager((URL[])new URL[0], (ClassLoader)Thread.currentThread().getContextClassLoader(), (ReadableConfig)tableConfig.getConfiguration());
        return new TableEnvironmentMock(catalogManager, moduleManager, resourceManager, tableConfig, TableEnvironmentMock.createExecutor(), TableEnvironmentMock.createFunctionCatalog((ReadableConfig)tableConfig, resourceManager, catalogManager, moduleManager), TableEnvironmentMock.createPlanner(), isStreamingMode);
    }

    private static ExecutorMock createExecutor() {
        return new ExecutorMock();
    }

    private static FunctionCatalog createFunctionCatalog(ReadableConfig config, ResourceManager resourceManager, CatalogManager catalogManager, ModuleManager moduleManager) {
        return new FunctionCatalog(config, resourceManager, catalogManager, moduleManager);
    }

    private static PlannerMock createPlanner() {
        return new PlannerMock();
    }
}

