/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TableSchemaTest {
    private static final String WATERMARK_EXPRESSION = "now()";
    private static final DataType WATERMARK_DATATYPE = DataTypes.TIMESTAMP((int)3);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTableSchema() {
        TableSchema schema = TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3))})).field("f2", DataTypes.STRING()).field("f3", DataTypes.BIGINT(), "f0 + 1").watermark("f1.q2", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
        String expected = "root\n |-- f0: BIGINT\n |-- f1: ROW<`q1` STRING, `q2` TIMESTAMP(3)>\n |-- f2: STRING\n |-- f3: BIGINT AS f0 + 1\n |-- WATERMARK FOR f1.q2 AS now()";
        Assert.assertEquals((Object)expected, (Object)schema.toString());
        Assert.assertEquals(Optional.of("f2"), (Object)schema.getFieldName(2));
        Assert.assertEquals(Optional.of(DataTypes.BIGINT()), (Object)schema.getFieldDataType(3));
        Assert.assertEquals(Optional.of(TableColumn.of((String)"f3", (DataType)DataTypes.BIGINT(), (String)"f0 + 1")), (Object)schema.getTableColumn(3));
        Assert.assertEquals(Optional.of(DataTypes.STRING()), (Object)schema.getFieldDataType("f2"));
        Assert.assertEquals(Optional.of(DataTypes.STRING()), schema.getFieldDataType("f1").map(r -> (DataType)((FieldsDataType)r).getFieldDataTypes().get("q1")));
        Assert.assertFalse((boolean)schema.getFieldName(4).isPresent());
        Assert.assertFalse((boolean)schema.getFieldType(-1).isPresent());
        Assert.assertFalse((boolean)schema.getFieldType("c").isPresent());
        Assert.assertFalse((boolean)schema.getFieldDataType("f1.q1").isPresent());
        Assert.assertFalse((boolean)schema.getFieldDataType("f1.q3").isPresent());
        Assert.assertEquals((Object)schema, (Object)schema.copy());
        Assert.assertEquals((long)schema.hashCode(), (long)schema.copy().hashCode());
    }

    @Test
    public void testWatermarkOnDifferentFields() {
        ArrayList<Tuple3> testData = new ArrayList<Tuple3>();
        testData.add(Tuple3.of((Object)"a", (Object)DataTypes.BIGINT(), (Object)"but is of type 'BIGINT'"));
        testData.add(Tuple3.of((Object)"b", (Object)DataTypes.STRING(), (Object)"but is of type 'STRING'"));
        testData.add(Tuple3.of((Object)"c", (Object)DataTypes.INT(), (Object)"but is of type 'INT'"));
        testData.add(Tuple3.of((Object)"d", (Object)DataTypes.TIMESTAMP(), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"e", (Object)DataTypes.TIMESTAMP((int)0), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"f", (Object)DataTypes.TIMESTAMP((int)3), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"g", (Object)DataTypes.TIMESTAMP((int)9), (Object)"PASS"));
        testData.add(Tuple3.of((Object)"h", (Object)DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)3), (Object)"but is of type 'TIMESTAMP(3) WITH TIME ZONE'"));
        testData.forEach(t -> {
            TableSchema.Builder builder = TableSchema.builder();
            testData.forEach(e -> builder.field((String)e.f0, (DataType)e.f1));
            builder.watermark((String)t.f0, WATERMARK_EXPRESSION, WATERMARK_DATATYPE);
            if (((String)t.f2).equals("PASS")) {
                TableSchema schema = builder.build();
                Assert.assertEquals((long)1L, (long)schema.getWatermarkSpecs().size());
                Assert.assertEquals((Object)t.f0, (Object)((WatermarkSpec)schema.getWatermarkSpecs().get(0)).getRowtimeAttribute());
            } else {
                try {
                    builder.build();
                }
                catch (Exception e2) {
                    Assert.assertTrue((boolean)e2.getMessage().contains((CharSequence)t.f2));
                }
            }
        });
    }

    @Test
    public void testWatermarkOnNestedField() {
        TableSchema schema = TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"q3", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"t1", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"t2", (DataType)DataTypes.STRING())}))})).watermark("f1.q3.t1", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
        Assert.assertEquals((long)1L, (long)schema.getWatermarkSpecs().size());
        Assert.assertEquals((Object)"f1.q3.t1", (Object)((WatermarkSpec)schema.getWatermarkSpecs().get(0)).getRowtimeAttribute());
    }

    @Test
    public void testWatermarkOnNonExistedField() {
        this.thrown.expectMessage("Rowtime attribute 'f1.q0' is not defined in schema");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3))})).watermark("f1.q0", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
    }

    @Test
    public void testMultipleWatermarks() {
        this.thrown.expectMessage("Multiple watermark definition is not supported yet.");
        TableSchema.builder().field("f0", DataTypes.TIMESTAMP()).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"q1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"q2", (DataType)DataTypes.TIMESTAMP((int)3))})).watermark("f1.q2", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).watermark("f0", WATERMARK_EXPRESSION, WATERMARK_DATATYPE).build();
    }

    @Test
    public void testDifferentWatermarkStrategyOutputTypes() {
        ArrayList<Tuple2> testData = new ArrayList<Tuple2>();
        testData.add(Tuple2.of((Object)DataTypes.BIGINT(), (Object)"but is of type 'BIGINT'"));
        testData.add(Tuple2.of((Object)DataTypes.STRING(), (Object)"but is of type 'VARCHAR(2147483647)'"));
        testData.add(Tuple2.of((Object)DataTypes.INT(), (Object)"but is of type 'INT'"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP(), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP((int)0), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP((int)3), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP((int)9), (Object)"PASS"));
        testData.add(Tuple2.of((Object)DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)3), (Object)"but is of type 'TIMESTAMP(3) WITH TIME ZONE'"));
        testData.forEach(t -> {
            TableSchema.Builder builder = TableSchema.builder().field("f0", DataTypes.TIMESTAMP()).watermark("f0", "f0 - INTERVAL '5' SECOND", (DataType)t.f0);
            if (((String)t.f1).equals("PASS")) {
                TableSchema schema = builder.build();
                Assert.assertEquals((long)1L, (long)schema.getWatermarkSpecs().size());
            } else {
                try {
                    builder.build();
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)e.getMessage().contains((CharSequence)t.f1));
                }
            }
        });
    }

    @Test
    public void testPrimaryKeyPrinting() {
        TableSchema schema = TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).field("f1", (DataType)DataTypes.STRING().notNull()).field("f2", (DataType)DataTypes.DOUBLE().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).build();
        Assert.assertThat((Object)schema.toString(), (Matcher)CoreMatchers.equalTo((Object)"root\n |-- f0: BIGINT NOT NULL\n |-- f1: STRING NOT NULL\n |-- f2: DOUBLE NOT NULL\n |-- CONSTRAINT pk PRIMARY KEY (f0, f2)"));
    }

    @Test
    public void testPrimaryKeyColumnsIndices() {
        TableSchema schema = TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).field("f1", (DataType)DataTypes.STRING().notNull()).field("f2", (DataType)DataTypes.DOUBLE().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).build();
        UniqueConstraint expectedKey = UniqueConstraint.primaryKey((String)"pk", Arrays.asList("f0", "f2"));
        Assert.assertThat(schema.getPrimaryKey().get(), (Matcher)CoreMatchers.equalTo((Object)expectedKey));
    }

    @Test
    public void testPrimaryKeyLazilyDefinedColumns() {
        TableSchema schema = TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).field("f1", (DataType)DataTypes.STRING().notNull()).field("f2", (DataType)DataTypes.DOUBLE().notNull()).build();
        UniqueConstraint expectedKey = UniqueConstraint.primaryKey((String)"pk", Arrays.asList("f0", "f2"));
        Assert.assertThat(schema.getPrimaryKey().get(), (Matcher)CoreMatchers.equalTo((Object)expectedKey));
    }

    @Test
    public void testPrimaryKeyNoColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'pk'. Column 'f2' does not exist.");
        TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull()).primaryKey("pk", new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNullableColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'pk'. Column 'f0' is nullable.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey("pk", new String[]{"f0"}).build();
    }

    @Test
    public void testPrimaryKeyGeneratedColumn() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Could not create a PRIMARY KEY 'pk' with a generated column 'f0'.");
        TableSchema.builder().field("f0", (DataType)DataTypes.BIGINT().notNull(), "123").primaryKey("pk", new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNameMustNotBeNull() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("PRIMARY KEY's name can not be null or empty.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey(null, new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNameMustNotBeEmpty() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("PRIMARY KEY's name can not be null or empty.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey("", new String[]{"f0", "f2"}).build();
    }

    @Test
    public void testPrimaryKeyNoColumns() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("PRIMARY KEY constraint must be defined for at least a single column.");
        TableSchema.builder().field("f0", DataTypes.BIGINT()).primaryKey("pk", new String[0]).build();
    }
}

