/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.flink.table.plan.stats.TableStats;
import org.junit.Assert;

public class CatalogTestUtil {
    public static void checkEquals(CatalogTable t1, CatalogTable t2) {
        Assert.assertEquals(t1.getClass(), t2.getClass());
        Assert.assertEquals((Object)t1.getSchema(), (Object)t2.getSchema());
        Assert.assertEquals((Object)t1.getComment(), (Object)t2.getComment());
        Assert.assertEquals((Object)t1.getPartitionKeys(), (Object)t2.getPartitionKeys());
        Assert.assertEquals((Object)t1.isPartitioned(), (Object)t2.isPartitioned());
        Assert.assertEquals(t1.getProperties().get("is_generic"), t2.getProperties().get("is_generic"));
        if (Boolean.valueOf((String)t1.getProperties().get("is_generic")).booleanValue()) {
            Assert.assertEquals((Object)t1.getProperties(), (Object)t2.getProperties());
        } else {
            Assert.assertTrue((boolean)t2.getProperties().keySet().stream().noneMatch(k -> k.startsWith("flink.")));
            Assert.assertTrue((boolean)t2.getProperties().entrySet().containsAll(t1.getProperties().entrySet()));
        }
    }

    public static void checkEquals(CatalogView v1, CatalogView v2) {
        Assert.assertEquals(v1.getClass(), v2.getClass());
        Assert.assertEquals((Object)v1.getSchema(), (Object)v1.getSchema());
        Assert.assertEquals((Object)v1.getComment(), (Object)v2.getComment());
        Assert.assertEquals((Object)v1.getOriginalQuery(), (Object)v2.getOriginalQuery());
        Assert.assertEquals((Object)v1.getExpandedQuery(), (Object)v2.getExpandedQuery());
        if (Boolean.valueOf((String)v1.getProperties().get("is_generic")).booleanValue()) {
            Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
        } else {
            Assert.assertTrue((boolean)v2.getProperties().keySet().stream().noneMatch(k -> k.startsWith("flink.")));
            Assert.assertTrue((boolean)v2.getProperties().entrySet().containsAll(v1.getProperties().entrySet()));
        }
    }

    public static void checkEquals(CatalogPartition p1, CatalogPartition p2) {
        Assert.assertEquals(p1.getClass(), p2.getClass());
        Assert.assertEquals((Object)p1.getComment(), (Object)p2.getComment());
        if (Boolean.valueOf((String)p1.getProperties().get("is_generic")).booleanValue()) {
            Assert.assertEquals((Object)p1.getProperties(), (Object)p2.getProperties());
        } else {
            Assert.assertTrue((boolean)p2.getProperties().entrySet().containsAll(p1.getProperties().entrySet()));
        }
    }

    public static void checkEquals(TableStats ts1, TableStats ts2) {
        Assert.assertEquals((long)ts1.getRowCount(), (long)ts2.getRowCount());
        Assert.assertEquals((long)ts1.getColumnStats().size(), (long)ts2.getColumnStats().size());
    }

    public static void checkEquals(CatalogDatabase d1, CatalogDatabase d2) {
        Assert.assertEquals(d1.getClass(), d2.getClass());
        Assert.assertEquals((Object)d1.getComment(), (Object)d2.getComment());
        Assert.assertTrue((boolean)d2.getProperties().entrySet().containsAll(d1.getProperties().entrySet()));
    }

    static void checkEquals(CatalogTableStatistics ts1, CatalogTableStatistics ts2) {
        Assert.assertEquals((long)ts1.getRowCount(), (long)ts2.getRowCount());
        Assert.assertEquals((long)ts1.getFileCount(), (long)ts2.getFileCount());
        Assert.assertEquals((long)ts1.getTotalSize(), (long)ts2.getTotalSize());
        Assert.assertEquals((long)ts1.getRawDataSize(), (long)ts2.getRawDataSize());
        Assert.assertEquals((Object)ts1.getProperties(), (Object)ts2.getProperties());
    }

    static void checkEquals(CatalogColumnStatistics cs1, CatalogColumnStatistics cs2) {
        CatalogTestUtil.checkEquals(cs1.getColumnStatisticsData(), cs2.getColumnStatisticsData());
        Assert.assertEquals((Object)cs1.getProperties(), (Object)cs2.getProperties());
    }

    private static void checkEquals(Map<String, CatalogColumnStatisticsDataBase> m1, Map<String, CatalogColumnStatisticsDataBase> m2) {
        Assert.assertEquals((long)m1.size(), (long)m2.size());
        for (Map.Entry<String, CatalogColumnStatisticsDataBase> entry : m2.entrySet()) {
            Assert.assertTrue((boolean)m1.containsKey(entry.getKey()));
            CatalogTestUtil.checkEquals(m2.get(entry.getKey()), entry.getValue());
        }
    }

    private static void checkEquals(CatalogColumnStatisticsDataBase v1, CatalogColumnStatisticsDataBase v2) {
        Assert.assertEquals(v1.getClass(), v2.getClass());
        if (v1 instanceof CatalogColumnStatisticsDataBoolean) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataBoolean)v1, (CatalogColumnStatisticsDataBoolean)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataLong) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataLong)v1, (CatalogColumnStatisticsDataLong)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataBinary) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataBinary)v1, (CatalogColumnStatisticsDataBinary)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataDate) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataDate)v1, (CatalogColumnStatisticsDataDate)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataString) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataString)v1, (CatalogColumnStatisticsDataString)v2);
        } else if (v1 instanceof CatalogColumnStatisticsDataDouble) {
            CatalogTestUtil.checkEquals((CatalogColumnStatisticsDataDouble)v1, (CatalogColumnStatisticsDataDouble)v2);
        }
    }

    private static void checkEquals(CatalogColumnStatisticsDataBoolean v1, CatalogColumnStatisticsDataBoolean v2) {
        Assert.assertEquals((Object)v1.getFalseCount(), (Object)v2.getFalseCount());
        Assert.assertEquals((Object)v1.getTrueCount(), (Object)v2.getTrueCount());
        Assert.assertEquals((Object)v1.getNullCount(), (Object)v2.getNullCount());
        Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataLong v1, CatalogColumnStatisticsDataLong v2) {
        Assert.assertEquals((Object)v1.getMin(), (Object)v2.getMin());
        Assert.assertEquals((Object)v1.getMax(), (Object)v2.getMax());
        Assert.assertEquals((Object)v1.getNdv(), (Object)v2.getNdv());
        Assert.assertEquals((Object)v1.getNullCount(), (Object)v2.getNullCount());
        Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataDouble v1, CatalogColumnStatisticsDataDouble v2) {
        Assert.assertEquals((double)v1.getMin(), (double)v2.getMin(), (double)0.05);
        Assert.assertEquals((double)v1.getMax(), (double)v2.getMax(), (double)0.05);
        Assert.assertEquals((Object)v1.getNdv(), (Object)v2.getNdv());
        Assert.assertEquals((Object)v1.getNullCount(), (Object)v2.getNullCount());
        Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataString v1, CatalogColumnStatisticsDataString v2) {
        Assert.assertEquals((Object)v1.getMaxLength(), (Object)v2.getMaxLength());
        Assert.assertEquals((double)v1.getAvgLength(), (double)v2.getAvgLength(), (double)0.05);
        Assert.assertEquals((Object)v1.getNdv(), (Object)v2.getNdv());
        Assert.assertEquals((Object)v1.getNullCount(), (Object)v2.getNullCount());
        Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataBinary v1, CatalogColumnStatisticsDataBinary v2) {
        Assert.assertEquals((Object)v1.getMaxLength(), (Object)v2.getMaxLength());
        Assert.assertEquals((double)v1.getAvgLength(), (double)v2.getAvgLength(), (double)0.05);
        Assert.assertEquals((Object)v1.getNullCount(), (Object)v2.getNullCount());
        Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
    }

    private static void checkEquals(CatalogColumnStatisticsDataDate v1, CatalogColumnStatisticsDataDate v2) {
        CatalogTestUtil.checkEquals(v1.getMin(), v2.getMin());
        CatalogTestUtil.checkEquals(v1.getMax(), v2.getMax());
        Assert.assertEquals((Object)v1.getNdv(), (Object)v2.getNdv());
        Assert.assertEquals((Object)v1.getNullCount(), (Object)v2.getNullCount());
        Assert.assertEquals((Object)v1.getProperties(), (Object)v2.getProperties());
    }

    private static void checkEquals(Date v1, Date v2) {
        Assert.assertEquals((long)v1.getDaysSinceEpoch(), (long)v2.getDaysSinceEpoch());
    }
}

