/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.util.Collector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UserDefinedFunctionHelperTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.forClass(ValidScalarFunction.class).expectSuccess(), TestSpec.forInstance((UserDefinedFunction)new ValidScalarFunction()).expectSuccess(), TestSpec.forClass(PrivateScalarFunction.class).expectErrorMessage("Function class '" + PrivateScalarFunction.class.getName() + "' is not public."), TestSpec.forClass(MissingImplementationScalarFunction.class).expectErrorMessage("Function class '" + MissingImplementationScalarFunction.class.getName() + "' does not implement a method named 'eval'."), TestSpec.forClass(PrivateMethodScalarFunction.class).expectErrorMessage("Method 'eval' of function class '" + PrivateMethodScalarFunction.class.getName() + "' is not public."), TestSpec.forInstance((UserDefinedFunction)new ValidTableAggregateFunction()).expectSuccess(), TestSpec.forInstance((UserDefinedFunction)new MissingEmitTableAggregateFunction()).expectErrorMessage("Function class '" + MissingEmitTableAggregateFunction.class.getName() + "' does not implement a method named 'emitUpdateWithRetract' or 'emitValue'."), TestSpec.forInstance((UserDefinedFunction)new ValidTableFunction()).expectSuccess(), TestSpec.forInstance((UserDefinedFunction)new ParameterizedTableFunction(12)).expectSuccess(), TestSpec.forClass(ParameterizedTableFunction.class).expectErrorMessage("Function class '" + ParameterizedTableFunction.class.getName() + "' must have a public default constructor."), TestSpec.forClass(HierarchicalTableAggregateFunction.class).expectSuccess());
    }

    @Test
    public void testInstantiation() {
        if (this.testSpec.functionClass != null) {
            if (this.testSpec.expectedErrorMessage != null) {
                this.thrown.expect(ValidationException.class);
                this.thrown.expectMessage(this.testSpec.expectedErrorMessage);
            }
            Assert.assertThat((Object)UserDefinedFunctionHelper.instantiateFunction(this.testSpec.functionClass), (Matcher)CoreMatchers.notNullValue());
        }
    }

    @Test
    public void testValidation() {
        if (this.testSpec.expectedErrorMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectMessage(this.testSpec.expectedErrorMessage);
        }
        if (this.testSpec.functionClass != null) {
            UserDefinedFunctionHelper.validateClass(this.testSpec.functionClass);
        } else if (this.testSpec.functionInstance != null) {
            UserDefinedFunctionHelper.prepareInstance((ReadableConfig)new Configuration(), (UserDefinedFunction)this.testSpec.functionInstance);
        }
    }

    public static class HierarchicalTableAggregateFunction
    extends AbstractTableAggregateFunction {
        public void emitValue(String acc, Collector<String> out) {
        }

        public String createAccumulator() {
            return null;
        }
    }

    private static abstract class AbstractTableAggregateFunction
    extends TableAggregateFunction<String, String> {
        private AbstractTableAggregateFunction() {
        }

        public void accumulate(String acc, String in) {
        }
    }

    public static class ParameterizedTableFunction
    extends TableFunction<String> {
        public ParameterizedTableFunction(int param) {
        }

        public void eval(String i) {
        }
    }

    public static class ValidTableFunction
    extends TableFunction<String> {
        public void eval(String i) {
        }
    }

    public static class MissingEmitTableAggregateFunction
    extends TableAggregateFunction<String, String> {
        public void accumulate(String acc, String in) {
        }

        public String createAccumulator() {
            return null;
        }
    }

    public static class ValidTableAggregateFunction
    extends TableAggregateFunction<String, String> {
        public void accumulate(String acc, String in) {
        }

        public void emitValue(String acc, Collector<String> out) {
        }

        public String createAccumulator() {
            return null;
        }
    }

    public static class PrivateMethodScalarFunction
    extends ScalarFunction {
        private String eval(int i) {
            return null;
        }
    }

    public static class MissingImplementationScalarFunction
    extends ScalarFunction {
    }

    private static class PrivateScalarFunction
    extends ScalarFunction {
        private PrivateScalarFunction() {
        }

        public String eval(int i) {
            return null;
        }
    }

    public static class ValidScalarFunction
    extends ScalarFunction {
        public String eval(int i) {
            return null;
        }
    }

    private static class TestSpec {
        @Nullable
        final Class<? extends UserDefinedFunction> functionClass;
        @Nullable
        final UserDefinedFunction functionInstance;
        @Nullable
        String expectedErrorMessage;

        TestSpec(Class<? extends UserDefinedFunction> functionClass) {
            this.functionClass = functionClass;
            this.functionInstance = null;
        }

        TestSpec(UserDefinedFunction functionInstance) {
            this.functionClass = null;
            this.functionInstance = functionInstance;
        }

        static TestSpec forClass(Class<? extends UserDefinedFunction> function) {
            return new TestSpec(function);
        }

        static TestSpec forInstance(UserDefinedFunction function) {
            return new TestSpec(function);
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        TestSpec expectSuccess() {
            this.expectedErrorMessage = null;
            return this;
        }
    }
}

