/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypesTest;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.TypeTestingUtils;
import org.junit.Assert;
import org.junit.Test;

public class DataTypeTest {
    @Test
    public void testNullability() {
        Assert.assertThat((Object)DataTypes.BIGINT().nullable(), TypeTestingUtils.hasNullability(true));
        Assert.assertThat((Object)DataTypes.BIGINT().notNull(), TypeTestingUtils.hasNullability(false));
        Assert.assertThat((Object)((DataType)DataTypes.BIGINT().notNull()).nullable(), TypeTestingUtils.hasNullability(true));
    }

    @Test
    public void testAtomicConversion() {
        Assert.assertThat((Object)DataTypes.TIMESTAMP((int)0).bridgedTo(Timestamp.class), TypeTestingUtils.hasConversionClass(Timestamp.class));
    }

    @Test
    public void testTolerantAtomicConversion() {
        Assert.assertThat((Object)((DataType)DataTypes.BIGINT().nullable()).bridgedTo(Long.TYPE), TypeTestingUtils.hasConversionClass(Long.TYPE));
    }

    @Test(expected=ValidationException.class)
    public void testInvalidAtomicConversion() {
        DataTypes.TIMESTAMP((int)0).bridgedTo(DataTypesTest.class);
    }

    @Test
    public void testArrayElementConversion() {
        Assert.assertThat((Object)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TypeTestingUtils.hasConversionClass(int[][].class));
    }

    @Test
    public void testTolerantArrayConversion() {
        Assert.assertThat((Object)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().nullable()))).bridgedTo(int[][].class), TypeTestingUtils.hasConversionClass(int[][].class));
    }

    @Test(expected=ValidationException.class)
    public void testInvalidArrayConversion() {
        DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())).bridgedTo(int[][][].class);
    }

    @Test
    public void testTolerantMapConversion() {
        Assert.assertThat((Object)DataTypes.MULTISET((DataType)DataTypes.MULTISET((DataType)((DataType)DataTypes.INT().bridgedTo(Integer.TYPE)))), TypeTestingUtils.hasConversionClass(Map.class));
    }

    @Test
    public void testFields() {
        DataType rowDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BOOLEAN())});
        HashMap<String, DataType> fields = new HashMap<String, DataType>();
        fields.put("field1", DataTypes.CHAR((int)2));
        fields.put("field2", DataTypes.BOOLEAN());
        Assert.assertEquals(fields, (Object)((FieldsDataType)rowDataType).getFieldDataTypes());
    }

    @Test(expected=ValidationException.class)
    public void testInvalidOrderInterval() {
        DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH(), (DataTypes.Resolution)DataTypes.YEAR((int)2));
    }

    @Test
    public void testConversionEquality() {
        Assert.assertEquals((Object)DataTypes.VARCHAR((int)2).bridgedTo(String.class), (Object)DataTypes.VARCHAR((int)2));
    }
}

