/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class LogicalTypesTest {
    private static final LogicalType UDT_NAME_TYPE = new VarCharType();
    private static final LogicalType UDT_SETTING_TYPE = new IntType();

    @Test
    public void testCharType() {
        LogicalTypesTest.testAll((LogicalType)new CharType(33), "CHAR(33)", "CHAR(33)", new Class[]{String.class, byte[].class}, new Class[]{String.class, byte[].class}, new LogicalType[0], (LogicalType)new CharType(Integer.MAX_VALUE));
    }

    @Test
    public void testVarCharType() {
        LogicalTypesTest.testAll((LogicalType)new VarCharType(33), "VARCHAR(33)", "VARCHAR(33)", new Class[]{String.class, byte[].class}, new Class[]{String.class, byte[].class}, new LogicalType[0], (LogicalType)new VarCharType(12));
    }

    @Test
    public void testVarCharTypeWithMaximumLength() {
        LogicalTypesTest.testAll((LogicalType)new VarCharType(Integer.MAX_VALUE), "VARCHAR(2147483647)", "STRING", new Class[]{String.class, byte[].class}, new Class[]{String.class, byte[].class}, new LogicalType[0], (LogicalType)new VarCharType(12));
    }

    @Test
    public void testBooleanType() {
        LogicalTypesTest.testAll((LogicalType)new BooleanType(), "BOOLEAN", "BOOLEAN", new Class[]{Boolean.class, Boolean.TYPE}, new Class[]{Boolean.class}, new LogicalType[0], (LogicalType)new BooleanType(false));
    }

    @Test
    public void testBinaryType() {
        LogicalTypesTest.testAll((LogicalType)new BinaryType(22), "BINARY(22)", "BINARY(22)", new Class[]{byte[].class}, new Class[]{byte[].class}, new LogicalType[0], (LogicalType)new BinaryType());
    }

    @Test
    public void testVarBinaryType() {
        LogicalTypesTest.testAll((LogicalType)new VarBinaryType(22), "VARBINARY(22)", "VARBINARY(22)", new Class[]{byte[].class}, new Class[]{byte[].class}, new LogicalType[0], (LogicalType)new VarBinaryType());
    }

    @Test
    public void testVarBinaryTypeWithMaximumLength() {
        LogicalTypesTest.testAll((LogicalType)new VarBinaryType(Integer.MAX_VALUE), "VARBINARY(2147483647)", "BYTES", new Class[]{byte[].class}, new Class[]{byte[].class}, new LogicalType[0], (LogicalType)new VarBinaryType(12));
    }

    @Test
    public void testDecimalType() {
        LogicalTypesTest.testAll((LogicalType)new DecimalType(10, 2), "DECIMAL(10, 2)", "DECIMAL(10, 2)", new Class[]{BigDecimal.class}, new Class[]{BigDecimal.class}, new LogicalType[0], (LogicalType)new DecimalType());
    }

    @Test
    public void testTinyIntType() {
        LogicalTypesTest.testAll((LogicalType)new TinyIntType(), "TINYINT", "TINYINT", new Class[]{Byte.class, Byte.TYPE}, new Class[]{Byte.class}, new LogicalType[0], (LogicalType)new TinyIntType(false));
    }

    @Test
    public void testSmallIntType() {
        LogicalTypesTest.testAll((LogicalType)new SmallIntType(), "SMALLINT", "SMALLINT", new Class[]{Short.class, Short.TYPE}, new Class[]{Short.class}, new LogicalType[0], (LogicalType)new SmallIntType(false));
    }

    @Test
    public void testIntType() {
        LogicalTypesTest.testAll((LogicalType)new IntType(), "INT", "INT", new Class[]{Integer.class, Integer.TYPE}, new Class[]{Integer.class}, new LogicalType[0], (LogicalType)new IntType(false));
    }

    @Test
    public void testBigIntType() {
        LogicalTypesTest.testAll((LogicalType)new BigIntType(), "BIGINT", "BIGINT", new Class[]{Long.class, Long.TYPE}, new Class[]{Long.class}, new LogicalType[0], (LogicalType)new BigIntType(false));
    }

    @Test
    public void testFloatType() {
        LogicalTypesTest.testAll((LogicalType)new FloatType(), "FLOAT", "FLOAT", new Class[]{Float.class, Float.TYPE}, new Class[]{Float.class}, new LogicalType[0], (LogicalType)new FloatType(false));
    }

    @Test
    public void testDoubleType() {
        LogicalTypesTest.testAll((LogicalType)new DoubleType(), "DOUBLE", "DOUBLE", new Class[]{Double.class, Double.TYPE}, new Class[]{Double.class}, new LogicalType[0], (LogicalType)new DoubleType(false));
    }

    @Test
    public void testDateType() {
        LogicalTypesTest.testAll((LogicalType)new DateType(), "DATE", "DATE", new Class[]{Date.class, LocalDate.class, Integer.TYPE}, new Class[]{LocalDate.class}, new LogicalType[0], (LogicalType)new DateType(false));
    }

    @Test
    public void testTimeType() {
        LogicalTypesTest.testAll((LogicalType)new TimeType(9), "TIME(9)", "TIME(9)", new Class[]{Time.class, LocalTime.class, Long.TYPE}, new Class[]{LocalTime.class}, new LogicalType[0], (LogicalType)new TimeType());
    }

    @Test
    public void testTimestampType() {
        LogicalTypesTest.testAll((LogicalType)new TimestampType(9), "TIMESTAMP(9)", "TIMESTAMP(9)", new Class[]{Timestamp.class, LocalDateTime.class}, new Class[]{LocalDateTime.class}, new LogicalType[0], (LogicalType)new TimestampType(3));
    }

    @Test
    public void testTimestampTypeWithTimeAttribute() {
        LogicalTypesTest.testAll((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 9), "TIMESTAMP(9)", "TIMESTAMP(9) *ROWTIME*", new Class[]{Timestamp.class, LocalDateTime.class}, new Class[]{LocalDateTime.class}, new LogicalType[0], (LogicalType)new TimestampType(3));
    }

    @Test
    public void testZonedTimestampType() {
        LogicalTypesTest.testAll((LogicalType)new ZonedTimestampType(9), "TIMESTAMP(9) WITH TIME ZONE", "TIMESTAMP(9) WITH TIME ZONE", new Class[]{ZonedDateTime.class, OffsetDateTime.class}, new Class[]{OffsetDateTime.class}, new LogicalType[0], (LogicalType)new ZonedTimestampType(3));
    }

    @Test
    public void testZonedTimestampTypeWithTimeAttribute() {
        LogicalTypesTest.testAll((LogicalType)new ZonedTimestampType(true, TimestampKind.PROCTIME, 9), "TIMESTAMP(9) WITH TIME ZONE", "TIMESTAMP(9) WITH TIME ZONE *PROCTIME*", new Class[]{ZonedDateTime.class, OffsetDateTime.class}, new Class[]{OffsetDateTime.class}, new LogicalType[0], (LogicalType)new ZonedTimestampType(3));
    }

    @Test
    public void testLocalZonedTimestampType() {
        LogicalTypesTest.testAll((LogicalType)new LocalZonedTimestampType(9), "TIMESTAMP(9) WITH LOCAL TIME ZONE", "TIMESTAMP(9) WITH LOCAL TIME ZONE", new Class[]{Instant.class, Long.TYPE, Integer.TYPE}, new Class[]{Instant.class}, new LogicalType[0], (LogicalType)new LocalZonedTimestampType(3));
    }

    @Test
    public void testLocalZonedTimestampTypeWithTimeAttribute() {
        LogicalTypesTest.testAll((LogicalType)new LocalZonedTimestampType(true, TimestampKind.ROWTIME, 9), "TIMESTAMP(9) WITH LOCAL TIME ZONE", "TIMESTAMP(9) WITH LOCAL TIME ZONE *ROWTIME*", new Class[]{Instant.class, Long.TYPE, Integer.TYPE}, new Class[]{Instant.class}, new LogicalType[0], (LogicalType)new LocalZonedTimestampType(3));
    }

    @Test
    public void testYearMonthIntervalType() {
        LogicalTypesTest.testAll((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, 2), "INTERVAL YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH", new Class[]{Period.class, Integer.TYPE}, new Class[]{Period.class}, new LogicalType[0], (LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH));
    }

    @Test
    public void testDayTimeIntervalType() {
        LogicalTypesTest.testAll((LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 6), "INTERVAL DAY(2) TO SECOND(6)", "INTERVAL DAY(2) TO SECOND(6)", new Class[]{Duration.class, Long.TYPE}, new Class[]{Duration.class}, new LogicalType[0], (LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 7));
    }

    @Test
    public void testArrayType() {
        LogicalTypesTest.testAll((LogicalType)new ArrayType((LogicalType)new TimestampType()), "ARRAY<TIMESTAMP(6)>", "ARRAY<TIMESTAMP(6)>", new Class[]{Timestamp[].class, LocalDateTime[].class}, new Class[]{Timestamp[].class, LocalDateTime[].class}, new LogicalType[]{new TimestampType()}, (LogicalType)new ArrayType((LogicalType)new SmallIntType()));
        LogicalTypesTest.testAll((LogicalType)new ArrayType((LogicalType)new ArrayType((LogicalType)new TimestampType())), "ARRAY<ARRAY<TIMESTAMP(6)>>", "ARRAY<ARRAY<TIMESTAMP(6)>>", new Class[]{Timestamp[][].class, LocalDateTime[][].class}, new Class[]{Timestamp[][].class, LocalDateTime[][].class}, new LogicalType[]{new ArrayType((LogicalType)new TimestampType())}, (LogicalType)new ArrayType((LogicalType)new ArrayType((LogicalType)new SmallIntType())));
        ArrayType nestedArray = new ArrayType((LogicalType)new ArrayType((LogicalType)new TimestampType()));
        Assert.assertFalse((boolean)nestedArray.supportsInputConversion(Timestamp[].class));
        Assert.assertFalse((boolean)nestedArray.supportsOutputConversion(Timestamp[].class));
    }

    @Test
    public void testMultisetType() {
        LogicalTypesTest.testAll((LogicalType)new MultisetType((LogicalType)new TimestampType()), "MULTISET<TIMESTAMP(6)>", "MULTISET<TIMESTAMP(6)>", new Class[]{Map.class, HashMap.class, TreeMap.class}, new Class[]{Map.class}, new LogicalType[]{new TimestampType()}, (LogicalType)new MultisetType((LogicalType)new SmallIntType()));
        LogicalTypesTest.testAll((LogicalType)new MultisetType((LogicalType)new MultisetType((LogicalType)new TimestampType())), "MULTISET<MULTISET<TIMESTAMP(6)>>", "MULTISET<MULTISET<TIMESTAMP(6)>>", new Class[]{Map.class, HashMap.class, TreeMap.class}, new Class[]{Map.class}, new LogicalType[]{new MultisetType((LogicalType)new TimestampType())}, (LogicalType)new MultisetType((LogicalType)new MultisetType((LogicalType)new SmallIntType())));
    }

    @Test
    public void testMapType() {
        LogicalTypesTest.testAll((LogicalType)new MapType((LogicalType)new VarCharType(20), (LogicalType)new TimestampType()), "MAP<VARCHAR(20), TIMESTAMP(6)>", "MAP<VARCHAR(20), TIMESTAMP(6)>", new Class[]{Map.class, HashMap.class, TreeMap.class}, new Class[]{Map.class}, new LogicalType[]{new VarCharType(20), new TimestampType()}, (LogicalType)new MapType((LogicalType)new VarCharType(99), (LogicalType)new TimestampType()));
    }

    @Test
    public void testRowType() {
        LogicalTypesTest.testAll((LogicalType)new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new VarCharType(), "Someone's desc."), new RowType.RowField("b`", (LogicalType)new TimestampType()))), "ROW<`a` VARCHAR(1) 'Someone''s desc.', `b``` TIMESTAMP(6)>", "ROW<`a` VARCHAR(1) '...', `b``` TIMESTAMP(6)>", new Class[]{Row.class}, new Class[]{Row.class}, new LogicalType[]{new VarCharType(), new TimestampType()}, (LogicalType)new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new VarCharType(), "Different desc."), new RowType.RowField("b`", (LogicalType)new TimestampType()))));
        try {
            new RowType(Arrays.asList(new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("a", (LogicalType)new VarCharType()), new RowType.RowField("a", (LogicalType)new TimestampType())));
            Assert.fail((String)"Not unique fields expected.");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        try {
            new RowType(Collections.singletonList(new RowType.RowField("", (LogicalType)new VarCharType())));
            Assert.fail((String)"Invalid name.");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Test
    public void testDistinctType() {
        LogicalTypesTest.testAll((LogicalType)this.createDistinctType("Money"), "`cat`.`db`.`Money`", "`cat`.`db`.`Money`", new Class[]{BigDecimal.class}, new Class[]{BigDecimal.class}, new LogicalType[]{new DecimalType(10, 2)}, (LogicalType)this.createDistinctType("Monetary"));
    }

    @Test
    public void testStructuredType() {
        LogicalTypesTest.testAll((LogicalType)this.createUserType(true, true), "`cat`.`db`.`User`", "`cat`.`db`.`User`", new Class[]{Row.class, User.class}, new Class[]{Row.class, Human.class, User.class}, new LogicalType[]{UDT_NAME_TYPE, UDT_SETTING_TYPE}, (LogicalType)this.createUserType(true, false));
        LogicalTypesTest.testConversions((LogicalType)this.createHumanType(false), new Class[]{Row.class, Human.class, User.class}, new Class[]{Row.class, Human.class});
        Assert.assertFalse((boolean)this.createUserType(true, true).supportsInputConversion(Human.class));
        Assert.assertFalse((boolean)this.createHumanType(true).supportsInputConversion(User.class));
    }

    @Test
    public void testNullType() {
        NullType nullType = new NullType();
        LogicalTypesTest.testEquality((LogicalType)nullType, (LogicalType)new TimeType());
        LogicalTypesTest.testJavaSerializability((LogicalType)nullType);
        LogicalTypesTest.testStringSerializability((LogicalType)nullType, "NULL");
        LogicalTypesTest.testStringSummary((LogicalType)nullType, "NULL");
        Assert.assertTrue((boolean)nullType.supportsInputConversion(Object.class));
        Assert.assertTrue((boolean)nullType.supportsOutputConversion(Object.class));
        Assert.assertTrue((boolean)nullType.supportsOutputConversion(Integer.class));
        Assert.assertFalse((boolean)nullType.supportsOutputConversion(Integer.TYPE));
    }

    @Test
    public void testTypeInformationRawType() {
        TypeInformationRawType rawType = new TypeInformationRawType(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT}));
        LogicalTypesTest.testEquality((LogicalType)rawType, (LogicalType)new TypeInformationRawType(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.LONG})));
        LogicalTypesTest.testStringSummary((LogicalType)rawType, "RAW('org.apache.flink.api.java.tuple.Tuple2', ?)");
        LogicalTypesTest.testNullability((LogicalType)rawType);
        LogicalTypesTest.testJavaSerializability((LogicalType)rawType);
        LogicalTypesTest.testConversions((LogicalType)rawType, new Class[]{Tuple2.class}, new Class[]{Tuple.class});
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)rawType);
    }

    @Test
    public void testRawType() {
        LogicalTypesTest.testAll((LogicalType)new RawType(Human.class, (TypeSerializer)new KryoSerializer(Human.class, new ExecutionConfig())), "RAW('org.apache.flink.table.types.LogicalTypesTest$Human', 'AEdvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uS3J5b1NlcmlhbGl6ZXJTbmFwc2hvdAAAAAIAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgAABPLGmj1wAAAAAgAzb3JnLmFwYWNoZS5mbGluay50YWJsZS50eXBlcy5Mb2dpY2FsVHlwZXNUZXN0JEh1bWFuAQAAADUAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgEAAAA5ADNvcmcuYXBhY2hlLmZsaW5rLnRhYmxlLnR5cGVzLkxvZ2ljYWxUeXBlc1Rlc3QkSHVtYW4AAAAAAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAArAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAC2AFVvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uU2VyaWFsaXplcnMkRHVtbXlBdnJvUmVnaXN0ZXJlZENsYXNzAAAAAQBZb3JnLmFwYWNoZS5mbGluay5hcGkuamF2YS50eXBldXRpbHMucnVudGltZS5rcnlvLlNlcmlhbGl6ZXJzJER1bW15QXZyb0tyeW9TZXJpYWxpemVyQ2xhc3MAAATyxpo9cAAAAAAAAATyxpo9cAAAAAA=')", "RAW('org.apache.flink.table.types.LogicalTypesTest$Human', '...')", new Class[]{Human.class, User.class}, new Class[]{Human.class}, new LogicalType[0], (LogicalType)new RawType(User.class, (TypeSerializer)new KryoSerializer(User.class, new ExecutionConfig())));
    }

    @Test
    public void testSymbolType() {
        SymbolType symbolType = new SymbolType(TimeIntervalUnit.class);
        LogicalTypesTest.testEquality((LogicalType)symbolType, (LogicalType)new SymbolType(TimePointUnit.class));
        LogicalTypesTest.testStringSummary((LogicalType)symbolType, "SYMBOL('" + TimeIntervalUnit.class.getName() + "')");
        LogicalTypesTest.testNullability((LogicalType)symbolType);
        LogicalTypesTest.testJavaSerializability((LogicalType)symbolType);
        LogicalTypesTest.testConversions((LogicalType)symbolType, new Class[]{TimeIntervalUnit.class}, new Class[]{TimeIntervalUnit.class});
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)symbolType);
    }

    @Test
    public void testUnresolvedUserDefinedType() {
        UnresolvedUserDefinedType unresolvedType = new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"catalog", "database", "Type"}));
        LogicalTypesTest.testEquality((LogicalType)unresolvedType, (LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"different", "database", "Type"})));
        LogicalTypesTest.testStringSummary((LogicalType)unresolvedType, "`catalog`.`database`.`Type`");
    }

    @Test
    public void testEmptyStringLiterals() {
        CharType charType = CharType.ofEmptyLiteral();
        VarCharType varcharType = VarCharType.ofEmptyLiteral();
        BinaryType binaryType = BinaryType.ofEmptyLiteral();
        VarBinaryType varBinaryType = VarBinaryType.ofEmptyLiteral();
        LogicalTypesTest.testEquality(charType.copy(true), (LogicalType)new CharType(1));
        LogicalTypesTest.testEquality(varcharType.copy(true), (LogicalType)new VarCharType(1));
        LogicalTypesTest.testEquality(binaryType.copy(true), (LogicalType)new BinaryType(1));
        LogicalTypesTest.testEquality(varBinaryType.copy(true), (LogicalType)new VarBinaryType(1));
        LogicalTypesTest.testStringSummary((LogicalType)charType, "CHAR(0) NOT NULL");
        LogicalTypesTest.testStringSummary((LogicalType)varcharType, "VARCHAR(0) NOT NULL");
        LogicalTypesTest.testStringSummary((LogicalType)binaryType, "BINARY(0) NOT NULL");
        LogicalTypesTest.testStringSummary((LogicalType)varBinaryType, "VARBINARY(0) NOT NULL");
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)charType);
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)varcharType);
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)binaryType);
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)varBinaryType);
    }

    @Test
    public void testUnregisteredStructuredType() {
        StructuredType structuredType = this.createUserType(false, true);
        LogicalTypesTest.testEquality((LogicalType)structuredType, (LogicalType)this.createUserType(false, false));
        LogicalTypesTest.testNullability((LogicalType)structuredType);
        LogicalTypesTest.testJavaSerializability((LogicalType)structuredType);
        LogicalTypesTest.testInvalidStringSerializability((LogicalType)structuredType);
        LogicalTypesTest.testStringSummary((LogicalType)structuredType, User.class.getName());
        LogicalTypesTest.testConversions((LogicalType)structuredType, new Class[]{Row.class, User.class}, new Class[]{Row.class, Human.class, User.class});
        LogicalTypesTest.testChildren((LogicalType)structuredType, new LogicalType[]{UDT_NAME_TYPE, UDT_SETTING_TYPE});
    }

    private static void testAll(LogicalType nullableType, String serializableString, String summaryString, Class[] supportedInputClasses, Class[] supportedOutputClasses, LogicalType[] children, LogicalType otherType) {
        LogicalTypesTest.testEquality(nullableType, otherType);
        LogicalTypesTest.testNullability(nullableType);
        LogicalTypesTest.testJavaSerializability(nullableType);
        LogicalTypesTest.testStringSerializability(nullableType, serializableString);
        LogicalTypesTest.testStringSummary(nullableType, summaryString);
        LogicalTypesTest.testConversions(nullableType, supportedInputClasses, supportedOutputClasses);
        LogicalTypesTest.testChildren(nullableType, children);
    }

    private static void testEquality(LogicalType nullableType, LogicalType otherType) {
        Assert.assertTrue((boolean)nullableType.isNullable());
        Assert.assertEquals((Object)nullableType, (Object)nullableType);
        Assert.assertEquals((long)nullableType.hashCode(), (long)nullableType.hashCode());
        Assert.assertEquals((Object)nullableType, (Object)nullableType.copy());
        Assert.assertNotEquals((Object)nullableType, (Object)otherType);
        Assert.assertNotEquals((long)nullableType.hashCode(), (long)otherType.hashCode());
    }

    private static void testNullability(LogicalType nullableType) {
        LogicalType notNullInstance = nullableType.copy(false);
        Assert.assertNotEquals((Object)nullableType, (Object)notNullInstance);
        Assert.assertFalse((boolean)notNullInstance.isNullable());
    }

    private static void testJavaSerializability(LogicalType serializableType) {
        try {
            LogicalType deserializedInstance = (LogicalType)InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)serializableType), (ClassLoader)LogicalTypesTest.class.getClassLoader());
            Assert.assertEquals((Object)serializableType, (Object)deserializedInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void testStringSerializability(LogicalType serializableType, String serializableString) {
        Assert.assertEquals((Object)serializableString, (Object)serializableType.asSerializableString());
    }

    private static void testInvalidStringSerializability(LogicalType nonSerializableType) {
        try {
            String serializedString = nonSerializableType.asSerializableString();
            Assert.fail((String)("No serializablility expected: " + serializedString));
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    private static void testStringSummary(LogicalType type, String summaryString) {
        Assert.assertEquals((Object)summaryString, (Object)type.asSummaryString());
    }

    private static void testConversions(LogicalType type, Class[] inputs, Class[] outputs) {
        for (Class clazz : inputs) {
            Assert.assertTrue((boolean)type.supportsInputConversion(clazz));
        }
        for (Class clazz : outputs) {
            Assert.assertTrue((boolean)type.supportsOutputConversion(clazz));
        }
        Assert.assertTrue((boolean)type.supportsInputConversion(type.getDefaultConversion()));
        Assert.assertTrue((boolean)type.supportsOutputConversion(type.getDefaultConversion()));
        Assert.assertFalse((boolean)type.supportsOutputConversion(LogicalTypesTest.class));
        Assert.assertFalse((boolean)type.supportsInputConversion(LogicalTypesTest.class));
    }

    private static void testChildren(LogicalType type, LogicalType[] children) {
        Assert.assertEquals(Arrays.asList(children), (Object)type.getChildren());
    }

    private DistinctType createDistinctType(String typeName) {
        return DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)typeName), (LogicalType)new DecimalType(10, 2)).description("Money type desc.").build();
    }

    private StructuredType createHumanType(boolean useDifferentImplementation) {
        return StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"Human"), useDifferentImplementation ? SpecialHuman.class : Human.class).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("name", UDT_NAME_TYPE, "Description."))).description("Human type desc.").setFinal(false).setInstantiable(false).build();
    }

    private StructuredType createUserType(boolean isRegistered, boolean isFinal) {
        StructuredType.Builder builder = isRegistered ? StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User"), User.class) : StructuredType.newBuilder(User.class);
        return builder.attributes(Collections.singletonList(new StructuredType.StructuredAttribute("setting", UDT_SETTING_TYPE))).description("User type desc.").setFinal(isFinal).setInstantiable(true).superType(this.createHumanType(false)).build();
    }

    private static final class User
    extends Human {
        public int setting;

        private User() {
        }
    }

    private static abstract class Human {
        public String name;

        private Human() {
        }
    }

    private static abstract class SpecialHuman {
        public String name;

        private SpecialHuman() {
        }
    }
}

