/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.HintFlag;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.utils.DataTypeHintMock;
import org.apache.flink.table.types.extraction.utils.DataTypeTemplate;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataTypeExtractorTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.forType(Integer.class).expectDataType(DataTypes.INT()), TestSpec.forType(byte[].class).expectDataType(DataTypes.BYTES()), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public Class<?> bridgedTo() {
                return Long.class;
            }
        }, Object.class).expectDataType(DataTypes.BIGINT()), TestSpec.forType(BigDecimal.class).expectErrorMessage("Values of 'java.math.BigDecimal' need fixed precision and scale."), TestSpec.forType(Object.class).expectErrorMessage("Cannot extract a data type from a pure 'java.lang.Object' class. Usually, this indicates that class information is missing or got lost. Please specify a more concrete class or treat it as a RAW type."), TestSpec.forType(Row.class).expectErrorMessage("Cannot extract a data type from a pure 'org.apache.flink.types.Row' class. Please use annotations to define field names and field types."), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public String value() {
                return "DECIMAL(5, 3)";
            }
        }, BigDecimal.class).expectDataType(DataTypes.DECIMAL((int)5, (int)3)), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public int defaultDecimalPrecision() {
                return 5;
            }

            @Override
            public int defaultDecimalScale() {
                return 3;
            }
        }, BigDecimal.class).expectDataType(DataTypes.DECIMAL((int)5, (int)3)), TestSpec.forType(Timestamp.class).expectDataType((DataType)DataTypes.TIMESTAMP((int)9).bridgedTo(Timestamp.class)), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public String value() {
                return "TIMESTAMP(0)";
            }
        }, Timestamp.class).expectDataType((DataType)DataTypes.TIMESTAMP((int)0).bridgedTo(Timestamp.class)), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public int defaultSecondPrecision() {
                return 6;
            }
        }, LocalDateTime.class).expectDataType(DataTypes.TIMESTAMP((int)6)), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public int defaultSecondPrecision() {
                return 3;
            }
        }, Duration.class).expectDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)3))), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public int defaultYearPrecision() {
                return 2;
            }
        }, Period.class).expectDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR((int)2), (DataTypes.Resolution)DataTypes.MONTH())), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public int defaultYearPrecision() {
                return 0;
            }
        }, Period.class).expectDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public HintFlag allowRawGlobally() {
                return HintFlag.TRUE;
            }
        }, Object[][].class).lookupExpects(Object.class).expectDataType(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.RAW((TypeInformation)new GenericTypeInfo(Object.class))))), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public String value() {
                return "RAW";
            }

            @Override
            public Class<? extends TypeSerializer<?>> rawSerializer() {
                return IntSerializer.class;
            }
        }, Integer.class).expectDataType(DataTypes.RAW(Integer.class, (TypeSerializer)new IntSerializer())), TestSpec.forType(new DataTypeHintMock(){

            @Override
            public String value() {
                return "RAW";
            }

            @Override
            public Class<?> bridgedTo() {
                return Integer.class;
            }
        }, Object.class).lookupExpects(Integer.class).expectDataType(DataTypes.RAW((TypeInformation)new GenericTypeInfo(Integer.class))), TestSpec.forGeneric(TableFunction.class, 0, TableFunctionWithMapLevel2.class).expectDataType(DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.BOOLEAN())), TestSpec.forGeneric(TableFunction.class, 0, TableFunctionWithGenericArray1.class).expectDataType(DataTypes.ARRAY((DataType)DataTypes.INT())), TestSpec.forGeneric(TableFunction.class, 0, TableFunctionWithHashMap.class).expectErrorMessage("Could not extract a data type from 'java.util.HashMap<java.lang.Integer, java.lang.String>'. Interpreting it as a structured type was also not successful."), TestSpec.forType(SimplePojo.class).expectDataType(DataTypeExtractorTest.getSimplePojoDataType(SimplePojo.class)), TestSpec.forType(ComplexPojo.class).lookupExpects(Object.class).expectDataType(DataTypeExtractorTest.getComplexPojoDataType(ComplexPojo.class, SimplePojo.class)), TestSpec.forType(SimplePojoWithGeneric.class).expectErrorMessage("Unresolved type variable 'S'. A data type cannot be extracted from a type variable. The original content might have been erased due to Java type erasure."), TestSpec.forGeneric(TableFunction.class, 0, TableFunctionWithGenericPojo.class).lookupExpects(Object.class).expectDataType(DataTypeExtractorTest.getComplexPojoDataType(ComplexPojoWithGeneric.class, SimplePojoWithGeneric.class)), TestSpec.forGeneric(BaseInterface.class, 0, ConcreteClass.class).expectDataType(DataTypes.STRING()), TestSpec.forType(SimplePojoWithGenericHierarchy.class).expectDataType(DataTypeExtractorTest.getSimplePojoDataType(SimplePojoWithGenericHierarchy.class)), TestSpec.forType(ComplexPojoWithGettersAndSetters.class).lookupExpects(Object.class).expectDataType(DataTypeExtractorTest.getComplexPojoDataType(ComplexPojoWithGettersAndSetters.class, SimplePojo.class)), TestSpec.forType(SimplePojoWithMissingSetter.class).expectErrorMessage("Field 'stringField' of class '" + SimplePojoWithMissingSetter.class.getName() + "' is mutable but is neither publicly accessible nor does it have a corresponding setter method."), TestSpec.forType(SimplePojoWithMissingGetter.class).expectErrorMessage("Field 'stringField' of class '" + SimplePojoWithMissingGetter.class.getName() + "' is neither publicly accessible nor does it have a corresponding getter method."), TestSpec.forType(SimplePojoWithAssigningConstructor.class).expectDataType(DataTypeExtractorTest.getSimplePojoDataType(SimplePojoWithAssigningConstructor.class)), TestSpec.forType(PojoWithCustomFieldOrder.class).expectDataType(DataTypeExtractorTest.getPojoWithCustomOrderDataType(PojoWithCustomFieldOrder.class)), TestSpec.forGeneric(TableFunction.class, 0, TableFunctionWithTuples.class).expectDataType(DataTypeExtractorTest.getOuterTupleDataType()), TestSpec.forType(SimplePojoWithManyAnnotations.class).expectDataType(DataTypeExtractorTest.getSimplePojoDataType(SimplePojoWithManyAnnotations.class)), TestSpec.forType(ComplexPojoWithManyAnnotations.class).lookupExpects(Object.class).expectDataType(DataTypeExtractorTest.getComplexPojoDataType(ComplexPojoWithManyAnnotations.class, SimplePojo.class)), TestSpec.forMethodParameter(IntegerVarArg.class, 1).expectDataType(DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forMethodParameter(IntegerVarArg.class, 0).expectDataType(DataTypes.INT()), TestSpec.forMethodOutput(IntegerVarArg.class).expectDataType(DataTypes.INT()));
    }

    @Test
    public void testExtraction() {
        if (this.testSpec.expectedErrorMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectCause(DataTypeExtractorTest.errorMatcher(this.testSpec));
        }
        DataTypeExtractorTest.runExtraction(this.testSpec);
    }

    static void runExtraction(TestSpec testSpec) {
        DataType dataType = (DataType)testSpec.extractor.apply(testSpec.typeFactory);
        if (testSpec.expectedDataType != null) {
            Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.equalTo((Object)testSpec.expectedDataType));
        }
    }

    static Matcher<Throwable> errorMatcher(TestSpec testSpec) {
        return org.apache.flink.util.CoreMatchers.containsCause((Throwable)new ValidationException(testSpec.expectedErrorMessage));
    }

    static DataType getSimplePojoDataType(Class<?> simplePojoClass) {
        StructuredType.Builder builder = StructuredType.newBuilder(simplePojoClass);
        builder.attributes(Arrays.asList(new StructuredType.StructuredAttribute("intField", (LogicalType)new IntType(true)), new StructuredType.StructuredAttribute("primitiveBooleanField", (LogicalType)new BooleanType(false)), new StructuredType.StructuredAttribute("primitiveIntField", (LogicalType)new IntType(false)), new StructuredType.StructuredAttribute("stringField", (LogicalType)new VarCharType(Integer.MAX_VALUE))));
        builder.setFinal(true);
        builder.setInstantiable(true);
        StructuredType structuredType = builder.build();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("intField", DataTypes.INT());
        fields.put("primitiveBooleanField", ((DataType)DataTypes.BOOLEAN().notNull()).bridgedTo(Boolean.TYPE));
        fields.put("primitiveIntField", ((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE));
        fields.put("stringField", DataTypes.STRING());
        return new FieldsDataType((LogicalType)structuredType, simplePojoClass, fields);
    }

    static DataType getComplexPojoDataType(Class<?> complexPojoClass, Class<?> simplePojoClass) {
        StructuredType.Builder builder = StructuredType.newBuilder(complexPojoClass);
        builder.attributes(Arrays.asList(new StructuredType.StructuredAttribute("mapField", (LogicalType)new MapType((LogicalType)new VarCharType(Integer.MAX_VALUE), (LogicalType)new IntType())), new StructuredType.StructuredAttribute("simplePojoField", DataTypeExtractorTest.getSimplePojoDataType(simplePojoClass).getLogicalType()), new StructuredType.StructuredAttribute("someObject", (LogicalType)new TypeInformationRawType((TypeInformation)new GenericTypeInfo(Object.class)))));
        builder.setFinal(true);
        builder.setInstantiable(true);
        StructuredType structuredType = builder.build();
        HashMap<String, DataType> fields = new HashMap<String, DataType>();
        fields.put("mapField", DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()));
        fields.put("simplePojoField", DataTypeExtractorTest.getSimplePojoDataType(simplePojoClass));
        fields.put("someObject", DataTypes.RAW((TypeInformation)new GenericTypeInfo(Object.class)));
        return new FieldsDataType((LogicalType)structuredType, complexPojoClass, fields);
    }

    public static DataType getPojoWithCustomOrderDataType(Class<?> pojoClass) {
        StructuredType.Builder builder = StructuredType.newBuilder(pojoClass);
        builder.attributes(Arrays.asList(new StructuredType.StructuredAttribute("z", (LogicalType)new BigIntType()), new StructuredType.StructuredAttribute("y", (LogicalType)new BooleanType()), new StructuredType.StructuredAttribute("x", (LogicalType)new IntType())));
        builder.setFinal(true);
        builder.setInstantiable(true);
        StructuredType structuredType = builder.build();
        HashMap<String, DataType> fields = new HashMap<String, DataType>();
        fields.put("z", DataTypes.BIGINT());
        fields.put("y", DataTypes.BOOLEAN());
        fields.put("x", DataTypes.INT());
        return new FieldsDataType((LogicalType)structuredType, pojoClass, fields);
    }

    private static DataType getOuterTupleDataType() {
        StructuredType.Builder builder = StructuredType.newBuilder(Tuple2.class);
        builder.attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new IntType()), new StructuredType.StructuredAttribute("f1", DataTypeExtractorTest.getInnerTupleDataType().getLogicalType())));
        builder.setFinal(true);
        builder.setInstantiable(true);
        StructuredType structuredType = builder.build();
        HashMap<String, DataType> fields = new HashMap<String, DataType>();
        fields.put("f0", DataTypes.INT());
        fields.put("f1", DataTypeExtractorTest.getInnerTupleDataType());
        return new FieldsDataType((LogicalType)structuredType, Tuple2.class, fields);
    }

    private static DataType getInnerTupleDataType() {
        StructuredType.Builder builder = StructuredType.newBuilder(Tuple2.class);
        builder.attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", (LogicalType)new VarCharType(Integer.MAX_VALUE)), new StructuredType.StructuredAttribute("f1", (LogicalType)new BooleanType())));
        builder.setFinal(true);
        builder.setInstantiable(true);
        StructuredType structuredType = builder.build();
        HashMap<String, DataType> fields = new HashMap<String, DataType>();
        fields.put("f0", DataTypes.STRING());
        fields.put("f1", DataTypes.BOOLEAN());
        return new FieldsDataType((LogicalType)structuredType, Tuple2.class, fields);
    }

    public static class IntegerVarArg
    extends VarArgMethod<Integer> {
    }

    public static class VarArgMethod<T> {
        public T eval(T i, int ... more) {
            return null;
        }
    }

    @DataTypeHint(allowRawPattern={"java.lang"})
    public static class ComplexPojoWithManyAnnotations {
        @DataTypeHint(value="MAP<STRING, INT>")
        public Object mapField;
        public SimplePojo simplePojoField;
        public Object someObject;
    }

    @DataTypeHint(forceRawPattern={"java.lang."})
    public static class SimplePojoWithManyAnnotations {
        @DataTypeHint(value="INT")
        public Integer intField;
        @DataTypeHint(bridgedTo=boolean.class)
        public Object primitiveBooleanField;
        @DataTypeHint(value="INT NOT NULL", bridgedTo=int.class)
        public Object primitiveIntField;
        @DataTypeHint(forceRawPattern={})
        public String stringField;
    }

    public static class PojoWithCustomFieldOrder {
        public Integer x;
        public Boolean y;
        public Long z;

        public PojoWithCustomFieldOrder(long z, boolean y, int x) {
            this.z = z;
            this.y = y;
            this.x = x;
        }

        public PojoWithCustomFieldOrder(long z, boolean y, int x, int additional) {
            this(z, y, x);
        }
    }

    private static class TableFunctionWithTuples
    extends TableFunction<Tuple2<Integer, Tuple2<String, Boolean>>> {
        private TableFunctionWithTuples() {
        }
    }

    public static class SimplePojoWithAssigningConstructor {
        public final Integer intField;
        public final boolean primitiveBooleanField;
        public final int primitiveIntField;
        public final String stringField;

        public SimplePojoWithAssigningConstructor(Integer intField, boolean primitiveBooleanField, int primitiveIntField, String stringField) {
            this.intField = intField;
            this.primitiveBooleanField = primitiveBooleanField;
            this.primitiveIntField = primitiveIntField;
            this.stringField = stringField;
        }
    }

    public static class SimplePojoWithMissingGetter {
        public Integer intField;
        public boolean primitiveBooleanField;
        public int primitiveIntField;
        private String stringField;

        public void setStringField(String stringField) {
            this.stringField = stringField;
        }
    }

    public static class SimplePojoWithMissingSetter {
        public Integer intField;
        public boolean primitiveBooleanField;
        public int primitiveIntField;
        private String stringField;

        public String getStringField() {
            return this.stringField;
        }
    }

    public static class ComplexPojoWithGettersAndSetters {
        private Map<String, Integer> mapField;
        private SimplePojo simplePojoField;
        @DataTypeHint(value="RAW")
        private Object someObject;

        public Map<String, Integer> getMapField() {
            return this.mapField;
        }

        public void setMapField(Map<String, Integer> mapField) {
            this.mapField = mapField;
        }

        public SimplePojo getSimplePojoField() {
            return this.simplePojoField;
        }

        public void setSimplePojoField(SimplePojo simplePojoField) {
            this.simplePojoField = simplePojoField;
        }

        public Object someObject() {
            return this.someObject;
        }

        public void someObject(Object someObject) {
            this.someObject = someObject;
        }
    }

    public static class SimplePojoWithGenericHierarchy
    extends SimplePojoWithGeneric<String> {
    }

    private static class ConcreteClass
    extends GenericClass<String> {
        private ConcreteClass() {
        }
    }

    private static abstract class GenericClass<T>
    implements Serializable,
    BaseInterface<T> {
        private GenericClass() {
        }
    }

    private static interface BaseInterface<T> {
    }

    public static class SimplePojoWithGeneric<S> {
        public Integer intField;
        public boolean primitiveBooleanField;
        public int primitiveIntField;
        public S stringField;
    }

    public static class ComplexPojoWithGeneric<S, I> {
        public Map<S, I> mapField;
        public SimplePojoWithGeneric<S> simplePojoField;
        @DataTypeHint(allowRawGlobally=HintFlag.TRUE)
        public Object someObject;
    }

    private static class TableFunctionWithGenericPojo
    extends TableFunction<ComplexPojoWithGeneric<String, Integer>> {
        private TableFunctionWithGenericPojo() {
        }
    }

    public static class SimplePojo {
        public Integer intField;
        public boolean primitiveBooleanField;
        public int primitiveIntField;
        public String stringField;
    }

    @DataTypeHint(allowRawGlobally=HintFlag.TRUE)
    public static class ComplexPojo {
        public Map<String, Integer> mapField;
        public SimplePojo simplePojoField;
        public Object someObject;
    }

    private static class TableFunctionWithHashMap
    extends TableFunction<HashMap<Integer, String>> {
        private TableFunctionWithHashMap() {
        }
    }

    private static class TableFunctionWithGenericArray1
    extends TableFunctionWithGenericArray0<Integer> {
        private TableFunctionWithGenericArray1() {
        }
    }

    private static class TableFunctionWithGenericArray0<T>
    extends TableFunction<T[]> {
        private TableFunctionWithGenericArray0() {
        }
    }

    private static class TableFunctionWithMapLevel2
    extends TableFunctionWithMapLevel1<Boolean> {
        private TableFunctionWithMapLevel2() {
        }
    }

    private static class TableFunctionWithMapLevel1<V>
    extends TableFunctionWithMapLevel0<Long, V> {
        private TableFunctionWithMapLevel1() {
        }
    }

    private static class TableFunctionWithMapLevel0<K, V>
    extends TableFunction<Map<K, V>> {
        private TableFunctionWithMapLevel0() {
        }
    }

    static class TestSpec {
        private final DataTypeFactoryMock typeFactory = new DataTypeFactoryMock();
        private final Function<DataTypeFactory, DataType> extractor;
        @Nullable
        private DataType expectedDataType;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(Function<DataTypeFactory, DataType> extractor) {
            this.extractor = extractor;
        }

        static TestSpec forType(Type type) {
            return new TestSpec(lookup -> DataTypeExtractor.extractFromType((DataTypeFactory)lookup, (Type)type));
        }

        static TestSpec forType(DataTypeHint hint, Type type) {
            return new TestSpec(lookup -> DataTypeExtractor.extractFromType((DataTypeFactory)lookup, (DataTypeTemplate)DataTypeTemplate.fromAnnotation((DataTypeFactory)lookup, (DataTypeHint)hint), (Type)type));
        }

        static TestSpec forGeneric(Class<?> baseClass, int genericPos, Type contextType) {
            return new TestSpec(lookup -> DataTypeExtractor.extractFromGeneric((DataTypeFactory)lookup, (Class)baseClass, (int)genericPos, (Type)contextType));
        }

        static TestSpec forMethodParameter(Class<?> clazz, int paramPos) {
            Method method = clazz.getMethods()[0];
            return new TestSpec(lookup -> DataTypeExtractor.extractFromMethodParameter((DataTypeFactory)lookup, (Class)clazz, (Method)method, (int)paramPos));
        }

        static TestSpec forMethodOutput(Class<?> clazz) {
            Method method = clazz.getMethods()[0];
            return new TestSpec(lookup -> DataTypeExtractor.extractFromMethodOutput((DataTypeFactory)lookup, (Class)clazz, (Method)method));
        }

        boolean hasErrorMessage() {
            return this.expectedErrorMessage != null;
        }

        TestSpec lookupExpects(Class<?> lookupClass) {
            this.typeFactory.dataType = Optional.of(DataTypes.RAW((TypeInformation)new GenericTypeInfo(lookupClass)));
            this.typeFactory.expectedClass = Optional.of(lookupClass);
            return this;
        }

        TestSpec expectDataType(DataType expectedDataType) {
            this.expectedDataType = expectedDataType;
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }
    }
}

