/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.util.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InputTypeStrategiesTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(DataTypes.INT(), DataTypes.INT()).expectSignature("f(*)").expectArgumentTypes(DataTypes.INT(), DataTypes.INT()), TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(new DataType[0]).expectSignature("f(*)").expectArgumentTypes(new DataType[0]), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.BOOLEAN()})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.BOOLEAN()).expectSignature("f(INT, BOOLEAN)").expectArgumentTypes((DataType)DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"expected", (DataType)DataTypes.INT())})})).calledWithArgumentTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"actual", (DataType)DataTypes.INT())})).expectSignature("f(ROW<`expected` INT>)").expectArgumentTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"expected", (DataType)DataTypes.INT())})), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((String[])new String[]{"i", "s"}, (DataType[])new DataType[]{DataTypes.INT(), DataTypes.STRING()})).calledWithArgumentTypes(DataTypes.INT()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(i INT, s STRING)"), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.BIGINT().notNull()})).calledWithArgumentTypes(DataTypes.BIGINT()).expectErrorMessage("Unsupported argument type. Expected type 'BIGINT NOT NULL' but actual type was 'BIGINT'."), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})).calledWithArgumentTypes(DataTypes.INT()).expectArgumentTypes(DataTypes.BIGINT()), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})).calledWithArgumentTypes(DataTypes.STRING()).expectErrorMessage("Unsupported argument type. Expected type 'BIGINT' but actual type was 'STRING'."), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.BIGINT()})).calledWithArgumentTypes(DataTypes.BIGINT()).expectErrorMessage("Invalid number of arguments. At least 2 arguments expected but 1 passed."), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY})).calledWithArgumentTypes(DataTypes.BIGINT()).expectSignature("f(<ANY>)").expectArgumentTypes(DataTypes.BIGINT()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY})).calledWithArgumentTypes(DataTypes.BIGINT(), DataTypes.BIGINT()).expectErrorMessage("Invalid number of arguments. At most 1 arguments expected but 2 passed."), TestSpec.forStrategy(InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.STRING()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{(DataType)DataTypes.INT().bridgedTo(Integer.TYPE)}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})})).calledWithArgumentTypes(DataTypes.INT()).calledWithArgumentTypes(DataTypes.TINYINT()).expectSignature("f(STRING)\nf(INT)\nf(BOOLEAN)").expectArgumentTypes((DataType)DataTypes.INT().bridgedTo(Integer.TYPE)), TestSpec.forStrategy(InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.TINYINT()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.INT()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BIGINT()})})).calledWithArgumentTypes(DataTypes.SMALLINT()).expectArgumentTypes(DataTypes.INT()), TestSpec.forStrategy(InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.INT()}), InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.STRING()})})).calledWithArgumentTypes(DataTypes.BOOLEAN()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(INT)\nf(STRING)"), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BOOLEAN()})).calledWithArgumentTypes(DataTypes.BOOLEAN(), DataTypes.INT()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(INT, BOOLEAN)"), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY, InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithArgumentTypes(DataTypes.BOOLEAN(), DataTypes.INT()).calledWithArgumentTypes(DataTypes.BOOLEAN(), DataTypes.TINYINT()).expectArgumentTypes(DataTypes.BOOLEAN(), DataTypes.INT()), TestSpec.forStrategy(InputTypeStrategies.sequence((String[])new String[]{"any", "int"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY, InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithArgumentTypes(DataTypes.STRING(), DataTypes.BOOLEAN()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(any <ANY>, int INT)"), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).expectSignature("f(INT, [BOOLEAN | INT])").calledWithArgumentTypes(DataTypes.INT(), DataTypes.INT()).calledWithArgumentTypes(DataTypes.TINYINT(), DataTypes.TINYINT()).expectArgumentTypes(DataTypes.INT(), DataTypes.INT()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())})})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.BIGINT()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(INT, [BOOLEAN | STRING])"), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.LITERAL})).calledWithLiteralAt(0).calledWithArgumentTypes(DataTypes.INT()).expectArgumentTypes(DataTypes.INT()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.and((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.LITERAL, InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithLiteralAt(0).calledWithArgumentTypes(DataTypes.STRING(), DataTypes.INT()).expectSignature("f([<LITERAL NOT NULL> & STRING], INT)").expectArgumentTypes(DataTypes.STRING(), DataTypes.INT()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.and((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.LITERAL_OR_NULL}), InputTypeStrategies.explicit((DataType)DataTypes.INT())})).calledWithArgumentTypes(DataTypes.STRING(), DataTypes.INT()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf([STRING & <LITERAL>], INT)"), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()).expectArgumentTypes(DataTypes.INT(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)))})).calledWithArgumentTypes(DataTypes.BOOLEAN(), DataTypes.BOOLEAN(), DataTypes.BOOLEAN()).expectSignature("f(var BOOLEAN...)").expectArgumentTypes((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE), (DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE), (DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.STRING()).expectArgumentTypes(DataTypes.INT(), DataTypes.STRING()), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(i INT, s STRING, var BOOLEAN...)"), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.INT(), DataTypes.BOOLEAN()).expectErrorMessage("Unsupported argument type. Expected type 'STRING' but actual type was 'INT'."), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.BOOLEAN()).expectArgumentTypes(DataTypes.INT(), DataTypes.STRING(), DataTypes.INT(), DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "s", "var"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN()), InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).calledWithArgumentTypes(DataTypes.INT(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()).expectErrorMessage("Invalid input arguments. Expected signatures are:\nf(i INT, s STRING, var [BOOLEAN | INT]...)"), TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()).expectSignature("f(*)").expectArgumentTypes(DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()), TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).typedArguments((DataType)DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.STRING(), DataTypes.BOOLEAN()).calledWithArgumentTypes(DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()).expectArgumentTypes((DataType)DataTypes.INT().bridgedTo(Integer.TYPE), DataTypes.STRING(), DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.OUTPUT_IF_NULL})).surroundingStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})).calledWithArgumentTypes(DataTypes.NULL(), DataTypes.STRING(), DataTypes.NULL()).expectSignature("f(<OUTPUT>, <OUTPUT>, <OUTPUT>)").expectArgumentTypes(DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).surroundingStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})).calledWithArgumentTypes(DataTypes.NULL()).expectSignature("f([<OUTPUT> | INT])").expectArgumentTypes(DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.explicitSequence((DataType[])new DataType[]{DataTypes.BOOLEAN()})).surroundingStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).calledWithArgumentTypes(DataTypes.NULL()).expectSignature("f(BOOLEAN)").expectArgumentTypes(DataTypes.BOOLEAN()), TestSpec.forStrategy(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.or((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.OUTPUT_IF_NULL, InputTypeStrategies.explicit((DataType)DataTypes.INT())})})).calledWithArgumentTypes(DataTypes.NULL()).expectSignature("f([<OUTPUT> | INT])").expectArgumentTypes(DataTypes.INT()), TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).typedArguments(DataTypes.INT(), DataTypes.STRING()).calledWithArgumentTypes(DataTypes.TINYINT(), DataTypes.STRING()).expectSignature("f(INT, STRING)").expectArgumentTypes(DataTypes.INT(), DataTypes.STRING()), TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).typedArguments(DataTypes.INT(), DataTypes.STRING()).calledWithArgumentTypes(DataTypes.STRING(), DataTypes.STRING()).expectErrorMessage("Invalid argument type at position 0. Data type INT expected but STRING passed."), TestSpec.forStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).namedArguments("i", "s").typedArguments(DataTypes.INT(), DataTypes.STRING()).expectSignature("f(i => INT, s => STRING)"));
    }

    @Test
    public void testStrategy() {
        if (this.testSpec.expectedSignature != null) {
            Assert.assertThat((Object)this.generateSignature(), (Matcher)org.hamcrest.CoreMatchers.equalTo((Object)this.testSpec.expectedSignature));
        }
        if (this.testSpec.expectedErrorMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectCause(CoreMatchers.containsCause((Throwable)new ValidationException(this.testSpec.expectedErrorMessage)));
        }
        for (List actualArgumentTypes : this.testSpec.actualArgumentTypes) {
            TypeInferenceUtil.Result result = this.runTypeInference(actualArgumentTypes);
            if (this.testSpec.expectedArgumentTypes == null) continue;
            Assert.assertThat((Object)result.getExpectedArgumentTypes(), (Matcher)org.hamcrest.CoreMatchers.equalTo((Object)this.testSpec.expectedArgumentTypes));
        }
    }

    private String generateSignature() {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        return TypeInferenceUtil.generateSignature((TypeInference)this.createTypeInference(), (String)"f", (FunctionDefinition)functionDefinitionMock);
    }

    private TypeInferenceUtil.Result runTypeInference(List<DataType> actualArgumentTypes) {
        TypeInferenceUtil.SurroundingInfo surroundingInfo;
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.typeFactory = new DataTypeFactoryMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = actualArgumentTypes;
        callContextMock.argumentLiterals = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos).collect(Collectors.toList());
        callContextMock.argumentNulls = IntStream.range(0, actualArgumentTypes.size()).mapToObj(i -> false).collect(Collectors.toList());
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        if (this.testSpec.surroundingStrategy != null) {
            TypeInference outerTypeInference = TypeInference.newBuilder().inputTypeStrategy(this.testSpec.surroundingStrategy).outputTypeStrategy(TypeStrategies.MISSING).build();
            surroundingInfo = new TypeInferenceUtil.SurroundingInfo("f_outer", (FunctionDefinition)functionDefinitionMock, outerTypeInference, 1, 0);
        } else {
            surroundingInfo = null;
        }
        return TypeInferenceUtil.runTypeInference((TypeInference)this.createTypeInference(), (CallContext)callContextMock, surroundingInfo);
    }

    private TypeInference createTypeInference() {
        TypeInference.Builder builder = TypeInference.newBuilder().inputTypeStrategy(this.testSpec.strategy).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN()));
        if (this.testSpec.namedArguments != null) {
            builder.namedArguments(this.testSpec.namedArguments);
        }
        if (this.testSpec.typedArguments != null) {
            builder.typedArguments(this.testSpec.typedArguments);
        }
        return builder.build();
    }

    private static class TestSpec {
        private final InputTypeStrategy strategy;
        @Nullable
        private List<String> namedArguments;
        @Nullable
        private List<DataType> typedArguments;
        private List<List<DataType>> actualArgumentTypes = new ArrayList<List<DataType>>();
        @Nullable
        private Integer literalPos;
        @Nullable
        private InputTypeStrategy surroundingStrategy;
        @Nullable
        private String expectedSignature;
        @Nullable
        private List<DataType> expectedArgumentTypes;
        @Nullable
        private String expectedErrorMessage;

        private TestSpec(InputTypeStrategy strategy) {
            this.strategy = strategy;
        }

        static TestSpec forStrategy(InputTypeStrategy strategy) {
            return new TestSpec(strategy);
        }

        TestSpec namedArguments(String ... names) {
            this.namedArguments = Arrays.asList(names);
            return this;
        }

        TestSpec typedArguments(DataType ... dataTypes) {
            this.typedArguments = Arrays.asList(dataTypes);
            return this;
        }

        TestSpec surroundingStrategy(InputTypeStrategy surroundingStrategy) {
            this.surroundingStrategy = surroundingStrategy;
            return this;
        }

        TestSpec calledWithArgumentTypes(DataType ... dataTypes) {
            this.actualArgumentTypes.add(Arrays.asList(dataTypes));
            return this;
        }

        TestSpec calledWithLiteralAt(int pos) {
            this.literalPos = pos;
            return this;
        }

        TestSpec expectSignature(String signature) {
            this.expectedSignature = signature;
            return this;
        }

        TestSpec expectArgumentTypes(DataType ... dataTypes) {
            this.expectedArgumentTypes = Arrays.asList(dataTypes);
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }
    }
}

