/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.Assert;
import org.junit.Test;

public class TypeTransformationsTest {
    @Test
    public void testTimeToSqlTypes() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"c", (DataType)DataTypes.TIMESTAMP((int)5)), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIME())), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)DataTypes.DATE(), (DataType)DataTypes.TIME((int)9))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)((DataType)DataTypes.TIMESTAMP().bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.TIME().bridgedTo(Time.class)))), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.DATE().bridgedTo(Date.class)), (DataType)((DataType)DataTypes.TIME((int)9).bridgedTo(Time.class)))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        Assert.assertEquals((Object)expected, (Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.timeToSqlTypes()}));
    }

    @Test
    public void testLegacyDecimalToDefaultDecimal() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"c", (DataType)TypeTransformationsTest.createLegacyDecimal()), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)TypeTransformationsTest.createLegacyDecimal()))});
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"c", (DataType)DataTypes.DECIMAL((int)38, (int)18)), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)38, (int)18)))});
        Assert.assertEquals((Object)expected, (Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.legacyDecimalToDefaultDecimal()}));
    }

    @Test
    public void testLegacyRawToTypeInfoRaw() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"c", (DataType)TypeTransformationsTest.createLegacyRaw()), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)TypeTransformationsTest.createLegacyRaw()))});
        TypeInformation typeInformation = TypeExtractor.getForClass(TypeTransformationsTest.class);
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DECIMAL((int)10, (int)3)), DataTypes.FIELD((String)"c", (DataType)DataTypes.RAW((TypeInformation)typeInformation)), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.RAW((TypeInformation)typeInformation)))});
        Assert.assertEquals((Object)expected, (Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.legacyRawToTypeInfoRaw()}));
    }

    @Test
    public void testToNullable() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"b", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"c", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).notNull())), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.TIME().notNull()))), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.DATE().notNull()), (DataType)((DataType)DataTypes.TIME((int)9).notNull()))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        DataType expected = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"b", (DataType)DataTypes.TIMESTAMP()), DataTypes.FIELD((String)"c", (DataType)DataTypes.TIMESTAMP((int)5)), DataTypes.FIELD((String)"d", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIME())), DataTypes.FIELD((String)"e", (DataType)DataTypes.MAP((DataType)DataTypes.DATE(), (DataType)DataTypes.TIME((int)9))), DataTypes.FIELD((String)"f", (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())});
        Assert.assertEquals((Object)expected, (Object)DataTypeUtils.transform((DataType)dataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.toNullable()}));
    }

    private static DataType createLegacyDecimal() {
        return TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.BIG_DEC);
    }

    private static DataType createLegacyRaw() {
        return TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.GENERIC(TypeTransformationsTest.class));
    }
}

