/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DataTypeUtilsTest {
    @Test
    public void testExpandRowType() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"f3", (DataType)DataTypes.TIMESTAMP((int)3))});
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class)).field("f3", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)).build()));
    }

    @Test
    public void testExpandLegacyCompositeType() {
        DataType dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)new TupleTypeInfo(new TypeInformation[]{Types.STRING, Types.INT, Types.SQL_TIMESTAMP}));
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.STRING()).field("f1", DataTypes.INT()).field("f2", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class)).build()));
    }

    @Test
    public void testExpandStructuredType() {
        StructuredType logicalType = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", DataTypes.INT().getLogicalType()), new StructuredType.StructuredAttribute("f1", DataTypes.STRING().getLogicalType()), new StructuredType.StructuredAttribute("f2", DataTypes.TIMESTAMP((int)5).getLogicalType()), new StructuredType.StructuredAttribute("f3", DataTypes.TIMESTAMP((int)3).getLogicalType()))).build();
        HashMap<String, Object> dataTypes = new HashMap<String, Object>();
        dataTypes.put("f0", DataTypes.INT());
        dataTypes.put("f1", DataTypes.STRING());
        dataTypes.put("f2", DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class));
        dataTypes.put("f3", DataTypes.TIMESTAMP((int)3));
        FieldsDataType dataType = new FieldsDataType((LogicalType)logicalType, dataTypes);
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class)).field("f3", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)).build()));
    }

    @Test
    public void testExpandDistinctType() {
        FieldsDataType dataType = (FieldsDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"f3", (DataType)DataTypes.TIMESTAMP((int)3))});
        LogicalType originalLogicalType = dataType.getLogicalType();
        DistinctType distinctLogicalType = DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type"), (LogicalType)originalLogicalType).build();
        FieldsDataType distinctDataType = new FieldsDataType((LogicalType)distinctLogicalType, dataType.getFieldDataTypes());
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)distinctDataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class)).field("f3", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)).build()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExpandThrowExceptionOnAtomicType() {
        DataTypeUtils.expandCompositeTypeToSchema((DataType)DataTypes.TIMESTAMP());
    }
}

