/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TypeMappingUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;

public class TypeMappingUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testFieldMappingReordered() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f1", DataTypes.BIGINT()).field("f0", DataTypes.STRING()).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}), Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{1, 0}));
    }

    @Test
    public void testFieldMappingNonMatchingTypes() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Type TIMESTAMP(3) of table field 'f0' does not match with the physical type STRING of the 'f0' field of the TableSource return type.");
        TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f1", DataTypes.BIGINT()).field("f0", DataTypes.TIMESTAMP((int)3)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}), Function.identity());
    }

    @Test
    public void testFieldMappingNonMatchingPrecision() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Type TIMESTAMP(9) of table field 'f0' does not match with the physical type TIMESTAMP(3) of the 'f0' field of the TableSource return type.");
        TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.TIMESTAMP((int)9)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.TIMESTAMP((int)3))}), Function.identity());
    }

    @Test
    public void testNameMappingDoesNotExist() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Field 'f0' could not be resolved by the field mapping.");
        TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.BIGINT()).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT())}), str -> null);
    }

    @Test
    public void testFieldMappingLegacyDecimalType() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)18)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.BIG_DEC))}), Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{0}));
    }

    @Test
    public void testFieldMappingLegacyDecimalTypeNotMatchingPrecision() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Type DECIMAL(38, 10) of table field 'f0' does not match with the physical type LEGACY('DECIMAL', 'DECIMAL') of the 'f0' field of the TableSource return type.");
        this.thrown.expectCause(CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(ValidationException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Legacy decimal type can only be mapped to DECIMAL(38, 18)."))));
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)10)).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.BIG_DEC))}), Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{0}));
    }

    @Test
    public void testFieldMappingRowTypeNotMatchingNamesInNestedType() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)18)).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"logical_f1_0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"logical_f1_1", (DataType)DataTypes.STRING())})).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)38, (int)18)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"physical_f1_0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"physical_f1_1", (DataType)DataTypes.STRING())}))}), Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{0, 1}));
    }

    @Test
    public void testFieldMappingRowTypeNotMatchingTypesInNestedType() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Type ROW<`f1_0` BIGINT, `f1_1` STRING> of table field 'f1' does not match with the physical type ROW<`f1_0` STRING, `f1_1` STRING> of the 'f1' field of the TableSource return type.");
        TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f0", DataTypes.DECIMAL((int)38, (int)18)).field("f1", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1_0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1_1", (DataType)DataTypes.STRING())})).build().getTableColumns(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.DECIMAL((int)38, (int)18)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1_0", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f1_1", (DataType)DataTypes.STRING())}))}), Function.identity());
    }

    @Test
    public void testFieldMappingLegacyCompositeType() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("f1", DataTypes.BIGINT()).field("f0", DataTypes.STRING()).build().getTableColumns(), (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.LONG})), Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{1, 0}));
    }

    @Test
    public void testFieldMappingLegacyCompositeTypeWithRenaming() {
        int[] indices = TypeMappingUtils.computePhysicalIndices((List)TableSchema.builder().field("a", DataTypes.BIGINT()).field("b", DataTypes.STRING()).build().getTableColumns(), (DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.LONG})), str -> {
            switch (str) {
                case "a": {
                    return "f1";
                }
                case "b": {
                    return "f0";
                }
            }
            throw new AssertionError();
        });
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{1, 0}));
    }

    @Test
    public void testMappingWithBatchTimeAttributes() {
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        int[] indices = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)false, Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{0, -3, -4}));
    }

    @Test
    public void testMappingWithStreamTimeAttributes() {
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        int[] indices = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)true, Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{0, -1, -2}));
    }

    @Test
    public void testMappingWithStreamTimeAttributesFromCompositeType() {
        TestTableSource tableSource = new TestTableSource(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.TIME()), DataTypes.FIELD((String)"a", (DataType)DataTypes.BIGINT())}), Collections.singletonList("rowtime"), "proctime");
        int[] indices = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)true, Function.identity());
        Assert.assertThat((Object)indices, (Matcher)CoreMatchers.equalTo((Object)new int[]{1, -1, -2}));
    }

    @Test
    public void testWrongLogicalTypeForRowtimeAttribute() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Rowtime field 'rowtime' has invalid type TIME(0). Rowtime attributes must be of a Timestamp family.");
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIME).field("proctime", Types.SQL_TIMESTAMP).build().getTableColumns(), (boolean)false, Function.identity());
    }

    @Test
    public void testWrongLogicalTypeForProctimeAttribute() {
        this.thrown.expect(ValidationException.class);
        this.thrown.expectMessage("Proctime field 'proctime' has invalid type TIME(0). Proctime attributes must be of a Timestamp family.");
        TestTableSource tableSource = new TestTableSource(DataTypes.BIGINT(), Collections.singletonList("rowtime"), "proctime");
        TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers((TableSource)tableSource, (List)TableSchema.builder().field("a", Types.LONG).field("rowtime", Types.SQL_TIMESTAMP).field("proctime", Types.SQL_TIME).build().getTableColumns(), (boolean)false, Function.identity());
    }

    private static class TestTableSource
    implements TableSource<Object>,
    DefinedProctimeAttribute,
    DefinedRowtimeAttributes {
        private final DataType producedDataType;
        private final List<String> rowtimeAttributes;
        private final String proctimeAttribute;

        private TestTableSource(DataType producedDataType, List<String> rowtimeAttributes, String proctimeAttribute) {
            this.producedDataType = producedDataType;
            this.rowtimeAttributes = rowtimeAttributes;
            this.proctimeAttribute = proctimeAttribute;
        }

        @Nullable
        public String getProctimeAttribute() {
            return this.proctimeAttribute;
        }

        public List<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptors() {
            return this.rowtimeAttributes.stream().map(attr -> new RowtimeAttributeDescriptor(attr, null, null)).collect(Collectors.toList());
        }

        public DataType getProducedDataType() {
            return this.producedDataType;
        }

        public TableSchema getTableSchema() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

