/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.LogicalTypesTest;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LogicalTypeCastAvoidanceTest {
    LogicalTypeCastAvoidanceTest() {
    }

    private static Stream<Arguments> testData() {
        return Stream.of(Arguments.of((Object[])new Object[]{new CharType(), new CharType(5), false}), Arguments.of((Object[])new Object[]{new VarCharType(30), new VarCharType(10), false}), Arguments.of((Object[])new Object[]{new VarCharType(10), new VarCharType(30), true}), Arguments.of((Object[])new Object[]{new CharType(10), new VarCharType(30), true}), Arguments.of((Object[])new Object[]{new BinaryType(10), new VarBinaryType(30), true}), Arguments.of((Object[])new Object[]{new CharType(false, 10), new VarCharType(30), true}), Arguments.of((Object[])new Object[]{new BinaryType(false, 10), new VarBinaryType(30), true}), Arguments.of((Object[])new Object[]{new VarCharType(30), new CharType(10), false}), Arguments.of((Object[])new Object[]{new VarBinaryType(30), new BinaryType(10), false}), Arguments.of((Object[])new Object[]{new BooleanType(), new BooleanType(false), false}), Arguments.of((Object[])new Object[]{new BinaryType(10), new BinaryType(30), false}), Arguments.of((Object[])new Object[]{new VarBinaryType(10), new VarBinaryType(30), true}), Arguments.of((Object[])new Object[]{new VarBinaryType(30), new VarBinaryType(10), false}), Arguments.of((Object[])new Object[]{new DecimalType(), new DecimalType(10, 2), false}), Arguments.of((Object[])new Object[]{new TinyIntType(), new TinyIntType(false), false}), Arguments.of((Object[])new Object[]{new SmallIntType(), new SmallIntType(false), false}), Arguments.of((Object[])new Object[]{new IntType(), new IntType(false), false}), Arguments.of((Object[])new Object[]{new IntType(false), new IntType(), true}), Arguments.of((Object[])new Object[]{new BigIntType(), new BigIntType(false), false}), Arguments.of((Object[])new Object[]{new FloatType(), new FloatType(false), false}), Arguments.of((Object[])new Object[]{new DoubleType(), new DoubleType(false), false}), Arguments.of((Object[])new Object[]{new DateType(), new DateType(false), false}), Arguments.of((Object[])new Object[]{new TimeType(), new TimeType(9), false}), Arguments.of((Object[])new Object[]{new TimestampType(9), new TimestampType(3), false}), Arguments.of((Object[])new Object[]{new ZonedTimestampType(9), new ZonedTimestampType(3), false}), Arguments.of((Object[])new Object[]{new ZonedTimestampType(false, TimestampKind.ROWTIME, 9), new ZonedTimestampType(3), false}), Arguments.of((Object[])new Object[]{new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, 2), new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH), false}), Arguments.of((Object[])new Object[]{new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 6), new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 7), false}), Arguments.of((Object[])new Object[]{new ArrayType((LogicalType)new TimestampType()), new ArrayType((LogicalType)new SmallIntType()), false}), Arguments.of((Object[])new Object[]{new MultisetType((LogicalType)new TimestampType()), new MultisetType((LogicalType)new SmallIntType()), false}), Arguments.of((Object[])new Object[]{new MapType((LogicalType)new VarCharType(10), (LogicalType)new TimestampType()), new MapType((LogicalType)new VarCharType(30), (LogicalType)new TimestampType()), true}), Arguments.of((Object[])new Object[]{new MapType((LogicalType)new VarCharType(30), (LogicalType)new TimestampType()), new MapType((LogicalType)new VarCharType(10), (LogicalType)new TimestampType()), false}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new VarCharType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("c", (LogicalType)new VarCharType()), new RowType.RowField("d", (LogicalType)new TimestampType()))), new RowType(Arrays.asList(new RowType.RowField("_a", (LogicalType)new VarCharType()), new RowType.RowField("_b", (LogicalType)new VarCharType()), new RowType.RowField("_c", (LogicalType)new VarCharType()), new RowType.RowField("_d", (LogicalType)new TimestampType()))), true}), Arguments.of((Object[])new Object[]{new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new VarCharType()))), new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new BooleanType()))), false}), Arguments.of((Object[])new Object[]{new ArrayType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), new ArrayType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f3", (LogicalType)new IntType()), new RowType.RowField("f4", (LogicalType)new IntType())))), true}), Arguments.of((Object[])new Object[]{new MapType((LogicalType)new IntType(), (LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), new MapType((LogicalType)new IntType(), (LogicalType)new RowType(Arrays.asList(new RowType.RowField("f3", (LogicalType)new IntType()), new RowType.RowField("f4", (LogicalType)new IntType())))), true}), Arguments.of((Object[])new Object[]{new MultisetType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), new MultisetType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new IntType()), new RowType.RowField("f2", (LogicalType)new IntType())))), true}), Arguments.of((Object[])new Object[]{new TypeInformationRawType(Types.GENERIC(LogicalTypesTest.class)), new TypeInformationRawType(Types.GENERIC(Object.class)), false}), Arguments.of((Object[])new Object[]{LogicalTypeCastAvoidanceTest.createUserType("User", new LogicalType[]{new IntType(), new VarCharType()}), LogicalTypeCastAvoidanceTest.createUserType("User", new LogicalType[]{new IntType(), new VarCharType()}), true}), Arguments.of((Object[])new Object[]{LogicalTypeCastAvoidanceTest.createUserType("User", new LogicalType[]{new IntType(), new VarCharType()}), LogicalTypeCastAvoidanceTest.createUserType("User2", new LogicalType[]{new IntType(), new VarCharType()}), false}), Arguments.of((Object[])new Object[]{LogicalTypeCastAvoidanceTest.createDistinctType("Money", (LogicalType)new DecimalType(10, 2)), LogicalTypeCastAvoidanceTest.createDistinctType("Money", (LogicalType)new DecimalType(10, 2)), true}), Arguments.of((Object[])new Object[]{LogicalTypeCastAvoidanceTest.createDistinctType("Money", (LogicalType)new DecimalType(10, 2)), LogicalTypeCastAvoidanceTest.createDistinctType("Money2", (LogicalType)new DecimalType(10, 2)), true}), Arguments.of((Object[])new Object[]{RowType.of((LogicalType[])new LogicalType[]{new IntType(), new VarCharType()}), LogicalTypeCastAvoidanceTest.createUserType("User2", new LogicalType[]{new IntType(), new VarCharType()}), true}), Arguments.of((Object[])new Object[]{RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new VarCharType()}), LogicalTypeCastAvoidanceTest.createUserType("User2", new LogicalType[]{new IntType(), new VarCharType()}), false}), Arguments.of((Object[])new Object[]{LogicalTypeCastAvoidanceTest.createUserType("User2", new LogicalType[]{new IntType(), new VarCharType()}), RowType.of((LogicalType[])new LogicalType[]{new IntType(), new VarCharType()}), true}), Arguments.of((Object[])new Object[]{LogicalTypeCastAvoidanceTest.createUserType("User2", new LogicalType[]{new IntType(), new VarCharType()}), RowType.of((LogicalType[])new LogicalType[]{new BigIntType(), new VarCharType()}), false}), Arguments.of((Object[])new Object[]{StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType(false)))).build(), StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType(true)))).build(), true}), Arguments.of((Object[])new Object[]{StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType(true)))).build(), StructuredType.newBuilder(Void.class).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f1", (LogicalType)new TimestampType()), new StructuredType.StructuredAttribute("diff", (LogicalType)new TinyIntType(false)))).build(), false}));
    }

    @ParameterizedTest(name="{index}: [{0} COMPATIBLE {1} => {2}")
    @MethodSource(value={"testData"})
    void testSupportsAvoidingCast(LogicalType sourceType, LogicalType targetType, boolean equals) {
        Assertions.assertThat((boolean)LogicalTypeCasts.supportsAvoidingCast((LogicalType)sourceType, (LogicalType)targetType)).isEqualTo(equals);
        Assertions.assertThat((boolean)LogicalTypeCasts.supportsAvoidingCast((LogicalType)sourceType, (LogicalType)sourceType.copy())).isTrue();
        Assertions.assertThat((boolean)LogicalTypeCasts.supportsAvoidingCast((LogicalType)targetType, (LogicalType)targetType.copy())).isTrue();
    }

    private static DistinctType createDistinctType(String name, LogicalType sourceType) {
        return DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)name), (LogicalType)sourceType).description("Money type desc.").build();
    }

    private static StructuredType createUserType(String name, LogicalType ... children) {
        return StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)name), User.class).attributes(Arrays.stream(children).map(lt -> new StructuredType.StructuredAttribute("field", lt)).collect(Collectors.toList())).description("User type desc.").setFinal(true).setInstantiable(true).build();
    }

    private static final class User {
        public int setting;

        private User() {
        }
    }
}

