/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.testutils.org.jboss.netty.channel.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.Channel;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.group.ChannelGroup;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.group.ChannelGroupFuture;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.apache.flink.shaded.testutils.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.shaded.testutils.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.internal.DeadLockProofWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelGroupFuture
implements ChannelGroupFuture {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelGroupFuture.class);
    private final ChannelGroup group;
    final Map<Integer, ChannelFuture> futures;
    private ChannelGroupFutureListener firstListener;
    private List<ChannelGroupFutureListener> otherListeners;
    private boolean done;
    int successCount;
    int failureCount;
    private int waiters;
    private final ChannelFutureListener childListener = new ChannelFutureListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            boolean callSetDone;
            boolean success = future.isSuccess();
            DefaultChannelGroupFuture defaultChannelGroupFuture = DefaultChannelGroupFuture.this;
            synchronized (defaultChannelGroupFuture) {
                if (success) {
                    ++DefaultChannelGroupFuture.this.successCount;
                } else {
                    ++DefaultChannelGroupFuture.this.failureCount;
                }
                boolean bl = callSetDone = DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount == DefaultChannelGroupFuture.this.futures.size();
                assert (DefaultChannelGroupFuture.this.successCount + DefaultChannelGroupFuture.this.failureCount <= DefaultChannelGroupFuture.this.futures.size());
            }
            if (callSetDone) {
                DefaultChannelGroupFuture.this.setDone();
            }
        }
    };

    public DefaultChannelGroupFuture(ChannelGroup group, Collection<ChannelFuture> futures) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (futures == null) {
            throw new NullPointerException("futures");
        }
        this.group = group;
        LinkedHashMap<Integer, ChannelFuture> futureMap = new LinkedHashMap<Integer, ChannelFuture>();
        for (ChannelFuture f : futures) {
            futureMap.put(f.getChannel().getId(), f);
        }
        this.futures = Collections.unmodifiableMap(futureMap);
        for (ChannelFuture f : this.futures.values()) {
            f.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setDone();
        }
    }

    DefaultChannelGroupFuture(ChannelGroup group, Map<Integer, ChannelFuture> futures) {
        this.group = group;
        this.futures = Collections.unmodifiableMap(futures);
        for (ChannelFuture f : this.futures.values()) {
            f.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setDone();
        }
    }

    @Override
    public ChannelGroup getGroup() {
        return this.group;
    }

    @Override
    public ChannelFuture find(Integer channelId) {
        return this.futures.get(channelId);
    }

    @Override
    public ChannelFuture find(Channel channel) {
        return this.futures.get(channel.getId());
    }

    @Override
    public Iterator<ChannelFuture> iterator() {
        return this.futures.values().iterator();
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized boolean isCompleteSuccess() {
        return this.successCount == this.futures.size();
    }

    @Override
    public synchronized boolean isPartialSuccess() {
        return this.successCount != 0 && this.successCount != this.futures.size();
    }

    @Override
    public synchronized boolean isPartialFailure() {
        return this.failureCount != 0 && this.failureCount != this.futures.size();
    }

    @Override
    public synchronized boolean isCompleteFailure() {
        int futureCnt = this.futures.size();
        return futureCnt != 0 && this.failureCount == futureCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ChannelGroupFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            if (this.done) {
                notifyNow = true;
            } else if (this.firstListener == null) {
                this.firstListener = listener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<ChannelGroupFutureListener>(1);
                }
                this.otherListeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ChannelGroupFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            if (!this.done) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelGroupFuture await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            while (!this.done) {
                Object var3_2;
                DefaultChannelGroupFuture.checkDeadLock();
                ++this.waiters;
                try {
                    this.wait();
                    var3_2 = null;
                    --this.waiters;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ChannelGroupFuture awaitUninterruptibly() {
        boolean interrupted = false;
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        // MONITORENTER : defaultChannelGroupFuture
        while (true) {
            Object var5_4;
            if (this.done) {
                // MONITOREXIT : defaultChannelGroupFuture
                if (!interrupted) return this;
                Thread.currentThread().interrupt();
                return this;
            }
            DefaultChannelGroupFuture.checkDeadLock();
            ++this.waiters;
            try {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    var5_4 = null;
                    --this.waiters;
                    continue;
                }
                var5_4 = null;
                --this.waiters;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                --this.waiters;
                throw throwable;
            }
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        block18: {
            block17: {
                if (interruptable && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                startTime = timeoutNanos <= 0L ? 0L : System.nanoTime();
                waitTime = timeoutNanos;
                interrupted = false;
                try {
                    var9_6 = this;
                    synchronized (var9_6) {
                        if (this.done || waitTime <= 0L) {
                            var10_7 = this.done;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 15] lbl11 : MonitorExitStatement: MONITOREXIT : var9_6
                            var15_11 = null;
                            if (interrupted == false) return var10_7;
                            Thread.currentThread().interrupt();
                            return var10_7;
                        }
                        DefaultChannelGroupFuture.checkDeadLock();
                        ++this.waiters;
                        while (true) {
                            try {
                                try {
                                    this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                                }
                                catch (InterruptedException e) {
                                    if (interruptable) {
                                        throw e;
                                    }
                                    interrupted = true;
                                }
                                if (!this.done) continue;
                                var10_9 = true;
                                var12_15 = null;
                                --this.waiters;
                                break block17;
                            }
                            catch (Throwable var11_18) {
                                var12_17 = null;
                                --this.waiters;
                                throw var11_18;
                            }
                            break;
                        }
                        {
                            if ((waitTime = timeoutNanos - (System.nanoTime() - startTime)) > 0L) ** continue;
                            var10_10 = this.done;
                            var12_16 = null;
                            --this.waiters;
                        }
                    }
                    break block18;
                }
                catch (Throwable var14_19) {
                    var15_14 = null;
                    if (interrupted == false) throw var14_19;
                    Thread.currentThread().interrupt();
                    throw var14_19;
                }
            }
            var15_12 = null;
            if (interrupted == false) return var10_9;
            Thread.currentThread().interrupt();
            return var10_9;
        }
        var15_13 = null;
        if (interrupted == false) return var10_10;
        Thread.currentThread().interrupt();
        return var10_10;
    }

    private static void checkDeadLock() {
        if (DeadLockProofWorker.PARENT.get() != null) {
            throw new IllegalStateException("await*() in I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setDone() {
        DefaultChannelGroupFuture defaultChannelGroupFuture = this;
        synchronized (defaultChannelGroupFuture) {
            if (this.done) {
                return false;
            }
            this.done = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        this.notifyListeners();
        return true;
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (ChannelGroupFutureListener l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(ChannelGroupFutureListener l) {
        block2: {
            try {
                l.operationComplete(this);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + ChannelFutureListener.class.getSimpleName() + '.', t);
            }
        }
    }
}

